/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.db;

import com.sun.xmlsearch.db.Block;
import com.sun.xmlsearch.db.BlockFactory;
import com.sun.xmlsearch.db.BlockManager;
import com.sun.xmlsearch.db.BlockStack;
import com.sun.xmlsearch.db.EdgePrinter;
import com.sun.xmlsearch.db.VectorBtreeIterator;
import com.sun.xmlsearch.db.VectorBtreeParameters;
import com.sun.xmlsearch.db.VectorProcessor;

public class VectorBtree {
    protected VectorBlock _root;
    protected BlockManager _blockManager;
    protected VectorBtreeParameters _params;
    protected int _vecLen;
    protected int _blockSize;
    protected int _maxEntries;
    protected int _leafDataLimit;
    protected int _vectorsOffset;
    protected EdgePrinter _printer = new EdgePrinter();

    protected VectorBtree() {
    }

    public VectorBtree(VectorBtreeParameters vectorBtreeParameters) throws Exception {
        this._params = vectorBtreeParameters;
        this._vecLen = vectorBtreeParameters.getVectorLength();
        this._blockSize = vectorBtreeParameters.getBlockSize();
        this._maxEntries = (this._blockSize - 8 - 4) / (this._vecLen + 4);
        if ((this._maxEntries & 1) == 0) {
            --this._maxEntries;
        }
        this._leafDataLimit = this._blockSize - this._vecLen - 8 - 4;
        this._vectorsOffset = (this._maxEntries + 1) * 4;
        this._blockManager = new BlockManager(vectorBtreeParameters, false, new BlockFactory(){

            public Block makeBlock() {
                return new VectorBlock(VectorBtree.this._blockSize);
            }
        });
        this._root = this.accessBlock(vectorBtreeParameters.getRootPosition());
    }

    public VectorBtreeIterator makeIterator() {
        return new VectorBtreeIterator(this, new byte[this._vecLen]);
    }

    public int getVectorLength() {
        return this._vecLen;
    }

    protected void lock(Block block) {
        this._blockManager.lockBlock(block._number);
    }

    protected void unlock(Block block) {
        this._blockManager.unlockBlock(block._number);
    }

    public boolean find(byte[] byArray) throws Exception {
        return this.treeSearch(this._root, byArray);
    }

    private boolean treeSearch(VectorBlock vectorBlock, byte[] byArray) throws Exception {
        if (vectorBlock._isLeaf) {
            return vectorBlock.searchLeafBlock(byArray);
        }
        int n = vectorBlock.findIndex(byArray);
        return n < 0 || this.treeSearch(this.accessChild(vectorBlock, n), byArray);
    }

    protected int vector(int n) {
        return this._vectorsOffset + this._vecLen * n;
    }

    protected static int memcmp(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] != byArray2[n]) {
                return (byArray[n3] & 0xFF) - (byArray2[n] & 0xFF);
            }
            ++n3;
            ++n;
        }
        return 0;
    }

    protected VectorBlock accessBlock(int n) throws Exception {
        return (VectorBlock)this._blockManager.accessBlock(n);
    }

    protected VectorBlock accessChild(Block block, int n) throws Exception {
        return this.accessBlock(block.integerAt(n * 4));
    }

    public int getIteratorBufferLength() {
        return this._blockSize + this._vecLen * 2;
    }

    public boolean mapProcessor(VectorBlock vectorBlock, VectorProcessor vectorProcessor) throws Exception {
        block5: {
            System.out.println("block: " + vectorBlock._number + " " + vectorBlock._isLeaf + " " + vectorBlock._free);
            if (vectorBlock._isLeaf) {
                return vectorBlock.processLeafBlock(vectorProcessor);
            }
            byte[] byArray = vectorProcessor.getVectorBuffer();
            this.lock(vectorBlock);
            for (int i = 0; i < vectorBlock._free; ++i) {
                System.out.println("mapping " + i);
                if (!this.mapProcessor(this.accessBlock(vectorBlock.integerAt(4 * i)), vectorProcessor)) {
                    System.arraycopy(vectorBlock._data, this.vector(i), byArray, 0, this._vecLen);
                    System.out.println("internal ");
                    if (!vectorProcessor.processVector()) {
                        continue;
                    }
                }
                break block5;
            }
            System.out.println("mapping " + vectorBlock._free);
            System.out.println("last internal ");
            System.out.println(vectorBlock._number + " at " + vectorBlock._free + " = " + vectorBlock.integerAt(4 * vectorBlock._free));
            if (!this.mapProcessor(this.accessBlock(vectorBlock.integerAt(4 * vectorBlock._free)), vectorProcessor)) {
                this.unlock(vectorBlock);
                return false;
            }
        }
        this.unlock(vectorBlock);
        return true;
    }

    public boolean FindVectors1(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, BlockStack blockStack) throws Exception {
        int n3 = 0;
        blockStack.clear();
        VectorBlock vectorBlock = this._root;
        while (!vectorBlock._isLeaf) {
            n3 = vectorBlock.findIndex(byArray);
            if (n3 < 0) {
                int n4 = -n3;
                if (n4 < vectorBlock._free && VectorBtree.memcmp(byArray2, vectorBlock._data, this.vector(n4), n2) >= 0) {
                    blockStack.push(vectorBlock._number, n4);
                }
                vectorBlock = this.accessChild(vectorBlock, n4);
                while (!vectorBlock._isLeaf) {
                    if (VectorBtree.memcmp(byArray2, vectorBlock._data, this.vector(0), n2) >= 0) {
                        blockStack.push(vectorBlock._number, 0);
                    }
                    vectorBlock = this.accessChild(vectorBlock, 0);
                }
                if (VectorBtree.memcmp(byArray, vectorBlock._data, 1, n2) <= 0 && VectorBtree.memcmp(byArray2, vectorBlock._data, 1, n2) >= 0) {
                    int n5 = vectorBlock._free - 1 - n;
                    byArray3[0] = (byte)n;
                    System.arraycopy(vectorBlock._data, n + 1, byArray3, 1, n5);
                    byArray3[n5 + 1] = 0;
                    return true;
                }
                if (blockStack.size() != 0) {
                    System.err.println("stack not empty");
                }
                return false;
            }
            if (n3 < vectorBlock._free && VectorBtree.memcmp(byArray2, vectorBlock._data, this.vector(n3), n2) >= 0) {
                blockStack.push(vectorBlock._number, n3);
            }
            vectorBlock = this.accessChild(vectorBlock, n3);
        }
        if (vectorBlock.FindVectorsInLeaf(byArray, byArray2, n, n2, byArray3, this.getIteratorBufferLength()) > 0) {
            return true;
        }
        if (blockStack.size() > 0) {
            this.FindVectors2(byArray, byArray2, n, n2, byArray3, blockStack);
            return true;
        }
        return false;
    }

    public void FindVectors2(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, BlockStack blockStack) throws Exception {
        VectorBlock vectorBlock = this.accessBlock(blockStack.topBlockNumber());
        int n3 = blockStack.topIndex();
        byArray3[0] = (byte)n;
        System.arraycopy(vectorBlock._data, this.vector(n3) + n, byArray3, 1, this._vecLen - n);
        int n4 = this._vecLen - n + 1;
        if (++n3 < vectorBlock._free && (blockStack.size() > 1 || VectorBtree.memcmp(byArray2, vectorBlock._data, this.vector(n3), n2) >= 0)) {
            blockStack.increaseIndex();
        } else {
            blockStack.pop();
        }
        vectorBlock = this.accessChild(vectorBlock, n3);
        while (!vectorBlock._isLeaf) {
            if (VectorBtree.memcmp(byArray2, vectorBlock._data, this.vector(0), n2) >= 0) {
                blockStack.push(vectorBlock._number, 0);
            }
            vectorBlock = this.accessChild(vectorBlock, 0);
        }
        int n5 = 1;
        if (VectorBtree.memcmp(byArray, vectorBlock._data, n5, n2) <= 0 && VectorBtree.memcmp(byArray2, vectorBlock._data, n5, n2) >= 0) {
            byArray3[n4++] = (byte)n;
            int n6 = vectorBlock._free - (n5 += n);
            System.arraycopy(vectorBlock._data, n5, byArray3, n4, n6);
            n4 += n6;
        }
        byArray3[n4] = 0;
    }

    protected class VectorBlock
    extends Block {
        public VectorBlock(int n) {
            super(n);
        }

        protected int findIndex(byte[] byArray) {
            int n = 0;
            int n2 = this._free - 1;
            while (n <= n2) {
                int n3 = (n + n2) / 2;
                int n4 = VectorBtree.memcmp(byArray, this._data, VectorBtree.this.vector(n3), VectorBtree.this._vecLen);
                if (n4 > 0) {
                    n = n3 + 1;
                    continue;
                }
                if (n4 < 0) {
                    n2 = n3 - 1;
                    continue;
                }
                return -1 - n3;
            }
            return n;
        }

        private int FindVectorsInLeaf(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) {
            int n4;
            int n5 = 0;
            int n6 = 0;
            block0: while (true) {
                if (this._data[n5] == n6) {
                    int n7;
                    for (n7 = n6; n7 < VectorBtree.this._vecLen; ++n7) {
                        if (byArray[n7] == this._data[++n5]) {
                            ++n6;
                            continue;
                        }
                        if ((byArray[n7] & 0xFF) < (this._data[n5] & 0xFF)) {
                            if (n6 >= n && (n7 >= n2 || (byArray2[n7] & 0xFF) >= (this._data[n5] & 0xFF))) {
                                n4 = n6;
                                break block0;
                            }
                            return 0;
                        }
                        n5 += VectorBtree.this._vecLen - n7;
                        continue block0;
                    }
                    if (n7 != VectorBtree.this._vecLen) continue;
                    if ((this._data[++n5] & 0xFF) >= n2) {
                        n4 = this._data[n5++] & 0xFF;
                        break;
                    }
                    return 0;
                }
                if (this._data[n5] < n6) {
                    System.out.println(n5);
                    n6 = this._data[n5++];
                    System.out.println(n6);
                    if (n6 < n) {
                        return 0;
                    }
                    if (byArray[n6] < (this._data[n5] & 0xFF)) {
                        if (byArray2[n6] < (this._data[n5] & 0xFF)) {
                            return 0;
                        }
                        n4 = n6;
                        break;
                    }
                    n5 += VectorBtree.this._vecLen - n6;
                    continue;
                }
                if ((this._data[n5] & 0xFF) == 255) {
                    return 0;
                }
                n5 += VectorBtree.this._vecLen + 1 - this._data[n5];
            }
            n6 = Math.min(n3 - n4, this._free - n5);
            byArray3[0] = (byte)n4;
            System.arraycopy(this._data, n5, byArray3, 1, n6);
            byArray3[n6 + 1] = 0;
            return n6 + 1;
        }

        protected boolean searchLeafBlock(byte[] byArray) {
            this.processLeafBlock(VectorBtree.this._printer);
            int n = 0;
            int n2 = 0;
            while (true) {
                block8: {
                    if (this._data[n2] == n) {
                        int n3 = this._data[n2];
                        int n4 = n2 + 1;
                        while (n3 < VectorBtree.this._vecLen) {
                            if (byArray[n3] != this._data[n4]) {
                                if ((byArray[n3] & 0xFF) < (this._data[n4] & 0xFF)) {
                                    return false;
                                }
                                break block8;
                            }
                            ++n;
                            ++n3;
                            ++n4;
                        }
                        if (n3 == VectorBtree.this._vecLen) {
                            return true;
                        }
                    } else if (this._data[n2] < n) {
                        return false;
                    }
                }
                n2 += VectorBtree.this._vecLen + 1 - this._data[n2];
            }
        }

        public boolean processLeafBlock(VectorProcessor vectorProcessor) {
            byte[] byArray = vectorProcessor.getVectorBuffer();
            for (int i = 0; i < this._free; i += VectorBtree.this._vecLen - this._data[i] + 1) {
                System.arraycopy(this._data, i + 1, byArray, this._data[i], VectorBtree.this._vecLen - this._data[i]);
                if (!vectorProcessor.processVector()) continue;
                return true;
            }
            return false;
        }
    }
}

