/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.net.URL;
import java.util.Hashtable;
import org.mozilla.javascript.Scriptable;

public class OfficeScriptInfo {
    private Hashtable loadedSFScripts = new Hashtable();

    public void addScript(URL uRL, Scriptable scriptable, Runnable runnable) {
        this.addScript(uRL.toString(), uRL, scriptable, runnable);
    }

    public void addScript(String string, URL uRL, Scriptable scriptable, Runnable runnable) {
        SFScriptInfo sFScriptInfo = (SFScriptInfo)this.loadedSFScripts.get(string);
        if (sFScriptInfo == null) {
            sFScriptInfo = new SFScriptInfo();
            sFScriptInfo.url = uRL;
            sFScriptInfo.scope = scriptable;
            sFScriptInfo.closeCallback = runnable;
            this.loadedSFScripts.put(string, sFScriptInfo);
        }
    }

    public void deleteScript(String string) {
        SFScriptInfo sFScriptInfo = (SFScriptInfo)this.loadedSFScripts.remove(string);
        if (sFScriptInfo != null && sFScriptInfo.closeCallback != null) {
            System.out.println("** In removeSFScriptInfo  have callback for " + string);
            sFScriptInfo.closeCallback.run();
        }
    }

    public Scriptable getScriptScope(String string) {
        Scriptable scriptable = null;
        SFScriptInfo sFScriptInfo = (SFScriptInfo)this.loadedSFScripts.get(string);
        if (sFScriptInfo != null) {
            scriptable = sFScriptInfo.scope;
        }
        return scriptable;
    }

    public URL getScriptUrl(String string) {
        URL uRL = null;
        SFScriptInfo sFScriptInfo = (SFScriptInfo)this.loadedSFScripts.get(string);
        if (sFScriptInfo != null) {
            uRL = sFScriptInfo.url;
        }
        return uRL;
    }

    public boolean hasScript(String string) {
        boolean bl = true;
        SFScriptInfo sFScriptInfo = (SFScriptInfo)this.loadedSFScripts.get(string);
        if (sFScriptInfo == null) {
            bl = false;
        }
        return bl;
    }

    public void setScriptRunning(String string, boolean bl) {
        SFScriptInfo sFScriptInfo = (SFScriptInfo)this.loadedSFScripts.get(string);
        if (sFScriptInfo != null) {
            sFScriptInfo.isExecuting = bl;
        }
    }

    public boolean isScriptRunning(String string) {
        boolean bl = false;
        SFScriptInfo sFScriptInfo = (SFScriptInfo)this.loadedSFScripts.get(string);
        if (sFScriptInfo != null) {
            bl = sFScriptInfo.isExecuting;
        }
        return bl;
    }

    class SFScriptInfo {
        Scriptable scope;
        boolean isExecuting;
        URL url;
        Runnable closeCallback;

        SFScriptInfo() {
        }
    }
}

