/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import org.hsqldb.lib.IntValueHashMap;

public class ArrayUtil {
    public static final int CLASS_CODE_BYTE = 66;
    public static final int CLASS_CODE_CHAR = 67;
    public static final int CLASS_CODE_DOUBLE = 68;
    public static final int CLASS_CODE_FLOAT = 70;
    public static final int CLASS_CODE_INT = 73;
    public static final int CLASS_CODE_LONG = 74;
    public static final int CLASS_CODE_OBJECT = 76;
    public static final int CLASS_CODE_SHORT = 83;
    public static final int CLASS_CODE_BOOLEAN = 90;
    private static IntValueHashMap classCodeMap = new IntValueHashMap();
    static /* synthetic */ Class class$java$lang$Object;

    static int getClassCode(Class clazz) {
        if (!clazz.isPrimitive()) {
            return 76;
        }
        return classCodeMap.get((Object)clazz, -1);
    }

    public static void clearArray(int n, Object object, int n2, int n3) {
        switch (n) {
            case 66: {
                byte[] byArray = (byte[])object;
                while (--n3 >= n2) {
                    byArray[n3] = 0;
                }
                return;
            }
            case 67: {
                byte[] byArray = (byte[])object;
                while (--n3 >= n2) {
                    byArray[n3] = 0;
                }
                return;
            }
            case 83: {
                short[] sArray = (short[])object;
                while (--n3 >= n2) {
                    sArray[n3] = 0;
                }
                return;
            }
            case 73: {
                int[] nArray = (int[])object;
                while (--n3 >= n2) {
                    nArray[n3] = 0;
                }
                return;
            }
            case 74: {
                long[] lArray = (long[])object;
                while (--n3 >= n2) {
                    lArray[n3] = 0L;
                }
                return;
            }
            case 70: {
                float[] fArray = (float[])object;
                while (--n3 >= n2) {
                    fArray[n3] = 0.0f;
                }
                return;
            }
            case 68: {
                double[] dArray = (double[])object;
                while (--n3 >= n2) {
                    dArray[n3] = 0.0;
                }
                return;
            }
            case 90: {
                boolean[] blArray = (boolean[])object;
                while (--n3 >= n2) {
                    blArray[n3] = false;
                }
                return;
            }
        }
        Object[] objectArray = (Object[])object;
        while (--n3 >= n2) {
            objectArray[n3] = null;
        }
    }

    public static void adjustArray(int n, Object object, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (n3 >= n2) {
            return;
        }
        int n8 = n2 + n4;
        if (n4 >= 0) {
            n7 = n3;
            n6 = n3 + n4;
            n5 = n2 - n3;
        } else {
            n7 = n3 - n4;
            n6 = n3;
            n5 = n2 - n3 + n4;
        }
        if (n5 > 0) {
            System.arraycopy(object, n7, object, n6, n5);
        }
        if (n4 < 0) {
            ArrayUtil.clearArray(n, object, n8, n2);
        }
    }

    public static void sortArray(int[] nArray) {
        boolean bl;
        do {
            bl = false;
            for (int i = 0; i < nArray.length - 1; ++i) {
                if (nArray[i] <= nArray[i + 1]) continue;
                int n = nArray[i + 1];
                nArray[i + 1] = nArray[i];
                nArray[i] = n;
                bl = true;
            }
        } while (bl);
    }

    public static int find(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == object) {
                return i;
            }
            if (object == null || !object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static int find(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int findNot(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            return i;
        }
        return -1;
    }

    public static boolean areEqualSets(int[] nArray, int[] nArray2) {
        return nArray.length == nArray2.length && ArrayUtil.haveEqualSets(nArray, nArray2, nArray.length);
    }

    public static boolean areEqual(int[] nArray, int[] nArray2, int n, boolean bl) {
        if (ArrayUtil.haveEqualArrays(nArray, nArray2, n)) {
            if (bl) {
                return nArray.length == nArray2.length && n == nArray.length;
            }
            return true;
        }
        return false;
    }

    public static boolean haveEqualSets(int[] nArray, int[] nArray2, int n) {
        if (n > nArray.length || n > nArray2.length) {
            return false;
        }
        if (n == 1) {
            return nArray[0] == nArray2[0];
        }
        int[] nArray3 = (int[])ArrayUtil.resizeArray(nArray, n);
        int[] nArray4 = (int[])ArrayUtil.resizeArray(nArray2, n);
        ArrayUtil.sortArray(nArray3);
        ArrayUtil.sortArray(nArray4);
        for (int i = 0; i < n; ++i) {
            if (nArray3[i] == nArray4[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(int[] nArray, int[] nArray2, int n) {
        if (n > nArray.length || n > nArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(Object[] objectArray, Object[] objectArray2, int n) {
        if (n > objectArray.length || n > objectArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] == objectArray2[i] || objectArray[i] != null && objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean haveCommonElement(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            for (int j = 0; j < n; ++j) {
                if (n2 != nArray2[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] commonElements(int[] nArray, int[] nArray2) {
        int[] nArray3 = null;
        int n = ArrayUtil.countCommonElements(nArray, nArray2);
        if (n > 0) {
            nArray3 = new int[n];
            int n2 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray[i] != nArray2[j]) continue;
                    nArray3[n2++] = nArray[i];
                }
            }
        }
        return nArray3;
    }

    public static int countCommonElements(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] != nArray2[j]) continue;
                ++n;
            }
        }
        return n;
    }

    public static int countSameElements(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        int n3 = byArray.length - n;
        if (n3 > byArray2.length) {
            n3 = byArray2.length;
        }
        for (int i = 0; i < n3 && byArray[i + n] == byArray2[i]; ++i) {
            ++n2;
        }
        return n2;
    }

    public static int find(byte[] byArray, int n, int n2, byte[] byArray2) {
        n2 = n2 - byArray2.length + 1;
        byte by = byArray2[0];
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] != by) continue;
            if (byArray2.length == 1) {
                return i;
            }
            if (!ArrayUtil.containsAt(byArray, i, byArray2)) continue;
            return i;
        }
        return -1;
    }

    public static int findNotIn(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = 0;
        if (n3 < n2) {
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray[n3] != byArray2[i]) continue;
            }
            return n3;
        }
        return -1;
    }

    public static int findIn(byte[] byArray, int n, int n2, byte[] byArray2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[i] != byArray2[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int find(byte[] byArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] != n3 && byArray[i] != n4) continue;
            return i;
        }
        return -1;
    }

    public static void intIndexesToBooleanArray(int[] nArray, boolean[] blArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= blArray.length) continue;
            blArray[nArray[i]] = true;
        }
    }

    public static boolean containsAllTrueElements(boolean[] blArray, boolean[] blArray2) {
        boolean bl = false;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray2[i] || blArray[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAt(byte[] byArray, int n, byte[] byArray2) {
        return ArrayUtil.countSameElements(byArray, n, byArray2) == byArray2.length;
    }

    public static int countStartElementsAt(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        block0: for (int i = n; i < byArray.length; ++i) {
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[i] != byArray2[j]) continue;
                ++n2;
                continue block0;
            }
        }
        return n2;
    }

    public static int countNonStartElementsAt(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        block0: for (int i = n; i < byArray.length; ++i) {
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[i] == byArray2[j]) break block0;
            }
            ++n2;
        }
        return n2;
    }

    public static void copyArray(Object object, Object object2, int n) {
        System.arraycopy(object, 0, object2, 0, n);
    }

    public static int[] arraySlice(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        return nArray2;
    }

    public static void fillArray(Object[] objectArray, Object object) {
        int n = objectArray.length;
        while (--n >= 0) {
            objectArray[n] = object;
        }
    }

    public static void fillArray(int[] nArray, int n) {
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray[n2] = n;
        }
    }

    public static Object duplicateArray(Object object) {
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    public static Object resizeArrayIfDifferent(Object object, int n) {
        int n2 = Array.getLength(object);
        if (n2 == n) {
            return object;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        if (n2 < n) {
            n = n2;
        }
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    public static Object resizeArray(Object object, int n) {
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        int n2 = Array.getLength(object);
        if (n2 < n) {
            n = n2;
        }
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    public static Object toAdjustedArray(Object object, Object object2, int n, int n2) {
        int n3 = Array.getLength(object) + n2;
        Object object3 = Array.newInstance(object.getClass().getComponentType(), n3);
        ArrayUtil.copyAdjustArray(object, object3, object2, n, n2);
        return object3;
    }

    public static void copyAdjustArray(Object object, Object object2, Object object3, int n, int n2) {
        int n3 = Array.getLength(object);
        if (n < 0) {
            System.arraycopy(object, 0, object2, 0, n3);
            return;
        }
        System.arraycopy(object, 0, object2, 0, n);
        if (n2 == 0) {
            int n4 = n3 - n - 1;
            Array.set(object2, n, object3);
            if (n4 > 0) {
                System.arraycopy(object, n + 1, object2, n + 1, n4);
            }
        } else if (n2 < 0) {
            int n5 = n3 - n - 1;
            if (n5 > 0) {
                System.arraycopy(object, n + 1, object2, n, n5);
            }
        } else {
            int n6 = n3 - n;
            Array.set(object2, n, object3);
            if (n6 > 0) {
                System.arraycopy(object, n, object2, n + 1, n6);
            }
        }
    }

    public static int[] toAdjustedColumnArray(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > n) {
                nArray2[n3] = nArray[i] + n2;
                ++n3;
                continue;
            }
            if (nArray[i] == n) {
                if (n2 < 0) continue;
                nArray2[n3] = nArray[i] + n2;
                ++n3;
                continue;
            }
            nArray2[n3] = nArray[i];
            ++n3;
        }
        if (nArray.length != n3) {
            int[] nArray3 = new int[n3];
            ArrayUtil.copyArray(nArray2, nArray3, n3);
            return nArray3;
        }
        return nArray2;
    }

    public static void copyColumnValues(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            objectArray2[i] = objectArray[nArray[i]];
        }
    }

    public static void copyColumnValues(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < nArray2.length; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
    }

    public static void fillSequence(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        classCodeMap.put(Byte.TYPE, 66);
        classCodeMap.put(Character.TYPE, 83);
        classCodeMap.put(Short.TYPE, 83);
        classCodeMap.put(Integer.TYPE, 73);
        classCodeMap.put(Long.TYPE, 74);
        classCodeMap.put(Float.TYPE, 70);
        classCodeMap.put(Double.TYPE, 68);
        classCodeMap.put(Boolean.TYPE, 90);
        classCodeMap.put(class$java$lang$Object == null ? (class$java$lang$Object = ArrayUtil.class$("java.lang.Object")) : class$java$lang$Object, 76);
    }
}

