/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.BorderRemover;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.OSHelper;
import convwatch.PixelCounter;
import convwatch.StatusHelper;
import convwatch.StringHelper;
import helper.ProcessHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import util.utils;

public class PRNCompare {
    String fs = System.getProperty("file.separator");
    String m_sInputPath;
    String m_sReferencePath;
    String m_sOutputPath;
    String m_sDocFile;
    String m_sReferenceFile;
    String m_sPostScriptFile;
    int m_nMaxPages = 0;
    int m_nResolutionInDPI = 0;
    boolean m_bUseBorderMove;

    String executeSynchronously(String string) {
        ProcessHandler processHandler = new ProcessHandler(string);
        boolean bl = processHandler.executeSynchronously();
        String string2 = processHandler.getOutputText();
        GlobalLogWriter.get().println("Exitcode: " + String.valueOf(processHandler.getExitCode()));
        return string2;
    }

    int getMaxNumOfFileEntry(String string, String string2) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            String string3 = fileArray[i].getName();
            if (!string3.endsWith(".jpg")) continue;
            int n2 = n;
            if (string3.startsWith(string2)) {
                int n3 = string3.lastIndexOf(".jpg");
                String string4 = string3.substring(string2.length(), n3);
                int n4 = 0;
                try {
                    n4 = Integer.valueOf(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                n2 = n4;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void setInputPath(String string) {
        this.m_sInputPath = string;
    }

    public void setReferencePath(String string) {
        this.m_sReferencePath = string;
    }

    public void setOutputPath(String string) {
        this.m_sOutputPath = string;
    }

    public void setDocFile(String string) {
        this.m_sDocFile = string;
    }

    public void setReferenceFile(String string) {
        this.m_sReferenceFile = string;
    }

    public void setPostScriptFile(String string) {
        this.m_sPostScriptFile = string;
    }

    public void setBorderMove(boolean bl) {
        this.m_bUseBorderMove = bl;
    }

    public void setMaxPages(int n) {
        this.m_nMaxPages = n;
    }

    int getMaxPages() {
        return this.m_nMaxPages;
    }

    public void setResolutionInDPI(int n) {
        this.m_nResolutionInDPI = n;
    }

    int getResolutionInDPI() {
        return this.m_nResolutionInDPI;
    }

    public StatusHelper[] compare() {
        PRNCompare.createJPEGFromPostscript(this.m_sOutputPath, this.m_sReferencePath, this.m_sReferenceFile, this.getResolutionInDPI());
        PRNCompare.createJPEGFromPostscript(this.m_sOutputPath, this.m_sOutputPath, this.m_sPostScriptFile, this.getResolutionInDPI());
        StatusHelper[] statusHelperArray = this.createDiffs(this.m_sOutputPath, this.m_sOutputPath, this.m_sReferenceFile, this.m_sOutputPath, this.m_sPostScriptFile, this.getMaxPages(), this.m_bUseBorderMove);
        return statusHelperArray;
    }

    public StatusHelper[] compare_new() {
        String[] stringArray = PRNCompare.createJPEGFromPostscript(this.m_sOutputPath, this.m_sReferencePath, this.m_sReferenceFile, this.getResolutionInDPI());
        String[] stringArray2 = PRNCompare.createJPEGFromPostscript(this.m_sOutputPath, this.m_sOutputPath, this.m_sPostScriptFile, this.getResolutionInDPI());
        StatusHelper[] statusHelperArray = this.createDiffs(this.m_sOutputPath, stringArray, stringArray2, this.getMaxPages(), this.m_bUseBorderMove);
        return statusHelperArray;
    }

    static String getJPEGName(String string, String string2, String string3) {
        String string4 = System.getProperty("file.separator");
        String string5 = string + string4 + string2 + string3 + ".jpg";
        return string5;
    }

    public static String[] createJPEGFromPostscript(String string, String string2, String string3, int n) {
        String string4;
        String string5 = "%04d";
        FileHelper.makeDirectories("", string);
        String string6 = System.getProperty("file.separator");
        String string7 = PRNCompare.getJPEGName(string, string3, string5);
        String string8 = string2 + string6 + string3;
        String string9 = "gs";
        if (OSHelper.isWindows()) {
            string9 = "gswin32c.exe";
        }
        String string10 = string9 + " -dNOPROMPT -dBATCH -sDEVICE=jpeg -r" + String.valueOf(n) + " -dNOPAUSE -sOutputFile=" + StringHelper.doubleQuoteIfNeed(string7) + " " + StringHelper.doubleQuoteIfNeed(string8);
        String[] stringArray = new String[]{string9, "-dNOPROMPT", "-dBATCH", "-sDEVICE=jpeg", "-r" + String.valueOf(n), "-dNOPAUSE", "-sOutputFile=" + string7, string8};
        ProcessHandler processHandler = new ProcessHandler(stringArray);
        boolean bl = processHandler.executeSynchronously();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < 9999 && FileHelper.exists(string4 = utils.replaceAll13(string7, string5, StringHelper.createValueString(i, 4))); ++i) {
            arrayList.add(string4);
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public StatusHelper[] createDiffs(String string, String string2, String string3, String string4, String string5, int n, boolean bl) {
        if (n < 1) {
            n = 1;
        }
        String string6 = FileHelper.getBasename(string3);
        String string7 = FileHelper.getBasename(string5);
        int n2 = this.getMaxNumOfFileEntry(string2, string6);
        int n3 = this.getMaxNumOfFileEntry(string4, string7);
        int n4 = Math.min(n2, n3);
        n4 = Math.min(n4, n);
        StatusHelper[] statusHelperArray = new StatusHelper[n4];
        int n5 = 0;
        for (int i = 1; i <= n4; ++i) {
            StatusHelper statusHelper;
            block10: {
                String string8 = PRNCompare.getJPEGName(string2, string6, StringHelper.createValueString(i, 4));
                String string9 = PRNCompare.getJPEGName(string4, string7, StringHelper.createValueString(i, 4));
                String string10 = PRNCompare.getJPEGName(string, string6 + ".diff", StringHelper.createValueString(i, 4));
                String string11 = PRNCompare.compareJPEGs(string8, string9, string10);
                statusHelper = new StatusHelper(string8, string9, string11);
                if (string11.length() > 0) {
                    int n6 = this.identify(string11);
                    if (n6 == 1) {
                        statusHelper.nDiffStatus = 2;
                    } else {
                        try {
                            int n7 = this.estimateGfx(string8, string9, string11);
                            statusHelper.nDiffStatus = 3;
                            statusHelper.nPercent = n7;
                            if (n7 <= 75 || !bl) break block10;
                            String string12 = PRNCompare.getJPEGName(string2, string6 + ".BM", StringHelper.createValueString(i, 4));
                            String string13 = PRNCompare.getJPEGName(string4, string7 + ".BM", StringHelper.createValueString(i, 4));
                            String string14 = PRNCompare.getJPEGName(string, string6 + ".diff.BM", StringHelper.createValueString(i, 4));
                            statusHelper.setFilesForBorderMove(string12, string13, string14);
                            try {
                                BorderRemover borderRemover = new BorderRemover();
                                borderRemover.createNewImageWithoutBorder(string8, string12);
                                borderRemover.createNewImageWithoutBorder(string9, string13);
                                String string15 = PRNCompare.compareJPEGs(string12, string13, string14);
                                if (string15.length() <= 0) break block10;
                                n6 = this.identify(string15);
                                if (n6 == 1) {
                                    statusHelper.nDiffStatus = 4;
                                    statusHelper.nPercent2 = 0;
                                    break block10;
                                }
                                n7 = this.estimateGfx(string12, string13, string15);
                                statusHelper.nDiffStatus = 5;
                                statusHelper.nPercent2 = n7;
                            }
                            catch (IOException iOException) {
                                GlobalLogWriter.get().println("Exception caught. At border moveing" + iOException.getMessage());
                            }
                        }
                        catch (IOException iOException) {
                            GlobalLogWriter.get().println(iOException.getMessage());
                        }
                    }
                }
            }
            statusHelperArray[n5++] = statusHelper;
        }
        return statusHelperArray;
    }

    public StatusHelper[] createDiffs(String string, String[] stringArray, String[] stringArray2, int n, boolean bl) {
        if (n < 1) {
            n = 1;
        }
        int n2 = Math.min(stringArray.length, stringArray2.length);
        n2 = Math.min(n2, n);
        StatusHelper[] statusHelperArray = new StatusHelper[n2];
        int n3 = 0;
        for (int i = 1; i <= n2; ++i) {
            StatusHelper statusHelper;
            block10: {
                String string2 = stringArray[i];
                String string3 = stringArray2[i];
                String string4 = PRNCompare.compareJPEGs(string2, string3);
                statusHelper = new StatusHelper(string2, string3, string4);
                if (string4.length() > 0) {
                    int n4 = this.identify(string4);
                    if (n4 == 1) {
                        statusHelper.nDiffStatus = 2;
                    } else {
                        try {
                            int n5 = this.estimateGfx(string2, string3, string4);
                            statusHelper.nDiffStatus = 3;
                            statusHelper.nPercent = n5;
                            if (n5 <= 75 || !bl) break block10;
                            String string5 = FileHelper.getBasename(string2);
                            String string6 = FileHelper.getNameNoSuffix(string5);
                            String string7 = FileHelper.getBasename(string3);
                            String string8 = FileHelper.getNameNoSuffix(string7);
                            String string9 = utils.getUsersTempDir();
                            String string10 = System.getProperty("file.separator");
                            String string11 = string9 + string10 + string6 + "-BM-" + StringHelper.createValueString(i, 4) + ".jpg";
                            String string12 = string9 + string10 + string8 + "-BM-" + StringHelper.createValueString(i, 4) + ".jpg";
                            try {
                                BorderRemover borderRemover = new BorderRemover();
                                borderRemover.createNewImageWithoutBorder(string2, string11);
                                borderRemover.createNewImageWithoutBorder(string3, string12);
                                String string13 = PRNCompare.compareJPEGs(string11, string12);
                                statusHelper.setFilesForBorderMove(string11, string12, string13);
                                if (string13.length() <= 0) break block10;
                                n4 = this.identify(string13);
                                if (n4 == 1) {
                                    statusHelper.nDiffStatus = 4;
                                    statusHelper.nPercent2 = 0;
                                    break block10;
                                }
                                n5 = this.estimateGfx(string11, string12, string13);
                                statusHelper.nDiffStatus = 5;
                                statusHelper.nPercent2 = n5;
                            }
                            catch (IOException iOException) {
                                GlobalLogWriter.get().println("Exception caught. At border moveing" + iOException.getMessage());
                            }
                        }
                        catch (IOException iOException) {
                            GlobalLogWriter.get().println(iOException.getMessage());
                        }
                    }
                }
            }
            statusHelperArray[n3++] = statusHelper;
        }
        return statusHelperArray;
    }

    public static String compareJPEGs(String string, String string2) {
        String string3 = FileHelper.getBasename(string);
        String string4 = FileHelper.getNameNoSuffix(string3);
        String string5 = FileHelper.getBasename(string2);
        String string6 = FileHelper.getNameNoSuffix(string5);
        String string7 = utils.getUsersTempDir();
        String string8 = System.getProperty("file.separator");
        String string9 = string7 + string8 + string4 + "-" + string6 + "-diff.jpg";
        return PRNCompare.compareJPEGs(string, string2, string9);
    }

    public static String compareJPEGs(String string, String string2, String string3) {
        String string4 = "composite";
        if (OSHelper.isWindows()) {
            string4 = "composite.exe";
        }
        String[] stringArray = new String[]{string4, "-compose", "difference", string, string2, string3};
        ProcessHandler processHandler = new ProcessHandler(stringArray);
        boolean bl = processHandler.executeSynchronously();
        String string5 = processHandler.getOutputText();
        GlobalLogWriter.get().println("'" + string5 + "'");
        if (FileHelper.exists(string3)) {
            return string3;
        }
        return "";
    }

    int identify(String string) {
        int n = 0;
        String string2 = "%k";
        String string3 = "identify";
        if (OSHelper.isWindows()) {
            string3 = "identify.exe";
        }
        String[] stringArray = new String[]{string3, "-format", string2, string};
        ProcessHandler processHandler = new ProcessHandler(stringArray);
        boolean bl = processHandler.executeSynchronously();
        String string4 = processHandler.getOutputText();
        GlobalLogWriter.get().println("'" + string4 + "'");
        try {
            int n2 = string4.indexOf("\n");
            if (n2 > 0) {
                string4 = string4.substring(0, n2);
            }
            n = Integer.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            GlobalLogWriter.get().println("Number format exception");
            n = 0;
        }
        return n;
    }

    public StatusHelper checkDiffDiff(String string, String string2, String string3, String string4, String string5) {
        String string6 = string2 + this.fs + string3;
        String string7 = string4 + this.fs + string5;
        int n = 1;
        String string8 = PRNCompare.getJPEGName(string, string3 + ".diff", StringHelper.createValueString(n, 4));
        StatusHelper statusHelper = new StatusHelper(string7, string6, string8);
        PRNCompare.compareJPEGs(string7, string6, string8);
        if (FileHelper.exists(string8)) {
            int n2 = this.identify(string8);
            if (n2 == 1) {
                statusHelper.nDiffStatus = 2;
            } else {
                statusHelper.nDiffStatus = 3;
                try {
                    statusHelper.nPercent = this.estimateGfx(string7, string6, string8);
                }
                catch (IOException iOException) {
                    GlobalLogWriter.get().println(iOException.getMessage());
                    statusHelper.nPercent = -1;
                }
            }
        } else {
            GlobalLogWriter.get().println("composite can't create the diffdiff file.");
        }
        return statusHelper;
    }

    public int estimateGfx(String string, String string2, String string3) throws IOException {
        int n = PixelCounter.countNotWhitePixelsFromImage(string);
        int n2 = PixelCounter.countNotWhitePixelsFromImage(string2);
        int n3 = PixelCounter.countNotBlackPixelsFromImage(string3);
        int n4 = Math.min(n2, n);
        if (n4 == 0 && (n4 = Math.max(n2, n)) == 0) {
            n4 = 1;
        }
        int n5 = Math.abs(n3 * 100 / n4);
        GlobalLogWriter.get().println("Graphics check, pixel based:" + String.valueOf(n5) + "% pixel differ ");
        return n5;
    }
}

