/*
 * Decompiled with CFR 0.152.
 */
package connectivity.tools;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XCloseable;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XDataSource;
import com.sun.star.sdbc.XStatement;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import connectivity.tools.HsqlColumnDescriptor;
import connectivity.tools.HsqlTableDescriptor;
import java.io.File;

public class HsqlDatabase {
    XMultiServiceFactory m_orb;
    String m_databaseDocumentFile;
    XOfficeDatabaseDocument m_databaseDocument;
    XConnection m_connection;
    static /* synthetic */ Class class$com$sun$star$sdb$XOfficeDatabaseDocument;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$sdbc$XCloseable;

    public HsqlDatabase(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        this.m_orb = xMultiServiceFactory;
        this.createDBDocument();
    }

    private void createDBDocument() throws Exception {
        this.m_databaseDocumentFile = new String();
        String string = File.createTempFile("testdb", ".odb").getCanonicalPath();
        string = string.replaceAll(" ", "%20");
        string = "file:///" + string;
        this.m_databaseDocumentFile = string.replace('\\', '/');
        this.m_databaseDocument = (XOfficeDatabaseDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XOfficeDatabaseDocument == null ? (class$com$sun$star$sdb$XOfficeDatabaseDocument = HsqlDatabase.class$("com.sun.star.sdb.XOfficeDatabaseDocument")) : class$com$sun$star$sdb$XOfficeDatabaseDocument), (Object)this.m_orb.createInstance("com.sun.star.sdb.OfficeDatabaseDocument"));
        XDataSource xDataSource = this.m_databaseDocument.getDataSource();
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = HsqlDatabase.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xDataSource);
        xPropertySet.setPropertyValue("URL", (Object)"sdbc:embedded:hsqldb");
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = HsqlDatabase.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.m_databaseDocument);
        xStorable.storeAsURL(this.m_databaseDocumentFile, new PropertyValue[0]);
    }

    public XConnection defaultConnection() throws SQLException {
        if (this.m_connection != null) {
            return this.m_connection;
        }
        this.m_connection = this.m_databaseDocument.getDataSource().getConnection(new String(), new String());
        return this.m_connection;
    }

    public void executeSQL(String string) throws SQLException {
        XStatement xStatement = this.defaultConnection().createStatement();
        xStatement.execute(string);
    }

    public void close() {
        XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdbc$XCloseable == null ? (class$com$sun$star$sdbc$XCloseable = HsqlDatabase.class$("com.sun.star.sdbc.XCloseable")) : class$com$sun$star$sdbc$XCloseable), (Object)this.m_connection);
        if (xCloseable != null) {
            try {
                xCloseable.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.m_connection = null;
        com.sun.star.util.XCloseable xCloseable2 = (com.sun.star.util.XCloseable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdbc$XCloseable == null ? (class$com$sun$star$sdbc$XCloseable = HsqlDatabase.class$("com.sun.star.sdbc.XCloseable")) : class$com$sun$star$sdbc$XCloseable), (Object)this.m_databaseDocument);
        if (xCloseable2 != null) {
            try {
                xCloseable2.close(true);
            }
            catch (CloseVetoException closeVetoException) {
                // empty catch block
            }
        }
        this.m_databaseDocument = null;
    }

    public void closeAndDelete() {
        this.close();
        if (this.m_databaseDocumentFile != null) {
            try {
                File file = new File(this.m_databaseDocumentFile);
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_databaseDocumentFile = null;
        }
    }

    public void createTable(HsqlTableDescriptor hsqlTableDescriptor) throws SQLException {
        String string = "CREATE TABLE \"";
        string = string + hsqlTableDescriptor.getName();
        string = string + "\" ( ";
        String string2 = "";
        HsqlColumnDescriptor[] hsqlColumnDescriptorArray = hsqlTableDescriptor.getColumns();
        for (int i = 0; i < hsqlColumnDescriptorArray.length; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + "\"" + hsqlColumnDescriptorArray[i].Name;
            string = string + "\"" + hsqlColumnDescriptorArray[i].TypeName;
            if (hsqlColumnDescriptorArray[i].NotNull) {
                string = string + " NOT NULL";
            }
            if (!hsqlColumnDescriptorArray[i].PrimaryKey) continue;
            if (string2.length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + "\"" + hsqlColumnDescriptorArray[i].Name + "\"";
        }
        if (string2.length() > 0) {
            string = string + ", PRIMARY KEY (";
            string = string + string2;
            string = string + ")";
        }
        string = string + ")";
        this.executeSQL(string);
    }

    public String getDocumentURL() {
        return this.m_databaseDocumentFile;
    }

    protected void finalize() throws Throwable {
        this.closeAndDelete();
        super.finalize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

