/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class StoredCollection
extends StoredContainer
implements Collection {
    StoredCollection(DataView dataView) {
        super(dataView);
    }

    final boolean add(Object object, Object object2) {
        boolean bl = this.beginAutoCommit();
        try {
            int n = this.view.put(object, object2, Db.DB_NODUPDATA, null);
            this.commitAutoCommit(bl);
            return n == 0;
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    public Iterator iterator() {
        return this.iterator(this.isWriteAllowed());
    }

    public StoredIterator iterator(boolean bl) {
        try {
            return new StoredIterator(this, bl && this.isWriteAllowed(), null);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        finally {
            StoredIterator.close(iterator);
        }
        return arrayList.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        int n = 0;
        Iterator iterator = this.iterator();
        try {
            while (n < objectArray.length && iterator.hasNext()) {
                objectArray[n++] = iterator.next();
            }
            if (n < objectArray.length) {
                objectArray[n] = null;
            } else if (iterator.hasNext()) {
                ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                objectArray = arrayList.toArray(objectArray);
            }
        }
        finally {
            StoredIterator.close(iterator);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            StoredIterator.close(iterator);
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            iterator = collection.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                if (!this.add(iterator.next())) continue;
                bl2 = true;
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    public boolean removeAll(Collection collection) {
        return this.removeAll(collection, true);
    }

    public boolean retainAll(Collection collection) {
        return this.removeAll(collection, false);
    }

    private boolean removeAll(Collection collection, boolean bl) {
        Iterator iterator = null;
        boolean bl2 = this.beginAutoCommit();
        try {
            boolean bl3 = false;
            iterator = this.iterator();
            while (iterator.hasNext()) {
                if (bl != collection.contains(iterator.next())) continue;
                iterator.remove();
                bl3 = true;
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl2);
            return bl3;
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object instanceof Collection) {
            Collection collection = StoredCollection.copyCollection(object);
            Iterator iterator = this.iterator();
            try {
                while (iterator.hasNext()) {
                    if (collection.remove(iterator.next())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = collection.isEmpty();
                return bl;
            }
            finally {
                StoredIterator.close(iterator);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List toList() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            StoredIterator.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append(']');
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            StoredIterator.close(iterator);
        }
    }

    public StoredIterator join(StoredContainer[] storedContainerArray, Object[] objectArray) {
        return this.join(storedContainerArray, objectArray, false);
    }

    public StoredIterator join(StoredContainer[] storedContainerArray, Object[] objectArray, boolean bl) {
        try {
            DataView[] dataViewArray = new DataView[storedContainerArray.length];
            for (int i = 0; i < storedContainerArray.length; ++i) {
                dataViewArray[i] = storedContainerArray[i].view;
            }
            DataCursor dataCursor = this.view.join(dataViewArray, objectArray, bl);
            return new StoredIterator(this, false, dataCursor);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    final Object getFirstOrLast(boolean bl) {
        Object object;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            int n = dataCursor.get(null, null, bl ? Db.DB_FIRST : Db.DB_LAST, false);
            object = n == 0 ? this.makeIteratorData(null, dataCursor) : null;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return object;
    }

    abstract Object makeIteratorData(StoredIterator var1, DataCursor var2) throws DbException, IOException;

    abstract boolean hasValues();

    boolean iterateDuplicates() {
        return true;
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("duplicates required");
        }
    }

    int getIndexOffset() {
        return 0;
    }

    private static Collection copyCollection(Object object) {
        if (object instanceof StoredCollection) {
            return ((StoredCollection)object).toList();
        }
        return new ArrayList((Collection)object);
    }
}

