/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.serial;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import java.io.IOException;

public abstract class SerialSerialKeyExtractor
implements KeyExtractor {
    protected SerialFormat primaryKeyFormat;
    protected SerialFormat valueFormat;
    protected SerialFormat indexKeyFormat;

    public SerialSerialKeyExtractor(SerialFormat serialFormat, SerialFormat serialFormat2, SerialFormat serialFormat3) {
        this.primaryKeyFormat = serialFormat;
        this.valueFormat = serialFormat2;
        this.indexKeyFormat = serialFormat3;
    }

    public DataFormat getPrimaryKeyFormat() {
        return this.primaryKeyFormat;
    }

    public DataFormat getValueFormat() {
        return this.valueFormat;
    }

    public DataFormat getIndexKeyFormat() {
        return this.indexKeyFormat;
    }

    public void extractIndexKey(DataBuffer dataBuffer, DataBuffer dataBuffer2, DataBuffer dataBuffer3) throws IOException {
        Object object;
        Object object2 = this.primaryKeyFormat != null ? this.primaryKeyFormat.dataToObject(dataBuffer) : null;
        Object object3 = this.extractIndexKey(object2, object = this.valueFormat != null ? this.valueFormat.dataToObject(dataBuffer2) : null);
        if (object3 != null) {
            this.indexKeyFormat.objectToData(object3, dataBuffer3);
        } else {
            dataBuffer3.setData(null, 0, 0);
        }
    }

    public void clearIndexKey(DataBuffer dataBuffer) throws IOException {
        Object object = this.valueFormat.dataToObject(dataBuffer);
        if ((object = this.clearIndexKey(object)) != null) {
            this.valueFormat.objectToData(object, dataBuffer);
        }
    }

    public abstract Object extractIndexKey(Object var1, Object var2) throws IOException;

    public abstract Object clearIndexKey(Object var1) throws IOException;
}

