/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.frame.XController;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XControlAccess;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;
import util.utils;

public class Toolkit
extends TestCase {
    private static XTextDocument xTextDoc;
    static /* synthetic */ Class class$com$sun$star$view$XControlAccess;
    static /* synthetic */ Class class$com$sun$star$frame$XController;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(xTextDoc);
    }

    public TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XInterface xInterface = null;
        XWindowPeer xWindowPeer = null;
        XWindow xWindow = null;
        XControlShape xControlShape = FormTools.createControlShape(xTextDoc, 3000, 4500, 15000, 10000, "CommandButton");
        WriterTools.getDrawPage(xTextDoc).add(xControlShape);
        XControlModel xControlModel = xControlShape.getControl();
        XControlAccess xControlAccess = (XControlAccess)UnoRuntime.queryInterface(class$com$sun$star$view$XControlAccess == null ? (class$com$sun$star$view$XControlAccess = Toolkit.class$("com.sun.star.view.XControlAccess")) : class$com$sun$star$view$XControlAccess, (Object)xTextDoc.getCurrentController());
        XController xController = (XController)UnoRuntime.queryInterface(class$com$sun$star$frame$XController == null ? (class$com$sun$star$frame$XController = Toolkit.class$("com.sun.star.frame.XController")) : class$com$sun$star$frame$XController, (Object)xTextDoc.getCurrentController());
        try {
            xWindow = xController.getFrame().getContainerWindow();
            xWindowPeer = xControlAccess.getControl(xControlModel).getPeer();
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        printWriter.println("    creating a new environment for toolkit object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        printWriter.println("Implementation Name: " + utils.getImplName(xInterface));
        testEnvironment.addObjRelation("WINPEER", xWindowPeer);
        testEnvironment.addObjRelation("XDataTransferProviderAccess.XWindow", xWindow);
        return testEnvironment;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

