/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessiblePopupMenu
extends TestCase {
    private static XDesktop the_Desk;
    private static XTextDocument xTextDoc;
    private static Point point;
    static /* synthetic */ Class class$com$sun$star$frame$XDesktop;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;
    static /* synthetic */ Class class$com$sun$star$awt$XExtendedToolkit;
    static /* synthetic */ Class class$com$sun$star$awt$XWindow;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleSelection;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        the_Desk = (XDesktop)UnoRuntime.queryInterface(class$com$sun$star$frame$XDesktop == null ? (class$com$sun$star$frame$XDesktop = AccessiblePopupMenu.class$("com.sun.star.frame.XDesktop")) : class$com$sun$star$frame$XDesktop, DesktopTools.createDesktop((XMultiServiceFactory)testParameters.getMSF()));
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("release the popup menu");
        try {
            Robot robot = new Robot();
            int n = AccessiblePopupMenu.point.X;
            int n2 = AccessiblePopupMenu.point.Y;
            robot.mouseMove(n, n2);
            robot.mousePress(16);
            robot.mouseRelease(16);
        }
        catch (AWTException aWTException) {
            printWriter.println("couldn't press mouse button");
        }
        printWriter.println("disposing xTextDoc");
        if (xTextDoc != null) {
            this.closeDoc();
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        printWriter.println("creating a test environment");
        if (xTextDoc != null) {
            this.closeDoc();
        }
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        XInterface xInterface = null;
        try {
            printWriter.println("creating a text document");
            xTextDoc = sOfficeFactory.createTextDoc(null);
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        this.shortWait(testParameters);
        XModel xModel = (XModel)UnoRuntime.queryInterface(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = AccessiblePopupMenu.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel, (Object)xTextDoc);
        XAccessibleContext xAccessibleContext = null;
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)testParameters.getMSF(), xModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)40);
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = AccessiblePopupMenu.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent, (Object)xAccessibleContext);
        point = xAccessibleComponent.getLocationOnScreen();
        Rectangle rectangle = xAccessibleComponent.getBounds();
        try {
            object = new Robot();
            int n = AccessiblePopupMenu.point.X + rectangle.Width / 2;
            int n2 = AccessiblePopupMenu.point.Y + rectangle.Height / 2;
            ((Robot)object).mouseMove(n, n2);
            ((Robot)object).mousePress(4);
            ((Robot)object).mouseRelease(4);
        }
        catch (AWTException aWTException) {
            printWriter.println("couldn't press mouse button");
        }
        this.shortWait(testParameters);
        object = (XExtendedToolkit)UnoRuntime.queryInterface(class$com$sun$star$awt$XExtendedToolkit == null ? (class$com$sun$star$awt$XExtendedToolkit = AccessiblePopupMenu.class$("com.sun.star.awt.XExtendedToolkit")) : class$com$sun$star$awt$XExtendedToolkit, (Object)xInterface);
        try {
            xWindow = (XWindow)UnoRuntime.queryInterface(class$com$sun$star$awt$XWindow == null ? (class$com$sun$star$awt$XWindow = AccessiblePopupMenu.class$("com.sun.star.awt.XWindow")) : class$com$sun$star$awt$XWindow, (Object)object.getTopWindow(0));
            xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
            AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            printWriter.println("Couldn't get Window");
        }
        xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)43);
        printWriter.println("ImplementationName: " + utils.getImplName(xAccessibleContext));
        TestEnvironment testEnvironment = new TestEnvironment(xAccessibleContext);
        testEnvironment.addObjRelation("XAccessibleSelection.multiSelection", new Boolean(false));
        final XAccessibleSelection xAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleSelection == null ? (class$com$sun$star$accessibility$XAccessibleSelection = AccessiblePopupMenu.class$("com.sun.star.accessibility.XAccessibleSelection")) : class$com$sun$star$accessibility$XAccessibleSelection, (Object)xAccessibleContext);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    xAccessibleSelection.selectAccessibleChild(2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println("Couldn't fire event");
                }
            }
        });
        return testEnvironment;
    }

    protected void closeDoc() {
        DesktopTools.closeDoc(xTextDoc);
    }

    private void shortWait(TestParameters testParameters) {
        utils.shortWait(testParameters.getInt("ShortWait"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

