/*
 * Decompiled with CFR 0.152.
 */
package ifc.util;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.util.ChangesEvent;
import com.sun.star.util.XChangesBatch;
import com.sun.star.util.XChangesListener;
import com.sun.star.util.XChangesNotifier;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XChangesNotifier
extends MultiMethodTest {
    public XChangesNotifier oObj = null;
    private XChangesBatch xBatch = null;
    private Object changeElement = null;
    private Object originalElement = null;
    private String elementName = null;
    private XPropertySet xProp = null;
    private XNameReplace xNameReplace = null;
    private MyChangesListener xListener = null;

    protected void before() {
        this.xBatch = (XChangesBatch)this.tEnv.getObjRelation("XChangesNotifier.ChangesBatch");
        this.changeElement = this.tEnv.getObjRelation("XChangesNotifier.ChangeElement");
        this.originalElement = this.tEnv.getObjRelation("XChangesNotifier.OriginalElement");
        this.elementName = (String)this.tEnv.getObjRelation("XChangesNotifier.PropertyName");
        this.xProp = (XPropertySet)this.tEnv.getObjRelation("XChangesNotifier.PropertySet");
        try {
            if (this.originalElement == null && this.xProp != null) {
                this.originalElement = this.xProp.getPropertyValue(this.elementName);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new StatusException("Could not get property '" + this.elementName + "'.", exception);
        }
        this.xNameReplace = (XNameReplace)this.tEnv.getObjRelation("XChangesNotifier.NameReplace");
        try {
            if (this.originalElement == null && this.xNameReplace != null) {
                this.originalElement = this.xNameReplace.getByName(this.elementName);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new StatusException("Could not get element by name '" + this.elementName + "'.", exception);
        }
        if (this.changeElement == null || this.originalElement == null || this.elementName == null || this.xProp == null && this.xNameReplace == null || this.xBatch == null) {
            this.log.println(this.changeElement == null ? "Missing property 'XChangesNotifier.ChangeElement'\n" : ("" + this.originalElement == null ? "Missing property 'XChangesNotifier.OriginalElement'\n" : ("" + this.elementName == null ? "Missing property 'XChangesNotifier.PropertyName'\n" : ("" + this.xProp == null ? "Missing property 'XChangesNotifier.PropertySet'" : ("" + this.xNameReplace == null ? "Missing property 'XChangesNotifier.NameReplace'" : ("" + this.xBatch == null ? "Missing property 'XChangesNotifier.ChangesBatch'" : ""))))));
            throw new StatusException("Some needed object relations are missing.", new Exception());
        }
        this.xListener = new MyChangesListener();
    }

    public void _addChangesListener() {
        this.oObj.addChangesListener(this.xListener);
        this.tRes.tested("addChangesListener()", true);
    }

    public void _removeChangesListener() {
        this.requiredMethod("addChangesListener()");
        boolean bl = true;
        bl &= this.commitChanges();
        if (!(bl &= this.xListener.didChangesOccur())) {
            this.log.println("Listener has not been called.");
        }
        this.oObj.removeChangesListener(this.xListener);
        this.xListener.reset();
        bl &= this.redoChanges();
        boolean bl2 = this.xListener.didChangesOccur();
        if (bl2) {
            this.log.println("Removed listener has been called.");
        }
        this.tRes.tested("removeChangesListener()", bl && !bl2);
    }

    private boolean commitChanges() {
        if (!this.executeChange(this.changeElement)) {
            return false;
        }
        if (!this.xBatch.hasPendingChanges()) {
            return false;
        }
        try {
            this.xBatch.commitChanges();
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(this.log);
            return false;
        }
        return true;
    }

    private boolean redoChanges() {
        if (!this.executeChange(this.originalElement)) {
            return false;
        }
        if (!this.xBatch.hasPendingChanges()) {
            return false;
        }
        try {
            this.xBatch.commitChanges();
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(this.log);
            return false;
        }
        return true;
    }

    private boolean executeChange(Object object) throws StatusException {
        if (this.xProp != null) {
            try {
                this.xProp.setPropertyValue(this.elementName, object);
            }
            catch (com.sun.star.uno.Exception exception) {
                exception.printStackTrace(this.log);
                return false;
            }
        }
        if (this.xNameReplace != null) {
            try {
                this.xNameReplace.replaceByName(this.elementName, object);
            }
            catch (com.sun.star.uno.Exception exception) {
                exception.printStackTrace(this.log);
                return false;
            }
        }
        return true;
    }

    private static class MyChangesListener
    implements XChangesListener {
        boolean bChangesOccured = false;

        private MyChangesListener() {
        }

        public void changesOccurred(ChangesEvent changesEvent) {
            this.bChangesOccured = true;
        }

        public void disposing(EventObject eventObject) {
            this.bChangesOccured = true;
        }

        public void reset() {
            this.bChangesOccured = false;
        }

        public boolean didChangesOccur() {
            return this.bChangesOccured;
        }
    }
}

