/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.XAccessibleValue;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.utils;

public class _XAccessibleValue
extends MultiMethodTest {
    public XAccessibleValue oObj = null;
    private double minVal = 0.0;
    private double maxVal = 0.0;
    private double curVal = 0.0;
    private Object val = null;
    XAccessibleValue anotherFromGroup = null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    protected void before() {
        this.anotherFromGroup = (XAccessibleValue)this.tEnv.getObjRelation("XAccessibleValue.anotherFromGroup");
    }

    public void _getCurrentValue() {
        double d;
        this.executeMethod("getMaximumValue()");
        this.executeMethod("getMinimumValue()");
        boolean bl = true;
        this.val = this.oObj.getCurrentValue();
        if (utils.isVoid(this.val)) {
            this.val = new Integer(0);
            d = 0.0;
        } else {
            d = this.getDoubleValue(this.val);
        }
        if (d < this.minVal || this.maxVal < d) {
            this.log.println("" + (d - this.minVal) + "," + (this.maxVal - d));
            this.log.println("Current value " + d + " is not in range [" + this.minVal + "," + this.maxVal + "]");
            bl = false;
        }
        this.tRes.tested("getCurrentValue()", bl);
    }

    public void _setCurrentValue() {
        this.executeMethod("getCurrentValue()");
        boolean bl = true;
        boolean bl2 = true;
        String string = "com.sun.star.comp.toolkit.AccessibleScrollBar";
        String string2 = utils.getImplName(this.oObj);
        if (this.tEnv.getObjRelation("ValueNotPersitent") != null) {
            this.log.println("Excluded since it works like AccessibleAction");
            this.tRes.tested("setCurrentValue()", Status.skipped(true));
            return;
        }
        if (this.anotherFromGroup == null) {
            double d = this.curVal + 1.0;
            if (d > this.maxVal) {
                d -= 2.0;
            }
            if (d < this.minVal) {
                d += 1.0;
            }
            this.log.println("New value is " + d);
            Object object = this.getObjectValue(d, this.val.getClass());
            if (!(bl &= this.oObj.setCurrentValue(object))) {
                this.log.println("The value can't be set");
                throw new StatusException(Status.skipped(true));
            }
            double d2 = this.getDoubleValue(this.oObj.getCurrentValue());
            this.log.println("Res value is " + d2);
            bl &= Math.abs(d - d2) < 1.0E-5;
            this.log.println("Checking min/max values");
            bl &= this.oObj.setCurrentValue(this.getObjectValue(this.minVal, this.val.getClass()));
            this.log.println("Setting to " + this.getObjectValue(this.minVal, this.val.getClass()));
            d2 = this.getDoubleValue(this.oObj.getCurrentValue());
            this.log.println("Result min value is " + d2);
            bl &= Math.abs(this.minVal - d2) < 1.0E-5;
            this.log.println("\t works: " + (Math.abs(this.minVal - d2) < 1.0E-5));
            bl &= this.oObj.setCurrentValue(this.getObjectValue(this.maxVal, this.val.getClass()));
            this.log.println("Setting to " + this.getObjectValue(this.maxVal, this.val.getClass()));
            d2 = this.getDoubleValue(this.oObj.getCurrentValue());
            this.log.println("Result max value is " + d2);
            boolean bl3 = bl2 = Math.abs(this.maxVal - d2) < 1.0E-5;
            if (string2.equals(string)) {
                this.log.println("If one sets the maximum value of a scroll bar with XScrollBar::setMaximum(),then XScrollBar::getValue() returns the maximum value minus the visible size ofthe thumb");
                bl2 = d2 > 10.0;
            }
            bl &= bl2;
            this.log.println("\t works: " + bl2);
            this.log.println("Checking truncating of min/max values");
            this.oObj.setCurrentValue(this.getObjectValue(this.minVal - 1.0, this.val.getClass()));
            this.log.println("Setting to " + this.getObjectValue(this.minVal - 1.0, this.val.getClass()));
            d2 = this.getDoubleValue(this.oObj.getCurrentValue());
            this.log.println("Result min value is " + d2);
            bl &= Math.abs(this.minVal - d2) < 1.0E-5;
            this.log.println("\t works: " + (Math.abs(this.minVal - d2) < 1.0E-5));
            this.oObj.setCurrentValue(this.getObjectValue(this.maxVal + 1.0, this.val.getClass()));
            this.log.println("Setting to " + this.getObjectValue(this.maxVal + 1.0, this.val.getClass()));
            d2 = this.getDoubleValue(this.oObj.getCurrentValue());
            this.log.println("Result max value is " + d2);
            boolean bl4 = bl2 = Math.abs(this.maxVal - d2) < 1.0E-5;
            if (string2.equals(string)) {
                this.log.println("If one sets the maximum value of a scroll bar with XScrollBar::setMaximum(),then XScrollBar::getValue() returns the maximum value minus the visible size ofthe thumb");
                bl2 = d2 > 10.0;
            }
            bl &= bl2;
            this.log.println("\t works: " + bl2);
        } else {
            int n = this.getIntegerValue(this.val);
            Object object = this.anotherFromGroup.getCurrentValue();
            int n2 = this.getIntegerValue(object);
            this.log.println("Current value of base component: " + n);
            this.log.println("Current value of another component from group: " + n2);
            this.log.println("Set value of base component to " + n2);
            if (this.tEnv.getTestCase().getObjectName().equals("AccessibleRadioButton")) {
                this.anotherFromGroup.setCurrentValue(new Integer(n));
            } else {
                this.oObj.setCurrentValue(object);
            }
            this.log.println("Checking of values...");
            int n3 = this.getIntegerValue(this.oObj.getCurrentValue());
            int n4 = this.getIntegerValue(this.anotherFromGroup.getCurrentValue());
            this.log.println("New value of base component: " + n3);
            this.log.println("Expected value of base component: " + n2);
            this.log.println("New value of another component from group: " + n4);
            this.log.println("Expected value of another component from group: " + n);
            bl = n3 == n2 && n4 == n;
        }
        this.tRes.tested("setCurrentValue()", bl);
    }

    public void _getMaximumValue() {
        this.requiredMethod("getMinimumValue()");
        boolean bl = true;
        Object object = this.oObj.getMaximumValue();
        if (utils.isVoid(object)) {
            this.maxVal = Double.MAX_VALUE;
            bl = false;
        } else {
            this.maxVal = this.getDoubleValue(object);
        }
        this.log.println("Max is " + object.getClass() + " = " + this.maxVal);
        this.tRes.tested("getMaximumValue()", bl &= this.maxVal >= this.minVal);
    }

    public void _getMinimumValue() {
        boolean bl = true;
        Object object = this.oObj.getMinimumValue();
        if (utils.isVoid(object)) {
            this.minVal = -1.7976931348623157E308;
            bl = false;
        } else {
            this.minVal = this.getDoubleValue(object);
        }
        this.log.println("Min is " + object.getClass() + " = " + this.minVal);
        this.tRes.tested("getMinimumValue()", bl);
    }

    private int getIntegerValue(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new StatusException(Status.failed("Unexpected value type: " + object.getClass()));
    }

    private double getDoubleValue(Object object) {
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Short) {
            return ((Short)object).doubleValue();
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (utils.isVoid(object)) {
            return Double.NaN;
        }
        throw new StatusException(Status.failed("Undetected value type: " + object.getClass()));
    }

    private Object getObjectValue(double d, Class clazz) {
        if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = _XAccessibleValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)d);
        }
        if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = _XAccessibleValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)d);
        }
        if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = _XAccessibleValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float((float)d);
        }
        if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = _XAccessibleValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(d);
        }
        throw new StatusException(Status.failed("Unexpected class: " + clazz));
    }

    protected void after() {
        this.disposeEnvironment();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

