/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: msgdescr.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:06:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXMSGDESCR_HXX
#define _SFXMSGDESCR_HXX

#ifndef _BITMAP_HXX //autogen
#include <vcl/bitmap.hxx>
#endif
#ifndef _RC_HXX //autogen
#include <tools/rc.hxx>
#endif

class SfxMessageDescription: public Resource
{
friend class SfxResourceManager;

	String	aFunctionName;
	String	aHelpText;
	String	aBasicName;
	Bitmap	aSmallBmp;
	Bitmap	aLargeBmp;

		// Kopieren verhindern
	const	SfxMessageDescription& operator=(const SfxMessageDescription&);
			SfxMessageDescription(const SfxMessageDescription&);

protected:
					SfxMessageDescription( USHORT nId );
					SfxMessageDescription( USHORT nId,
						const Bitmap &rLargeBmp, const Bitmap &rSmallBmp );

public:
	const String  &GetFunctionName() const { return aFunctionName; }
	const String  &GetHelpText() const { return aHelpText; }
	const String  &GetBasicName() const { return aBasicName; }
	const Bitmap  &GetLargeBitmap() const { return aLargeBmp; }
	const Bitmap  &GetSmallBitmap() const { return aSmallBmp; }
};

#endif

