/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: propertysetmixin.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:36:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_COMPHELPER_PROPERTYSETMIXIN_HXX
#define INCLUDED_COMPHELPER_PROPERTYSETMIXIN_HXX \
    INCLUDED_COMPHELPER_PROPERTYSETMIXIN_HXX

#ifndef _SAL_CONFIG_H_
#include "sal/config.h"
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVETOEXCEPTION_HPP_
#include "com/sun/star/beans/PropertyVetoException.hpp"
#endif
#ifndef _COM_SUN_STAR_BEANS_UNKNOWNPROPERTYEXCEPTION_HPP_
#include "com/sun/star/beans/UnknownPropertyException.hpp"
#endif
#ifndef _COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HPP_
#include "com/sun/star/beans/XFastPropertySet.hpp"
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYACCESS_HPP_
#include "com/sun/star/beans/XPropertyAccess.hpp"
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include "com/sun/star/beans/XPropertySet.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include "com/sun/star/lang/IllegalArgumentException.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETEXCEPTION_HPP_
#include "com/sun/star/lang/WrappedTargetException.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include "com/sun/star/uno/RuntimeException.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include "com/sun/star/uno/Sequence.hxx"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif

/// @HTML

namespace com { namespace sun { namespace star {
    namespace beans {
        class XPropertyChangeListener;
        class XPropertySetInfo;
        class XVetoableChangeListener;
        struct PropertyValue;
    }
    namespace uno {
        class Any;
        class Type;
        class XComponentContext;
    }
} } }
namespace rtl { class OUString; }

namespace comphelper {

template< typename T > class PropertySetMixin;

/**
   A helper base class for <code>comphelper::PropertySetMixin</code>.

   <p>See the documentation of <code>comphelper::PropertySetMixin</code> for
   further details.</p>

   <p>That <code>comphelper::PropertySetMixin</code> is derived from this base
   class should be considered an implementation detail.  The functionality of
   <code>comphelper::PropertySetMixin</code> that is inherited from this base
   class and is visible to subclasses of
   <code>comphelper::PropertySetMixin</code> should be treated by such
   subclasses as being provided by <code>comphelper::PropertySetMixin</code>
   directly (e.g., in such subclasses, use
   &ldquo;<code>PropertySetMixin::Implements</code>&rdquo; instead of
   &ldquo;<code>PropertySetMixinImpl::Implements</code>&rdquo;).</p>

   @since #i29740#
*/
class PropertySetMixinImpl:
    public com::sun::star::beans::XPropertySet,
    public com::sun::star::beans::XFastPropertySet,
    public com::sun::star::beans::XPropertyAccess
{
protected:
    /**
       Flags used by subclasses of <code>comphelper::PropertySetMixin</code> to
       specify what UNO interface types shall be supported.
    */
    enum Implements {
        /**
           Flag specifying that the UNO interface type
           <code>com::sun::star::beans::XPropertySet</code> shall be supported.
        */
        IMPLEMENTS_PROPERTY_SET = 1,

        /**
           Flag specifying that the UNO interface type
           <code>com::sun::star::beans::XFastPropertySet</code> shall be
           supported.
        */
        IMPLEMENTS_FAST_PROPERTY_SET = 2,

        /**
           Flag specifying that the UNO interface type
           <code>com::sun::star::beans::XPropertyAccess</code> shall be
           supported.
        */
        IMPLEMENTS_PROPERTY_ACCESS = 4
    };

    /**
       A class used by subclasses of <code>comphelper::PropertySetMixin</code>
       when implementing UNO interface type attribute setter functions.

       <p>This class is not thread safe; that is, the constructor,
       <code>notify</code>, and the destructor must be called from the same
       thread.</p>

       <p>See <code>comphelper::PropertySetMixinImpl::prepareSet</code> for
       further details.</p>
    */
    class BoundListeners {
    public:
        /**
           The constructor.

           <p>May throw <code>std::bad_alloc</code>.</p>
        */
        BoundListeners();

        /**
           The destructor.

           <p>Does not throw.</p>
        */
        ~BoundListeners();

        /**
           Notifies any
           <code>com::sun::star::beans::XPropertyChangeListener</code>s.

           <p>May throw <code>com::sun::star::uno::RuntimeException</code> and
           <code>std::bad_alloc</code>.</p>

           <p>See <code>comphelper::PropertySetMixinImpl::prepareSet</code> for
           further details.</p>
         */
        void notify() const;

    private:
        BoundListeners(BoundListeners &); // not defined
        void operator =(BoundListeners); // not defined

        class Impl;
        Impl * m_impl;

        friend class PropertySetMixinImpl;
    };

    /**
       A function used by subclasses of
       <code>comphelper::PropertySetMixin</code> when implementing UNO interface
       type attribute setter functions.

       <p>First, this function checks whether this instance has already been
       disposed (see <code>comphelper::PropertySetMixinImpl::dispse</code>), and
       throws a <code>com::sun::star::lang::DisposedException</code> if
       applicable.  For a constrained attribute (whose setter can explicitly
       raise <code>com::sun::star::beans::PropertyVetoException</code>), this
       function notifies any
       <code>com::sun::star::beans::XVetoableChangeListener</code>s.  For a
       bound attribute, this function modifies the passed-in
       <code>boundListeners</code> so that it can afterwards be used to notify
       any <code>com::sun::star::beans::XPropertyChangeListener</code>s.  This
       function should be called before storing the new attribute value, and
       <code>boundListeners->notify()</code> should be called exactly once after
       storing the new attribute value (in case the attribute is bound;
       otherwise, calling <code>boundListeners->notify()</code> is ignored).
       Furthermore, <code>boundListeners->notify()</code> and this function have
       to be called from the same thread.</p>

       @param propertyName  the name of the property (which is the same as the
       name of the attribute that is going to be set)

       @param vetoableValue  the property value corresponding to the new
       attribute value; if the attribute that is going to be set is not
       constrained, an empty <code>Any</code> can be used instead

       @param boundListeners  a pointer to a fresh
       <code>comphelper::PropertySetMixinImpl::BoundListeners</code> instance
       (which has not been passed to this function before, and on which
       <code>notify</code> has not yet been called); may only be null if the
       attribute that is going to be set is not bound

       <p>May throw <code>com::sun::star::beans::PropertyVetoException</code>,
       <code>com::sun::star::uno::RuntimeException</code> (and
       <code>com::sun::star::lang::DisposedException</code> in particular), and
       <code>std::bad_alloc</code>.</p>
    */
    void prepareSet(
        rtl::OUString const & propertyName,
        com::sun::star::uno::Any const & vetoableValue,
        BoundListeners * boundListeners);

    /**
       Mark this instance as being disposed.

       <p>See <code>com::sun::star::lang::XComponent</code> for the general
       concept of disposing UNO objects.  On the first call to this function,
       all registered listeners
       (<code>com::sun::star::beans::XPropertyChangeListener</code>s and
       <code>com::sun::star::beans::XVetoableChangeListener</code>s) are
       notified of the disposing source.  Any subsequent calls to this function
       are ignored.</p>

       <p>May throw <code>com::sun::star::uno::RuntimeException</code> and
       <code>std::bad_alloc</code>.</p>
     */
    void dispose();

    /**
       A function used by subclasses of
       <code>comphelper::PropertySetMixin</code> when implementing
       <code>com::sun::star::uno::XInterface::queryInterface</code>.

       <p>This function checks for support of any of the UNO interface types
       specified in the call of the <code>comphelper::PropertySetMixin</code>
       constructor.  It does not check for any other UNO interface types (not
       even for <code>com::sun::star::uno::XInterface</code>), and should not
       be used directly as the implementation of
       <code>com::sun::star::uno::XInterface::queryInterface</code> of this UNO
       object.</p>
    */
    virtual com::sun::star::uno::Any SAL_CALL queryInterface(
        com::sun::star::uno::Type const & type)
        throw (com::sun::star::uno::RuntimeException);

    // @see com::sun::star::beans::XPropertySet::getPropertySetInfo
    virtual
    com::sun::star::uno::Reference< com::sun::star::beans::XPropertySetInfo >
    SAL_CALL getPropertySetInfo() throw (com::sun::star::uno::RuntimeException);

    // @see com::sun::star::beans::XPropertySet::setPropertyValue
    virtual void SAL_CALL setPropertyValue(
        rtl::OUString const & propertyName,
        com::sun::star::uno::Any const & value)
        throw (
            com::sun::star::beans::UnknownPropertyException,
            com::sun::star::beans::PropertyVetoException,
            com::sun::star::lang::IllegalArgumentException,
            com::sun::star::lang::WrappedTargetException,
            com::sun::star::uno::RuntimeException);

    // @see com::sun::star::beans::XPropertySet::getPropertyValue
    virtual com::sun::star::uno::Any SAL_CALL getPropertyValue(
        rtl::OUString const & propertyName)
        throw (
            com::sun::star::beans::UnknownPropertyException,
            com::sun::star::lang::WrappedTargetException,
            com::sun::star::uno::RuntimeException);

    /**
       Adds a <code>com::sun::star::beans::XPropertyChangeListener</code>.

       <p>If the given property name is neither empty nor the name of a bound
       property, the listener is registered nonetheless: it can be removed again
       with a call to <code>removePropertyChangeListener</code>, and it is
       notified when this object is disposed, but it will never be notified
       about a property change event.  Since this function does not check
       whether the given property name is valid, it never throws
       <code>com::sun::star::beans::UnknownPropertyException</code>.</p>

       <p>If a listener is added more than once, it will receive all relevant
       notifications multiple times.</p>

       @see com::sun::star::beans::XPropertySet::addPropertyChangeListener
    */
    virtual void SAL_CALL addPropertyChangeListener(
        rtl::OUString const & propertyName,
        com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertyChangeListener > const & listener)
        throw (
            com::sun::star::beans::UnknownPropertyException,
            com::sun::star::lang::WrappedTargetException,
            com::sun::star::uno::RuntimeException);

    // @see com::sun::star::beans::XPropertySet::removePropertyChangeListener
    virtual void SAL_CALL removePropertyChangeListener(
        rtl::OUString const & propertyName,
        com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertyChangeListener > const & listener)
        throw (
            com::sun::star::beans::UnknownPropertyException,
            com::sun::star::lang::WrappedTargetException,
            com::sun::star::uno::RuntimeException);

    /**
       Adds a <code>com::sun::star::beans::XVetoableChangeListener</code>.

       <p>If the given property name is neither empty nor the name of a
       constrained property, the listener is registered nonetheless: it can be
       removed again with a call to <code>removeVetoableChangeListener</code>,
       and it is notified when this object is disposed, but it will never be
       notified about a property change event.  Since this function does not
       check whether the given property name is valid, it never throws
       <code>com::sun::star::beans::UnknownPropertyException</code>.</p>

       <p>If a listener is added more than once, it will receive all relevant
       notifications multiple times.</p>

       @see com::sun::star::beans::XPropertySet::addVetoableChangeListener
    */
    virtual void SAL_CALL addVetoableChangeListener(
        rtl::OUString const & propertyName,
        com::sun::star::uno::Reference<
        com::sun::star::beans::XVetoableChangeListener > const & listener)
        throw (
            com::sun::star::beans::UnknownPropertyException,
            com::sun::star::lang::WrappedTargetException,
            com::sun::star::uno::RuntimeException);

    // @see com::sun::star::beans::XPropertySet::removeVetoableChangeListener
    virtual void SAL_CALL removeVetoableChangeListener(
        rtl::OUString const & propertyName,
        com::sun::star::uno::Reference<
        com::sun::star::beans::XVetoableChangeListener > const & listener)
        throw (
            com::sun::star::beans::UnknownPropertyException,
            com::sun::star::lang::WrappedTargetException,
            com::sun::star::uno::RuntimeException);

    // @see com::sun::star::beans::XFastPropertySet::setFastPropertyValue
    virtual void SAL_CALL setFastPropertyValue(
        sal_Int32 handle, com::sun::star::uno::Any const & value)
        throw (
            com::sun::star::beans::UnknownPropertyException,
            com::sun::star::beans::PropertyVetoException,
            com::sun::star::lang::IllegalArgumentException,
            com::sun::star::lang::WrappedTargetException,
            com::sun::star::uno::RuntimeException);

    // @see com::sun::star::beans::XFastPropertySet::getFastPropertyValue
    virtual com::sun::star::uno::Any SAL_CALL getFastPropertyValue(
        sal_Int32 handle)
        throw (
            com::sun::star::beans::UnknownPropertyException,
            com::sun::star::lang::WrappedTargetException,
            com::sun::star::uno::RuntimeException);

    // @see com::sun::star::beans::XPropertyAccess::getPropertyValues
    virtual
    com::sun::star::uno::Sequence< com::sun::star::beans::PropertyValue >
    SAL_CALL getPropertyValues() throw (com::sun::star::uno::RuntimeException);

    // @see com::sun::star::beans::XPropertyAccess::setPropertyValues
    virtual void SAL_CALL setPropertyValues(
        com::sun::star::uno::Sequence< com::sun::star::beans::PropertyValue >
        const & props)
        throw (
            com::sun::star::beans::UnknownPropertyException,
            com::sun::star::beans::PropertyVetoException,
            com::sun::star::lang::IllegalArgumentException,
            com::sun::star::lang::WrappedTargetException,
            com::sun::star::uno::RuntimeException);

private:
    PropertySetMixinImpl(PropertySetMixinImpl &); // not defined
    void operator =(PropertySetMixinImpl &); // not defined

    PropertySetMixinImpl(
        com::sun::star::uno::Reference< com::sun::star::uno::XComponentContext >
        const & context,
        Implements implements, com::sun::star::uno::Type const & type);

    ~PropertySetMixinImpl();

    class Impl;
    Impl * m_impl;

    friend class Impl;
    template< typename T > friend class PropertySetMixin;
};

/**
   A helper mixin to implement certain UNO interfaces related to property set
   handling on top of the attributes of a given UNO interface type.

   <p>The UNO interface type is specified by the type parameter <code>T</code>
   (which must correspond to a UNO interface type).</p>

   <p>No specializations of this class template should be added by client
   code.</p>

   <p>Once this class template and the accompanying
   <code>comphelper::PropertySetMixinImpl</code> are stable, it is intended to
   move them to the UDK (e.g., <code>cppuhelper</code>), with namespaces changed
   accordingly.</p>

   @since #i29740#
*/
template< typename T > class PropertySetMixin: public PropertySetMixinImpl {
protected:
    /**
       The constructor.

       <p>May throw <code>com::sun::star::uno::RuntimeException</code> and
       <code>std::bad_alloc</code>.</p>

       @param context  the component context used by this class template; must
       not be null, and must supply the service
       <code>com.sun.star.reflection.CoreReflection</code> and the singleton
       <code>com.sun.star.reflection.theTypeDescriptionManager</code>

       @param implements  a combination of zero or more flags specifying what
       UNO interface types shall be supported
    */
    PropertySetMixin(
        com::sun::star::uno::Reference< com::sun::star::uno::XComponentContext >
        const & context,
        Implements implements):
        PropertySetMixinImpl(context, implements, T::static_type()) {}

    /**
       The destructor.

       <p>Does not throw.</p>
    */
    ~PropertySetMixin() {}

private:
    PropertySetMixin(PropertySetMixin &); // not defined
    void operator =(PropertySetMixin); // not defined
};

}

#endif
