/*************************************************************************
 *
 *  $RCSfile: wall.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 10:23:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_WALL_HXX
#define _SV_WALL_HXX

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _SV_COLOR_HXX
#include <vcl/color.hxx>
#endif

class Rectangle;
class Gradient;
class BitmapEx;

// -------------------
// - Wallpaper-Types -
// -------------------

#define	WALLPAPER_NULL 					WallpaperStyle_NULL
#define	WALLPAPER_TILE					WallpaperStyle_TILE
#define	WALLPAPER_CENTER				WallpaperStyle_CENTER
#define	WALLPAPER_SCALE					WallpaperStyle_SCALE
#define	WALLPAPER_TOPLEFT				WallpaperStyle_TOPLEFT
#define	WALLPAPER_TOP					WallpaperStyle_TOP
#define	WALLPAPER_TOPRIGHT				WallpaperStyle_TOPRIGHT
#define	WALLPAPER_LEFT					WallpaperStyle_LEFT
#define	WALLPAPER_RIGHT					WallpaperStyle_RIGHT
#define	WALLPAPER_BOTTOMLEFT			WallpaperStyle_BOTTOMLEFT
#define	WALLPAPER_BOTTOM				WallpaperStyle_BOTTOM
#define	WALLPAPER_BOTTOMRIGHT			WallpaperStyle_BOTTOMRIGHT
#define	WALLPAPER_FORCE_EQUAL_SIZE		WallpaperStyle_FORCE_EQUAL_SIZE

#ifndef ENUM_WALLPAPERSTYLE_DECLARED
#define ENUM_WALLPAPERSTYLE_DECLARED

enum WallpaperStyle 
{
	WALLPAPER_NULL, 
	WALLPAPER_TILE,
	WALLPAPER_CENTER,
	WALLPAPER_SCALE,
	WALLPAPER_TOPLEFT,		
	WALLPAPER_TOP,		
	WALLPAPER_TOPRIGHT,
	WALLPAPER_LEFT,								
	WALLPAPER_RIGHT,
	WALLPAPER_BOTTOMLEFT,	
	WALLPAPER_BOTTOM,	
	WALLPAPER_BOTTOMRIGHT,
	WALLPAPER_FORCE_EQUAL_SIZE = 0x7fffffff
};

#endif

// -----------------
// - ImplWallpaper -
// -----------------

class SvStream;

class ImplWallpaper
{
	friend class Wallpaper;

private:
	Color			maColor;
	BitmapEx*		mpBitmap;
	Gradient*		mpGradient;
	Rectangle*		mpRect;
	WallpaperStyle	meStyle;
	USHORT			mnRefCount;
	BitmapEx*		mpCache;

	friend SvStream& operator>>( SvStream& rIStm, ImplWallpaper& rImplWallpaper );
	friend SvStream& operator<<( SvStream& rOStm, const ImplWallpaper& rImplWallpaper );

#ifdef _SV_WALL_CXX
public:
					ImplWallpaper();
					ImplWallpaper( const ImplWallpaper& rImplWallpaper );
					~ImplWallpaper();

	void			ImplSetCachedBitmap( BitmapEx& rBmp );
	const BitmapEx*	ImplGetCachedBitmap() { return mpCache; }
	void			ImplReleaseCachedBitmap();
#endif
};

// -------------
// - Wallpaper -
// -------------

class Wallpaper
{
private:
	ImplWallpaper*	mpImplWallpaper;

#ifdef _SV_WALL_CXX
	void			ImplMakeUnique( BOOL bReleaseCache = TRUE );
public:
	ImplWallpaper*	ImplGetImpWallpaper() const { return mpImplWallpaper; }
#endif

public:
					Wallpaper();
					Wallpaper( const Wallpaper& rWallpaper );
					Wallpaper( const Color& rColor );
					Wallpaper( const BitmapEx& rBmpEx );
					Wallpaper( const Gradient& rGradient );
					~Wallpaper();

	void			SetColor( const Color& rColor );
	const Color&	GetColor() const { return mpImplWallpaper->maColor; }

	void			SetStyle( WallpaperStyle eStyle );
	WallpaperStyle	GetStyle() const { return mpImplWallpaper->meStyle; }

	void			SetBitmap( const BitmapEx& rBitmap );
	void			SetBitmap();
	BitmapEx		GetBitmap() const;
	BOOL			IsBitmap() const { return (mpImplWallpaper->mpBitmap != 0); }

	void			SetGradient( const Gradient& rGradient );
	void			SetGradient();
	Gradient		GetGradient() const;
	BOOL			IsGradient() const { return (mpImplWallpaper->mpGradient != 0); }

	void			SetRect( const Rectangle& rRect );
	void			SetRect();
	Rectangle		GetRect() const;
	BOOL			IsRect() const { return (mpImplWallpaper->mpRect != 0); }

	BOOL			IsFixed() const;
	BOOL			IsScrollable() const;

	Wallpaper&		operator=( const Wallpaper& rWallpaper );
	BOOL			operator==( const Wallpaper& rWallpaper ) const;
	BOOL			operator!=( const Wallpaper& rWallpaper ) const
						{ return !(Wallpaper::operator==( rWallpaper )); }
	BOOL			IsSameInstance( const Wallpaper& rWallpaper ) const
						{ return (mpImplWallpaper == rWallpaper.mpImplWallpaper); }

	friend SvStream& operator>>( SvStream& rIStm, Wallpaper& rWallpaper );
	friend SvStream& operator<<( SvStream& rOStm, const Wallpaper& rWallpaper );
};

#endif	// _SV_WALL_HXX
