/*************************************************************************
 *
 *  $RCSfile: dialog.hxx,v $
 *
 *  $Revision: 1.7.252.1 $
 *
 *  last change: $Author: rt $ $Date: 2003/10/31 15:43:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_DIALOG_HXX
#define _SV_DIALOG_HXX

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _SV_SYSWIN_HXX
#include <vcl/syswin.hxx>
#endif

// parameter to pass to the dialogue constructor if really no parent is wanted
// whereas NULL chooses the deafult dialogue parent
#define DIALOG_NO_PARENT ((Window*)0xffffffff)

// ----------
// - Dialog -
// ----------

class Dialog : public SystemWindow
{
private:
	Window* 		mpDialogParent;
	long			mnDummy;
	Dialog* 		mpPrevExecuteDlg;
	long*			mpResult;
	long			mnDummy1;
	long			mnMousePositioned;
	BOOL			mbInExecute;
	BOOL			mbOldSaveBack;
	BOOL			mbInClose;
	BOOL			mbModalMode;

#ifdef _SV_DIALOG_CXX
	void			ImplInitData();
	void			ImplInitSettings();
#endif

#if 0 // _SOLAR__PRIVATE
protected:
	void			ImplInit( Window* pParent, WinBits nStyle );
	void			ImplDialogRes( const ResId& rResId );
	void			ImplCenterDialog();

public:
	BOOL			IsInClose() const { return mbInClose; }
#endif

protected:
					Dialog( WindowType nType );
	virtual void	Draw( OutputDevice* pDev, const Point& rPos, const Size& rSize, ULONG nFlags );

public:
					Dialog( Window* pParent, WinBits nStyle = WB_STDDIALOG );
					Dialog( Window* pParent, const ResId& rResId );

	virtual long	Notify( NotifyEvent& rNEvt );
	virtual void	StateChanged( StateChangedType nStateChange );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );

	virtual BOOL	Close();

	virtual short	Execute();
	BOOL			IsInExecute() const { return mbInExecute; }
	void			EndDialog( long nResult = 0 );
	static void		EndAllDialogs( Window* pParent=NULL );

    void            GetDrawWindowBorder( long& rLeftBorder, long& rTopBorder,
                                         long& rRightBorder, long& rBottomBorder ) const;

	void			SetModalInputMode( BOOL bModal );
	void			SetModalInputMode( BOOL bModal, BOOL bSubModalDialogs );
	BOOL			IsModalInputMode() const { return mbModalMode; }

	void			GrabFocusToFirstControl();
};

// ------------------
// - ModelessDialog -
// ------------------

class ModelessDialog : public Dialog
{
public:
					ModelessDialog( Window* pParent, WinBits nStyle = WB_STDMODELESS );
					ModelessDialog( Window* pParent, const ResId& rResId );
};

// ---------------
// - ModalDialog -
// ---------------

class ModalDialog : public Dialog
{
public:
					ModalDialog( Window* pParent, WinBits nStyle = WB_STDMODAL );
					ModalDialog( Window* pParent, const ResId& rResId );

private:
	void			Show( BOOL bVisible = TRUE );
	void			Hide();
};

#endif	// _SV_DIALOG_HXX
