/*************************************************************************
 *
 *  $RCSfile: paraprev.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:00:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_PARAPREV_HXX
#define _SVX_PARAPREV_HXX

// include ---------------------------------------------------------------

#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif

#ifndef _SVX_SVXENUM_HXX //autogen
#include <svx/svxenum.hxx>
#endif

// enum ------------------------------------------------------------------

enum SvxPrevLineSpace
{
	SVX_PREV_LINESPACE_1 = 0,
	SVX_PREV_LINESPACE_15,
	SVX_PREV_LINESPACE_2,
	SVX_PREV_LINESPACE_PROP,
	SVX_PREV_LINESPACE_MIN,
	SVX_PREV_LINESPACE_DURCH
};

// class SvxParaPrevWindow -----------------------------------------------

class SvxParaPrevWindow : public Window
{
private:
	Size				aWinSize;
	Size				aSize;

	// Einzuege
	long				nLeftMargin;
	long				nRightMargin;
	short	   			nFirstLineOfst;
	// Abstaende
	USHORT				nUpper;
	USHORT				nLower;
	// Ausrichtung
	SvxAdjust			eAdjust;
#if  SUPD>352
	// Letzte Zeile im Blocksatz
	SvxAdjust			eLastLine;
#endif
	// Zeilenabstand
	SvxPrevLineSpace	eLine;
	USHORT				nLineVal;

	String				aText;
	Rectangle			Lines[9];

protected:
	virtual void Paint( const Rectangle& rRect );

	void DrawParagraph( BOOL bAll );

public:
	SvxParaPrevWindow( Window* pParent, const ResId& rId );

	void		SetFirstLineOfst( short nNew ) { nFirstLineOfst = nNew; }
	void		SetLeftMargin( long nNew ) 	{ nLeftMargin = nNew; }
	void		SetRightMargin( long nNew )	{ nRightMargin = nNew; }
	void		SetUpper( USHORT nNew )			{ nUpper = nNew; }
	void		SetLower( USHORT nNew )			{ nLower = nNew; }
	void		SetAdjust( SvxAdjust eNew )		{ eAdjust = eNew; }
#if  SUPD>352
	void		SetLastLine( SvxAdjust eNew )	{ eLastLine = eNew; }
#endif
	void		SetLineSpace( SvxPrevLineSpace eNew, USHORT nNew = 0 )
					{   eLine = eNew; nLineVal = nNew; }
	void        SetText( const String& rStr )	{ aText = rStr; }
	void		SetSize( Size aNew )			{ aSize = aNew; }

	short		GetFirstLineOfst() const 		{ return nFirstLineOfst; }
	long		GetLeftMargin() const			{ return nLeftMargin; }
	long		GetRightMargin() const			{ return nRightMargin; }
	USHORT		GetUpper() const				{ return nUpper; }
	USHORT		GetLower() const				{ return nLower; }
	SvxAdjust	GetAdjust() const				{ return eAdjust; }

	SvxPrevLineSpace	GetLineEnum() const 	{ return eLine; }
	USHORT				GetLineValue() const	{ return nLineVal; }
	String				GetText() const			{ return aText; }
	Size				GetSize() const			{ return aSize; }

	void		OutputSizeChanged();

	void 		Draw( BOOL bAll ) 				{ DrawParagraph( bAll ); }
};

#endif

