/*************************************************************************
 *
 *  $RCSfile: accessibilityoptions.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: fs $ $Date: 2002/11/26 15:50:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef INCLUDED_SVTOOLS_ACCESSIBILITYOPTIONS_HXX
#define INCLUDED_SVTOOLS_ACCESSIBILITYOPTIONS_HXX

#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _SFXBRDCST_HXX
#include <svtools/brdcst.hxx>
#endif
#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif

class SvtAccessibilityOptions_Impl;

class SvtAccessibilityOptions : public SfxBroadcaster, private SfxListener
{
private:
	static SvtAccessibilityOptions_Impl* volatile sm_pSingleImplConfig;
	static sal_Int32					 volatile sm_nAccessibilityRefCount;
	static ::osl::Mutex	m_aSingletonMutex;

public:
	SvtAccessibilityOptions();
	~SvtAccessibilityOptions();

	// get & set config entries
	sal_Bool 	GetIsForDrawings() const;		// obsolete!
    sal_Bool    GetIsForBorders() const;		// obsolete!
    sal_Bool    GetIsForPagePreviews() const;
	sal_Bool 	GetIsHelpTipsDisappear() const;
	sal_Bool 	GetIsAllowAnimatedGraphics() const;
	sal_Bool 	GetIsAllowAnimatedText() const;
	sal_Bool 	GetIsAutomaticFontColor() const;
	sal_Bool 	GetIsSystemFont() const;
	sal_Int16	GetHelpTipSeconds() const;
    sal_Bool    IsSelectionInReadonly() const;
	sal_Bool	GetAutoDetectSystemHC() const;

	void 		SetIsForDrawings(sal_Bool bSet);
    void        SetIsForBorders(sal_Bool bSet);
    void        SetIsForPagePreviews(sal_Bool bSet);
	void 		SetIsHelpTipsDisappear(sal_Bool bSet);
	void 		SetIsAllowAnimatedGraphics(sal_Bool bSet);
	void 		SetIsAllowAnimatedText(sal_Bool bSet);
	void 		SetIsAutomaticFontColor(sal_Bool bSet);
	void 		SetIsSystemFont(sal_Bool bSet);
	void		SetHelpTipSeconds(sal_Int16 nSet);
    void        SetSelectionInReadonly(sal_Bool bSet);
	void        SetAutoDetectSystemHC(sal_Bool bSet);

	sal_Bool                IsModified() const;
	void		            Commit();

	//SfxListener:
	virtual void		Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
};

#endif // #ifndef INCLUDED_SVTOOLS_ACCESSIBILITYOPTIONS_HXX

