/*************************************************************************
 *
 *  $RCSfile: linkmgr.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:28:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _LINKMGR_HXX
#define _LINKMGR_HXX

#ifndef _LINKSRC_HXX
#include <so3/linksrc.hxx>
#endif
#ifndef _TOOLS_STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

class SvPersist;

namespace so3
{
class SvBaseLink;
class SvBaseLinkRef;

typedef SvBaseLinkRef* SvBaseLinkRefPtr;
SV_DECL_PTRARR( SvBaseLinks, SvBaseLinkRefPtr, 1, 1 )

typedef SvLinkSource* SvLinkSourcePtr;
SV_DECL_PTRARR( SvLinkSources, SvLinkSourcePtr, 1, 1 )

class SvLinkManager
{
	SvBaseLinks		aLinkTbl;
	SvLinkSources aServerTbl;
	SvPersist	*pPersist; // LinkMgr muss vor SvPersist freigegeben werden
protected:
	BOOL 		InsertLink( SvBaseLink* pLink, USHORT nObjType, USHORT nUpdateType,
							const String* pName = 0 );
public:
				SvLinkManager();
				~SvLinkManager();

	SvPersist*	GetPersist() const 				{ return pPersist; }
	void        SetPersist( SvPersist * p ) 	{ pPersist = p; }

	void		Remove( SvBaseLink *pLink );
	void		Remove( USHORT nPos, USHORT nCnt = 1 );
	BOOL		Insert( SvBaseLink* pLink );

				// den Link mit einem SvLinkSource verbinden und in die Liste eintragen
	BOOL 		InsertDDELink( SvBaseLink*,
						const String& rServer,
						const String& rTopic,
						const String& rItem );

				// falls am Link schon alles eingestellt ist !
	BOOL 		InsertDDELink( SvBaseLink* );

				// erfrage die Strings fuer den Dialog
	virtual BOOL GetDisplayNames( const SvBaseLink *,
									String* pType,
									String* pFile = 0,
									String* pLink = 0,
									String* pFilter = 0 ) const;

	virtual SvLinkSourceRef CreateObj( SvBaseLink * );

	void 		UpdateAllLinks( BOOL bAskUpdate = TRUE,
								BOOL bCallErrHdl = TRUE,
                                BOOL bUpdateGrfLinks = FALSE, 
                                Window* pParentWin = 0 );

				// Liste aller Links erfragen (z.B. fuer Verknuepfungs-Dialog)
	const 		SvBaseLinks& GetLinks() const { return aLinkTbl; }

	// ----------------- Serverseitige Verwaltung --------------------

				// Liste der zu serviereden Links erfragen
	const SvLinkSources& GetServers() const { return aServerTbl; }
				// einen zu servierenden Link eintragen/loeschen
	BOOL 		InsertServer( SvLinkSource* rObj );
	void 		RemoveServer( SvLinkSource* rObj );
	void 		RemoveServer( USHORT nPos, USHORT nCnt = 1 )
				{	aServerTbl.Remove( nPos, nCnt ); }

private:
				// diese Methoden gibts nicht!
				SvLinkManager( const SvLinkManager& );
				SvLinkManager& operator=( const SvLinkManager& );
};

// Trenner im LinkName fuer die DDE-/File-/Grafik- Links
// (nur wer es braucht, um einen SvLinkName zusammenzubasteln)
const sal_Char cTokenSeperator = '\xff';

// erzeuge einen String fuer den SvLinkName. Fuer
// - DDE die ersten 3 Strings, (Server, Topic, Item)
// - File-/Grf-LinkNms die letzen 3 Strings (FileName, Bereich, Filter)
void MakeLnkName( String& rName,
				 const String* pType,		// kann auch 0 sein !!
				 const String& rFile,
				 const String& rLink,
				 const String* pFilter = 0 );

}

#endif

