/*************************************************************************
 *
 *  $RCSfile: parameterhelper.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: gh $ $Date: 2002/10/15 12:16:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef PARAMETERHELPER_HXX
#define PARAMETERHELPER_HXX

#ifndef _RTL_STRING_HXX_
#include "rtl/string.hxx"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif

#ifndef INCLUDED_VECTOR
#include <vector>  /* std::vector */
#endif

#define OVERRIDE_EXISTING_VALUES        1
#define DO_NOT_OVERRIDE_EXISTING_VALUES 2

typedef std::pair< rtl::OUString, rtl::OUString > Assoc;
typedef std::vector< Assoc > Dictionary;

namespace ParameterHelper
{
	class Association
	{
		Dictionary m_aDictionary;

		// NO COPY
		Association(Association const& );
		Association& operator=(Association const&);

		sal_Bool 	  checkString( rtl::OUString const& _suString );
		Assoc    	  makeAssoc(rtl::OUString const& _sKeyEqualValue);
		void     	  insertAnAssoc(Assoc const& _aAssoc, sal_Int16 _nOverrideType);
		rtl::OUString findSecond(Dictionary const& _aDictionary, rtl::OUString const& _sKey);
		bool          existKey(rtl::OUString const& _sKey);
		void          removeKey(rtl::OUString const& _sKey);
	public:
		Association();
		void feedDictionary(rtl::OUString const& _suKeyEqualValue, sal_Int16 _nOverrideType = DO_NOT_OVERRIDE_EXISTING_VALUES);
		void feedDictionary(rtl::OString const& _sKey, rtl::OString const& _sValue, sal_Int16 _nOverrideType = DO_NOT_OVERRIDE_EXISTING_VALUES );

		// Name Based Access
		rtl::OUString getSecond(rtl::OUString const& _suKey);
		rtl::OUString getSecond(rtl::OString const&  _psKey);

		// Index Based Access
		sal_Int32 getCount();
		rtl::OUString getOne(sal_Int32 _nIdx);
		rtl::OUString getFirst(sal_Int32 _nIdx);
		rtl::OUString getSecond(sal_Int32 _nIdx);

        // Other
        void clear(){ m_aDictionary.clear(); }
	};

	ByteString QuoteIfNeed(ByteString const& _sStr);
}

namespace StringHelper
{
typedef std::vector<rtl::OUString> StringList;

	rtl::OString Quote(rtl::OString const& _sStr);
	StringList tokenizeByComma(rtl::OUString const& _sCSVList);
}

#endif
