/*************************************************************************
 *
 *  $RCSfile: envset.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:02:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ENVSET_HXX
#define _ENVSET_HXX

#include <tools/string.hxx>
#include <tools/list.hxx>

// forwards
class GenericInformationList;

//
// class Switch
//

/******************************************************************************
* Purpose: Holds a command line switch and its value
******************************************************************************/

class Switch : public ByteString
{
private:
	ByteString sValue;
	BOOL bValid;

public:
	Switch( ByteString &rSwitch, ByteString &rVal )
					: ByteString( rSwitch ),
					sValue( rVal ), bValid( FALSE ) {};
	ByteString &GetValue() { return sValue; }
	void Valid() { bValid = TRUE; }
	BOOL IsValid() { return bValid; }
};

//
// class SwitchList
//

/******************************************************************************
* Purpose: Holds a set of unique switches
******************************************************************************/

DECLARE_LIST( SwitchList_Impl, Switch * );

class SwitchList : public SwitchList_Impl
{
public:
	SwitchList() {};

	void InsertUnique( Switch *pObject );
};

//
// class EnvironmentVariable
//

/******************************************************************************
* Purpose: Holds the value of an environment variable and allows to set it
******************************************************************************/

class EnvironmentVariable : public ByteString
{
private:
	ByteString sValue;	// holds the value
public:
	EnvironmentVariable( const ByteString &rVar, const ByteString &rVal );
	EnvironmentVariable( const ByteString &rVar );

	ByteString &GetValue( BOOL bOutOfEnv = FALSE );
	void SetValue( const ByteString &rVal, BOOL bIntoEnv = FALSE );

	void PutEnv();
	void PutEnv( const ByteString &rVal );
	ByteString &GetEnv();

	ByteString GetSetter( BOOL bUnset = FALSE ); // returns something like "variable=value"
};

DECLARE_LIST( EnvironmentList, EnvironmentVariable * );
DECLARE_LIST( ScriptLines, ByteString* );

//
// class EnvironmentSetter
//

/******************************************************************************
* Purpose: Sets whole environment needed to build a StarDivision project
******************************************************************************/

#define ENVSET_NO_ERROR			0x0000
#define ENVSET_NO_FILE			0x0001
#define ENVSET_FILE_ERROR			   	0x0002
#define ENVSET_SWITCHES_ERROR		   	0x0004
#define ENVSET_NO_ENVIRONMENT		   	0x0008
#define ENVSET_NO_SWITCH			   	0x000F
#define ENVSET_MISSING_VALUE	  		0x0010
#define ENVSET_NO_ORDER					0x0020
#define ENVSET_UNKNOWN_BLOCK			0x0040
#define ENVSET_VERLISTENTRY_NOT_FOUND   0x0080

class EnvironmentSetter : public EnvironmentList
{
private:
	USHORT nError;
	SwitchList *pPossibleSwitches;

	ScriptLines aPreScript;
	ScriptLines aPostScript;

	GenericInformationList *pInfoList;
	GenericInformationList *pVersionList;

protected:
	virtual void PrintStatus( const char* pStatus ) {};

public:
	EnvironmentSetter( const ByteString &rConfigFile,
		GenericInformationList *pVerList,
		EnvironmentSetter* pSourceSetter = NULL );
	~EnvironmentSetter();

	USHORT GetError() { return nError; }

	SwitchList *GetPossibleSwitches();
	USHORT Execute( SwitchList &rSwitches, ByteString sEnvironment );

	BOOL CheckIfStatement( const ByteString &rStatement );
	void Expand( ByteString &rVariableToExpand );

	void Insert( const ByteString &rVar, const ByteString &rVal );

	void Set();
	BOOL WriteToFile( const ByteString &rFileName ); // creates a batch
};

#endif
