/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.loader;

import com.sun.star.lib.sandbox.ClassContext;
import com.sun.star.lib.sandbox.ClassContextProxy;
import com.sun.star.lib.sandbox.ResourceProxy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class RegistrationClassFinder {
    static final boolean DEBUG = false;
    protected ClassContext m_context = null;
    protected String m_locationUrl = null;
    protected String m_manifest = null;
    protected String m_className = null;
    private static String[] s_accessPath;
    private static boolean s_bInit;

    public RegistrationClassFinder(String string) throws IOException, MalformedURLException {
        this.m_locationUrl = string;
        if (string.endsWith(".jar")) {
            this.m_context = ClassContextProxy.create((URL)new URL(this.m_locationUrl), null, null, (boolean)true);
            this.m_manifest = string + "/META-INF/MANIFEST.MF";
        }
    }

    private static final boolean checkAccessPath(URL uRL) {
        String[] stringArray;
        if (!s_bInit) {
            stringArray = null;
            String string = System.getProperty("com.sun.star.comp.loader.CPLD_ACCESSPATH");
            if (string != null) {
                int n = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                stringArray = new String[stringTokenizer.countTokens()];
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        try {
                            stringArray[n] = new File(stringTokenizer.nextToken()).getCanonicalPath();
                            ++n;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                if (n != stringArray.length) {
                    String[] stringArray2 = new String[n];
                    System.arraycopy(stringArray, 0, stringArray2, 0, n);
                    stringArray = stringArray2;
                }
            }
            s_accessPath = stringArray;
            s_bInit = true;
        }
        if (s_accessPath == null) {
            return true;
        }
        if (!uRL.getProtocol().equals("file")) {
            return false;
        }
        try {
            stringArray = new File(uRL.getFile()).getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        for (int i = 0; i < s_accessPath.length; ++i) {
            String string = s_accessPath[i];
            if (0 != stringArray.indexOf(string) || stringArray.length() <= string.length() || string.charAt(string.length() - 1) != File.separatorChar && stringArray.charAt(string.length()) != File.separatorChar) continue;
            return true;
        }
        return false;
    }

    public Class getRegistrationClass() throws IOException, ClassNotFoundException, MalformedURLException {
        Class clazz = null;
        if (this.m_context != null) {
            String string = null;
            URL uRL = new URL(this.m_locationUrl);
            if (!RegistrationClassFinder.checkAccessPath(uRL)) {
                throw new ClassNotFoundException("jar access failed!");
            }
            ResourceProxy resourceProxy = ResourceProxy.load((URL)uRL, null);
            resourceProxy.loadJar(uRL);
            this.m_context.addCargo((Object)resourceProxy);
            InputStream inputStream = ResourceProxy.load((URL)new URL(this.m_manifest), null).getInputStream();
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = manifest.getMainAttributes();
            string = attributes.getValue("RegistrationClassName");
            if (string != null) {
                clazz = this.m_context.loadClass(string);
            }
        } else {
            clazz = Class.forName(this.m_locationUrl);
        }
        return clazz;
    }

    public Class loadClass(String string) throws ClassNotFoundException, IOException, MalformedURLException {
        Class clazz = null;
        if (this.m_context != null) {
            URL uRL = new URL(this.m_locationUrl);
            if (!RegistrationClassFinder.checkAccessPath(uRL)) {
                throw new ClassNotFoundException("jar access failed!");
            }
            ResourceProxy resourceProxy = ResourceProxy.load((URL)uRL, null);
            resourceProxy.loadJar(uRL);
            clazz = this.m_context.loadClass(string);
        } else {
            clazz = Class.forName(string);
        }
        return clazz;
    }

    static {
        s_bInit = false;
    }
}

