/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DbUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Dbt {
    private byte[] data = null;
    private int dlen = 0;
    private int doff = 0;
    private int flags = 0;
    private int offset = 0;
    private int size = 0;
    private int ulen = 0;

    public Dbt() {
    }

    public Dbt(byte[] data) {
        this.data = data;
        if (data != null) {
            this.size = data.length;
        }
    }

    public Dbt(byte[] data, int off, int len) {
        this.data = data;
        this.offset = off;
        this.size = len;
    }

    public Dbt(Object serialobj) throws IOException {
        this.setObject(serialobj);
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setObject(Object serialobj) throws IOException {
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bytestream);
        oos.writeObject(serialobj);
        oos.close();
        byte[] buf = bytestream.toByteArray();
        bytestream.close();
        this.set_data(buf);
        this.set_offset(0);
        this.set_size(buf.length);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setPartialLength(int dlen) {
        this.dlen = dlen;
    }

    public void setPartialOffset(int doff) {
        this.doff = doff;
    }

    public void setRecordNumber(int recno) {
        if (this.data == null) {
            this.data = new byte[4];
            this.size = 4;
            this.offset = 0;
        }
        DbUtil.int2array(recno, this.data, this.offset);
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setUserBufferLength(int ulen) {
        this.ulen = ulen;
    }

    public void set_data(byte[] data) {
        this.setData(data);
    }

    public void set_dlen(int dlen) {
        this.setPartialLength(dlen);
    }

    public void set_doff(int doff) {
        this.setPartialOffset(doff);
    }

    public void set_flags(int flags) {
        this.setFlags(flags);
    }

    public void set_object(Object serialobj) throws IOException {
        this.setObject(serialobj);
    }

    public void set_offset(int offset) {
        this.setOffset(offset);
    }

    public void set_recno_key_data(int recno) {
        this.setRecordNumber(recno);
    }

    public void set_size(int size) {
        this.setSize(size);
    }

    public void set_ulen(int ulen) {
        this.setUserBufferLength(ulen);
    }

    void set_recno_key_from_buffer(byte[] data, int offset) {
        this.data = data;
        this.offset = offset;
        this.size = 4;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getFlags() {
        return this.flags;
    }

    public Object getObject() throws IOException, ClassNotFoundException {
        ByteArrayInputStream bytestream = new ByteArrayInputStream(this.get_data());
        ObjectInputStream ois = new ObjectInputStream(bytestream);
        Object serialobj = ois.readObject();
        ois.close();
        bytestream.close();
        return serialobj;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getPartialLength() {
        return this.dlen;
    }

    public int getPartialOffset() {
        return this.doff;
    }

    public int getRecordNumber() {
        return DbUtil.array2int(this.data, this.offset);
    }

    public int getSize() {
        return this.size;
    }

    public int getUserBufferLength() {
        return this.ulen;
    }

    public byte[] get_data() {
        return this.getData();
    }

    public int get_dlen() {
        return this.getPartialLength();
    }

    public int get_doff() {
        return this.getPartialOffset();
    }

    public int get_flags() {
        return this.getFlags();
    }

    public Object get_object() throws IOException, ClassNotFoundException {
        return this.getObject();
    }

    public int get_offset() {
        return this.getOffset();
    }

    public int get_recno_key_data() {
        return this.getRecordNumber();
    }

    public int get_size() {
        return this.getSize();
    }

    public int get_ulen() {
        return this.getUserBufferLength();
    }
}

