#/bin/sh
log_file="Add_SetLocaleC.log"
remove_script="remove_Add_SetLocaleC_file.sh"

rm -f $log_file
rm -f $remove_script

for file in `find * ! -type d -and \\( -name *.c -or -name *.h -or -name *.cxx -or -name *.hxx  -or -name *.cpp -or -name *.hpp \\) -exec grep -l --binary-files=without-match '[-]\(['"'"'"]\|$\)' {} \\;`
do
	echo $file | grep -i "\.pro" > /dev/null
	if [ ! $? -eq 0 ]; then
		if [ ! -e $file.orig ]; then
			cp -p $file $file.orig
		fi
		grep -i "#pragma setlocale(\"C\")" $file > /dev/null
		if [ ! $? -eq 0 ]; then
			sed -e 's/ \*\{70,\}\/$/&\n\n#pragma setlocale("C")/' $file > $file.new
			rm -f $file && cp -p $file.new $file && rm $file.new

			echo "add \`#pragma setlocale(\"C\")' to $file" | tee -a $log_file

			if [ ! -e "$remove_script" ]; then
				echo '#!/bin/sh' > $remove_script
			fi
			echo "rm -fv $file" >> $remove_script
		fi
	fi
done

if [ -e "$remove_script" ]; then
chmod 755 $remove_script
fi
