/*************************************************************************
 *
 *  $RCSfile: gfxlink.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/24 07:32:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_GFXLINK_HXX
#define _SV_GFXLINK_HXX

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _SV_MAPMOD_HXX
#include <vcl/mapmod.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#if 0 // _SOLAR__PRIVATE

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

// -------------
// - ImpBuffer -
// -------------

struct ImpBuffer
{
	ULONG		mnRefCount;
	BYTE*		mpBuffer;

				ImpBuffer( ULONG nSize )
				{
					mnRefCount = 1UL;
					mpBuffer = nSize ? new BYTE[ nSize ] : NULL;
				}

				ImpBuffer( BYTE* pBuf ) { mnRefCount = 1UL; mpBuffer = pBuf; }

				~ImpBuffer() { delete[] mpBuffer; }
};

// -----------
// - ImpSwap -
// -----------

struct ImpSwap
{
    INetURLObject   maURL;
	ULONG			mnDataSize;
	ULONG			mnRefCount;

					ImpSwap( BYTE* pData, ULONG nDataSize );
					~ImpSwap();

	BYTE*			GetData() const;

	BOOL			IsSwapped() const { return maURL.GetMainURL( INetURLObject::NO_DECODE ).Len() > 0; }

	void			WriteTo( SvStream& rOStm ) const;
};

// --------------
// - ImpGfxLink -
// --------------

struct ImpGfxLink
{
    MapMode         maPrefMapMode;
    Size            maPrefSize;
    bool			mbPrefMapModeValid;
    bool			mbPrefSizeValid;

    ImpGfxLink() : 
        maPrefMapMode(),
        maPrefSize(),
        mbPrefMapModeValid( false ), 
        mbPrefSizeValid( false ) 
    {}
};

#endif // __PRIVATE

// ---------------
// - GfxLinkType -
// ---------------

enum GfxLinkType
{
	GFX_LINK_TYPE_NONE			= 0,
	GFX_LINK_TYPE_EPS_BUFFER	= 1,
	GFX_LINK_TYPE_NATIVE_GIF	= 2,	// Don't forget to update the following defines
	GFX_LINK_TYPE_NATIVE_JPG	= 3,	// Don't forget to update the following defines
	GFX_LINK_TYPE_NATIVE_PNG	= 4,	// Don't forget to update the following defines
	GFX_LINK_TYPE_NATIVE_TIF	= 5,	// Don't forget to update the following defines
	GFX_LINK_TYPE_NATIVE_WMF	= 6,	// Don't forget to update the following defines
	GFX_LINK_TYPE_NATIVE_MET	= 7,	// Don't forget to update the following defines
	GFX_LINK_TYPE_NATIVE_PCT	= 8,	// Don't forget to update the following defines
	GFX_LINK_TYPE_USER			= 0xffff
};

#define GFX_LINK_FIRST_NATIVE_ID	GFX_LINK_TYPE_NATIVE_GIF
#define GFX_LINK_LAST_NATIVE_ID		GFX_LINK_TYPE_NATIVE_PCT

// -----------
// - GfxLink -
// -----------

struct ImpBuffer;
struct ImpSwap;
struct ImpGfxLink;
class Graphic;

class GfxLink
{
private:

	GfxLinkType			meType;
	ImpBuffer*			mpBuf;
	ImpSwap*			mpSwap;
	ULONG				mnBufSize;
	ULONG				mnUserId;
    ImpGfxLink*         mpImpData;
	ULONG				mnExtra2;

	void				ImplCopy( const GfxLink& rGfxLink );

public:					
						GfxLink();
						GfxLink( const GfxLink& );
						GfxLink( const String& rPath, GfxLinkType nType );
						GfxLink( BYTE* pBuf, ULONG nBufSize, GfxLinkType nType, BOOL bOwns );
						~GfxLink();

	GfxLink&			operator=( const GfxLink& );
	sal_Bool			IsEqual( const GfxLink& ) const;

	GfxLinkType			GetType() const;

	void				SetUserId( ULONG nUserId ) { mnUserId = nUserId; }
	ULONG				GetUserId() const { return mnUserId; }

	ULONG				GetDataSize() const;	
	void				SetData( BYTE* pBuf, ULONG nSize, GfxLinkType nType, BOOL bOwns );
	const BYTE*			GetData() const;

	const Size&			GetPrefSize() const;
	void				SetPrefSize( const Size& rPrefSize );
	bool 				IsPrefSizeValid();

	const MapMode&		GetPrefMapMode() const;
	void				SetPrefMapMode( const MapMode& rPrefMapMode );
	bool 				IsPrefMapModeValid();

	BOOL				IsNative() const;
	BOOL				IsUser() const { return( GFX_LINK_TYPE_USER == meType ); }

	BOOL				LoadNative( Graphic& rGraphic );

	void				SwapOut();
	void				SwapIn();
	BOOL				IsSwappedOut() const { return( mpSwap != NULL ); }

public:

	friend SvStream&	operator<<( SvStream& rOStream, const GfxLink& rGfxLink );
	friend SvStream&	operator>>( SvStream& rIStream, GfxLink& rGfxLink );
};

#endif
