/*************************************************************************
 *
 *  $RCSfile: itemset.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 14:36:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXITEMSET_HXX
#define _SFXITEMSET_HXX

#if STLPORT_VERSION<321
#include <stdarg.h>
#else
#include <cstdarg> 	// std::va_list and friends
#endif

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _RTTI_HXX //autogen
#include <tools/rtti.hxx>
#endif
#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

class SfxItemPool;
class SfxPoolItem;
class SvStream;

typedef SfxPoolItem const** SfxItemArray;

#if SUPD<=383

#if defined MAC || ( defined SOLARIS && defined X86 ) || ( defined SINIX && defined GCC ) || defined SCO
#define USHORT_ARG	int
#else
#define USHORT_ARG	USHORT
#endif

#else

#define USHORT_ARG int

#endif

#ifdef MI_HATS_REPARIERT
#ifndef DBG
#ifdef DBG_UTILx
#define DBG(s) s
#define _pChildCount(THIS)  (  *(USHORT**)SfxPointerServer::GetServer()->GetPointer(THIS) )
#define _pChildCountCtor	( (*(USHORT**)SfxPointerServer::GetServer()->CreatePointer(this)) = new USHORT )
#define _pChildCountDtor	( SfxPointerServer::GetServer()->ReleasePointer(this) )
#else
#define DBG(s)
#endif
#endif
#else
#ifdef DBG
#undef DBG
#endif
#define DBG(s)
#endif

//========================================================================

#define SFX_ITEMSET_GET( rSet, pItem, ItemType, nSlotId, bDeep ) \
	const ItemType *pItem = (const ItemType*) \
							(rSet).GetItem( nSlotId, bDeep, TYPE(ItemType) )

//========================================================================

class SfxItemSet
{
friend class SfxItemIter;

	SfxItemPool*				_pPool; 		// der verwendete Pool
	const SfxItemSet*           _pParent;       // Ableitung
	SfxItemArray                _aItems;        // Item-Feld
	USHORT*                     _pWhichRanges;  // Array von Which-Bereichen
	USHORT                      _nCount;        // Anzahl Items

	//---------------------------------------------------------------------
#ifndef _SFXITEMS_HXX

friend class SfxItemPoolCache;
friend class SfxAllItemSet;
friend const char *DbgCheckItemSet( const void* );

private:
	void						InitRanges_Impl(const USHORT *nWhichPairTable);
	void						InitRanges_Impl(va_list pWhich, USHORT n1, USHORT n2, USHORT n3);
	void						InitRanges_Impl(USHORT nWh1, USHORT nWh2);

public:
	SfxItemArray				GetItems_Impl() const { return _aItems; }

#endif
	//---------------------------------------------------------------------

private:
	const SfxItemSet&			operator=(const SfxItemSet &);	 // n.i.!!

protected:
	// Notification-Callback
	virtual void				Changed( const SfxPoolItem& rOld, const SfxPoolItem& rNew );

	// direkte Put-Methode
	int 						PutDirect(const SfxPoolItem &rItem);

public:
								SfxItemSet( const SfxItemSet& );
#if SUPD<367
								SfxItemSet( SfxItemPool& );
#endif

#if SUPD<367 || defined(SFX_ITEMSET_NO_DEFAULT_CTOR)
								SfxItemSet( SfxItemPool&, BOOL bTotalPoolRanges );
#else
								SfxItemSet( SfxItemPool&, BOOL bTotalPoolRanges = FALSE );
#endif
								SfxItemSet( SfxItemPool&, USHORT nWhich1, USHORT nWhich2 );
								SfxItemSet( SfxItemPool&, USHORT_ARG nWh1, USHORT_ARG nWh2, USHORT_ARG nNull, ... );
								SfxItemSet( SfxItemPool&, const USHORT* nWhichPairTable );
	virtual                     ~SfxItemSet();

	virtual SfxItemSet *		Clone(BOOL bItems = TRUE, SfxItemPool *pToPool = 0) const;

	// Items erfragen
	USHORT						Count() const { return _nCount; }
	USHORT						TotalCount() const;
#if SUPD >= 565
	virtual	const SfxPoolItem&	Get( USHORT nWhich, BOOL bSrchInParent = TRUE ) const;
#else
	const SfxPoolItem&			Get( USHORT nWhich, BOOL bSrchInParent = TRUE ) const;
#endif
	const SfxPoolItem*  		GetItem( USHORT nWhich, BOOL bSrchInParent = TRUE,
										 TypeId aItemType = 0 ) const;

	// Which-Wert des Items an der Position nPos erfragen
	USHORT						GetWhichByPos(USHORT nPos) const;

	// Item-Status erfragen
	SfxItemState				GetItemState(	USHORT nWhich,
												BOOL bSrchInParent = TRUE,
												const SfxPoolItem **ppItem = 0 ) const;

	virtual void				DisableItem(USHORT nWhich);
	virtual void				InvalidateItem( USHORT nWhich );
	virtual USHORT              ClearItem( USHORT nWhich = 0);
	virtual void				ClearInvalidItems( BOOL bHardDefault = FALSE );
			void 				InvalidateAllItems(); HACK(via nWhich = 0)

	inline void 				SetParent( const SfxItemSet* pNew );

	// Items hinzufuegen, loeschen etc.
	virtual const SfxPoolItem*	Put( const SfxPoolItem&, USHORT nWhich );
	const SfxPoolItem*			Put( const SfxPoolItem& rItem )
								{ return Put(rItem, rItem.Which()); }
	virtual int 				Put( const SfxItemSet&,
									 BOOL bInvalidAsDefault = TRUE );
	void						PutExtended( const SfxItemSet&,
											 SfxItemState eDontCareAs = SFX_ITEM_UNKNOWN,
											 SfxItemState eDefaultAs = SFX_ITEM_UNKNOWN );

	virtual int 				Set( const SfxItemSet&, BOOL bDeep = TRUE );

	virtual void				Intersect( const SfxItemSet& rSet );
	virtual void				MergeValues( const SfxItemSet& rSet, BOOL bOverwriteDefaults = FALSE );
	virtual void				Differentiate( const SfxItemSet& rSet );
	virtual void				MergeValue( const SfxPoolItem& rItem, BOOL bOverwriteDefaults = FALSE  );

	SfxItemPool*				GetPool() const { return _pPool; }
	const USHORT*				GetRanges() const { return _pWhichRanges; }
	void						SetRanges( const USHORT *pRanges );
	void						MergeRange( USHORT nFrom, USHORT nTo );
	const SfxItemSet*			GetParent() const { return _pParent; }

	virtual SvStream &			Load( SvStream &, FASTBOOL bDirect = FALSE,
									  const SfxItemPool *pRefPool = 0 );
	virtual SvStream &			Store( SvStream &, FASTBOOL bDirect = FALSE ) const;

	virtual int                 operator==(const SfxItemSet &) const;
};

// --------------- Inline Implementierungen ------------------------

inline void SfxItemSet::SetParent( const SfxItemSet* pNew )
{
	DBG( if (_pParent) --*_pChildCount(_pParent) );
	_pParent = pNew;
	DBG( if (_pParent) ++*_pChildCount(_pParent) );
}

//========================================================================

class SfxAllItemSet: public SfxItemSet

/*  versteht alle Ranges; werden durch das Putten der Items
	automatisch angepasst
*/

{
	SfxVoidItem 				aDefault;
	USHORT 						nFree;

public:
								SfxAllItemSet( SfxItemPool &rPool );
								SfxAllItemSet( const SfxItemSet & );
								SfxAllItemSet( const SfxAllItemSet & );

	virtual SfxItemSet *		Clone( BOOL bItems = TRUE, SfxItemPool *pToPool = 0 ) const;
	virtual const SfxPoolItem*	Put( const SfxPoolItem&, USHORT nWhich );
	const SfxPoolItem*	        Put( const SfxPoolItem& rItem )
	{ return Put(rItem, rItem.Which()); }
	virtual int 				Put( const SfxItemSet&,
									 BOOL bInvalidAsDefault = TRUE );
//  virtual int                 Remove(USHORT nWhich);
};

#endif // #ifndef _SFXITEMSET_HXX

