/*************************************************************************
 *
 *  $RCSfile: extattr.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTATTR_HXX
#define _EXTATTR_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

class ImpEaMgr;
class Icon;
class DirEntry;
class String;
class SvFileStream;
class ResId;

class SvEaMgr
{
friend class ImpEaMgr;

private:
	ImpEaMgr*		pImp;
public:
					SvEaMgr( const DirEntry& rEntry );
					SvEaMgr( const String& rFilename );
					SvEaMgr( SvFileStream& rStream );

					~SvEaMgr();

	BOOL  			GetIcon( Icon& ) const;
	BOOL			SetIcon( const ResId& );
	BOOL			SetIcon( const String& rIconFileName );

	BOOL  			GetLongName( String& ) const;
	BOOL			SetLongName( const String& );

	BOOL  			GetFileType( String& ) const;
	BOOL			SetFileType( const String& );

	BOOL    		GetComment( String& ) const;
	BOOL			SetComment( const String& );

	BOOL  			GetCreator( String& ) const;
	BOOL			SetCreator( const String& );

	BOOL  			GetVersionInfo( String& ) const;
	BOOL			SetVersionInfo( const String& );

	BOOL			Clone( const SvEaMgr& );

	static BOOL		GetAppCreator( String& );
};

#if !defined(OS2) && !defined(MAC) && !defined(UNX)

inline SvEaMgr::SvEaMgr( const DirEntry& ) {}
inline SvEaMgr::SvEaMgr( const String& ) {}
inline SvEaMgr::SvEaMgr( SvFileStream& ) {}
inline SvEaMgr::~SvEaMgr() {}
inline BOOL SvEaMgr::GetIcon( Icon& ) const { return FALSE; }
inline BOOL SvEaMgr::SetIcon( const ResId& ) { return FALSE; }
inline BOOL SvEaMgr::SetIcon( const String&  ) { return FALSE; }
inline BOOL SvEaMgr::GetLongName( String& ) const { return FALSE; }
inline BOOL SvEaMgr::SetLongName( const String& ) { return FALSE; }
inline BOOL SvEaMgr::GetFileType( String& ) const { return FALSE; }
inline BOOL SvEaMgr::SetFileType( const String& ) { return FALSE; }
inline BOOL SvEaMgr::GetComment( String& ) const { return FALSE; }
inline BOOL SvEaMgr::SetComment( const String& ) { return FALSE; }
inline BOOL SvEaMgr::GetCreator( String& ) const { return FALSE; }
inline BOOL SvEaMgr::SetCreator( const String& ) { return FALSE; }
inline BOOL SvEaMgr::GetVersionInfo( String& ) const { return FALSE; }
inline BOOL SvEaMgr::SetVersionInfo( const String& ) { return FALSE; }
inline BOOL SvEaMgr::Clone( const SvEaMgr& ) { return FALSE; }
inline BOOL SvEaMgr::GetAppCreator( String& ) { return FALSE; }

#endif

#endif

