/*************************************************************************
 *
 *  $RCSfile: maillog.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _MAILLOG_HXX
#define _MAILLOG_HXX

// include ---------------------------------------------------------------

#ifndef _EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif
#ifndef _DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _STDCTRL_HXX //autogen
#include <svtools/stdctrl.hxx>
#endif
#ifndef _GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif

#include <goodies/mailenum.hxx>

class MailSystem;

// class MailLoginDialog -------------------------------------------------

#define HIDE_PATH       	0x01	// "Pfad" verstecken
#define HIDE_NAME       	0x02	// "Name" verstecken
#define HIDE_PASSWD     	0x04	// "Passwort" verstecken
#define HIDE_SAVE_PASSWD	0x08	// "Passwort speichern" verstecken
#define HIDE_ERROR_TEXT		0x10	// ErrorText verstecken

class MailLoginDialog : public ModalDialog
{
private:
	FixedInfo		aErrorText;
	GroupBox		aErrorBox;
	FixedText		aPathText;
	Edit			aPathEdit;
	FixedText		aNameText;
	Edit			aNameEdit;
	FixedText		aPasswordText;
	Edit			aPasswordEdit;
	CheckBox		aSavePasswdBtn;
	GroupBox		aLoginGroup;
	OKButton		aOKBtn;
	CancelButton	aCancelBtn;
	HelpButton		aHelpBtn;

	MailDriver		eDriver;

	DECL_LINK( OKHdl, Button * );

public:
	MailLoginDialog( Window* pParent, ResMgr* pResMgr, const String& rText );
	MailLoginDialog( Window* pParent, const MailSystem& rSys,
					 MailDriver eDrive, const String& rTxt );

	String			GetPath() const { return aPathEdit.GetText(); }
	void			SetPath( const String& rNewPath )
						{ aPathEdit.SetText( rNewPath ); }
	String			GetName() const { return aNameEdit.GetText(); }
	void			SetName( const String& rNewName )
						{ aNameEdit.SetText( rNewName ); }
	String			GetPassword() const { return aPasswordEdit.GetText(); }
	void			SetPassword( const String& rNew )
						{ aPasswordEdit.SetText( rNew ); }
	BOOL			IsSavePassword() const
						{ return aSavePasswdBtn.IsChecked(); }
	void			SetSavePassword( BOOL bSave )
						{ aSavePasswdBtn.Check( bSave ); }
	void			SetSavePasswordText( const String& rTxt )
						{ aSavePasswdBtn.SetText( rTxt ); }
	void			SetErrorText( const String& rTxt )
						{ aErrorText.SetText( rTxt ); }
	FASTBOOL		GetDefaultUser( String& rPath,
									String& rUser, String& rPasswd ) const;
	void			ClearPassword();
	void			HideControls( BYTE nFlag );
};

#endif

