/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.PathPattern;
import com.jclark.xsl.expr.PatternList;
import com.jclark.xsl.expr.TopLevelPattern;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.Importance;
import com.jclark.xsl.tr.Priority;
import java.util.Enumeration;
import java.util.Vector;

class TemplateRuleSet {
    private Vector rules = new Vector();
    private PatternList patternList = new PatternList();
    private Action builtinAction;

    TemplateRuleSet(Action action) {
        this.builtinAction = action;
    }

    void add(TopLevelPattern topLevelPattern, Importance importance, Importance importance2, Priority priority, Action action) {
        PathPattern[] pathPatternArray = topLevelPattern.getAlternatives();
        int n = 0;
        while (n < pathPatternArray.length) {
            this.rules.addElement(new Rule(pathPatternArray[n], importance, importance2, priority, action));
            ++n;
        }
    }

    void compile() {
        TemplateRuleSet.reverse(this.rules);
        TemplateRuleSet.sortRulesVector(this.rules);
        Enumeration enumeration = this.rules.elements();
        while (enumeration.hasMoreElements()) {
            Rule rule = (Rule)enumeration.nextElement();
            this.patternList.add(rule.pattern, rule);
        }
    }

    Action getAction(Node node, ExprContext exprContext) throws XSLException {
        Rule rule = (Rule)this.patternList.get(node, exprContext);
        if (rule == null) {
            return this.builtinAction;
        }
        return rule.action;
    }

    Action getImportAction(Node node, ExprContext exprContext, int n) throws XSLException {
        Enumeration enumeration = this.patternList.getAll(node, exprContext);
        Rule rule = (Rule)enumeration.nextElement();
        Importance importance = rule.importImportance;
        Importance importance2 = rule.ruleImportance;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            rule = (Rule)enumeration.nextElement();
            if (rule.ruleImportance.compareTo(importance2) >= 0) break;
            if (rule.ruleImportance.compareTo(importance) < 0) continue;
            if (n2 == n) {
                return rule.action;
            }
            ++n2;
            importance = rule.importImportance;
            importance2 = rule.ruleImportance;
        }
        return this.builtinAction;
    }

    private static void reverse(Vector vector) {
        int n = 0;
        int n2 = vector.size() - 1;
        while (n < n2) {
            Object e = vector.elementAt(n);
            vector.setElementAt(vector.elementAt(n2), n);
            vector.setElementAt(e, n2);
            ++n;
            --n2;
        }
    }

    private static void sortRulesVector(Vector vector) {
        int n = vector.size();
        int n2 = 1;
        while (n2 < n) {
            Rule rule = (Rule)vector.elementAt(n2);
            int n3 = n2;
            while (n3 > 0) {
                Rule rule2 = (Rule)vector.elementAt(n3 - 1);
                if (!Rule.isBetter(rule, rule2)) break;
                vector.setElementAt(rule2, n3);
                --n3;
            }
            vector.setElementAt(rule, n3);
            ++n2;
        }
    }

    private static class Rule {
        final PathPattern pattern;
        final Importance ruleImportance;
        final Importance importImportance;
        final Priority priority;
        final Action action;

        Rule(PathPattern pathPattern, Importance importance, Importance importance2, Priority priority, Action action) {
            this.ruleImportance = importance;
            this.importImportance = importance2;
            this.priority = priority == null ? Priority.createDefault(pathPattern.getDefaultPriority()) : priority;
            this.pattern = pathPattern;
            this.action = action;
        }

        static boolean isBetter(Rule rule, Rule rule2) {
            int n = rule.ruleImportance.compareTo(rule2.ruleImportance);
            if (n == 0) {
                return rule.priority.compareTo(rule2.priority) > 0;
            }
            return n > 0;
        }
    }
}

