/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.aportisdoc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.openoffice.xmerge.converter.palm.Record;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocConstants;

final class DocEncoder
implements DocConstants {
    private StringBuffer textBuffer = new StringBuffer(4096);
    private int textLen = 0;
    private int textRecCount = 0;

    DocEncoder() {
    }

    void addText(String text) {
        this.textBuffer.append(text);
    }

    void addText(char[] text) {
        this.textBuffer.append(text);
    }

    void addText(char text) {
        this.textBuffer.append(text);
    }

    Record[] getRecords() throws IOException {
        byte[] textBytes = this.processTextBuffer();
        this.textLen = textBytes.length;
        this.textRecCount = (short)(textBytes.length / 4096);
        byte[] recBytes = new byte[4096];
        int pos = 0;
        ArrayList<Record> textRecords = new ArrayList<Record>(this.textRecCount + 1);
        int i = 0;
        while (i < this.textRecCount) {
            System.arraycopy(textBytes, pos, recBytes, 0, recBytes.length);
            pos += recBytes.length;
            Record zRec = new Record(recBytes);
            textRecords.add(zRec);
            ++i;
        }
        if (pos < this.textLen) {
            ++this.textRecCount;
            recBytes = new byte[this.textLen - pos];
            System.arraycopy(textBytes, pos, recBytes, 0, recBytes.length);
            Record rec = new Record(recBytes);
            textRecords.add(rec);
        }
        Record[] allRecords = new Record[textRecords.size() + 1];
        allRecords[0] = new Record(this.getHeaderBytes());
        int i2 = 1;
        while (i2 < allRecords.length) {
            allRecords[i2] = (Record)textRecords.get(i2 - 1);
            ++i2;
        }
        return allRecords;
    }

    private byte[] processTextBuffer() throws IOException {
        String str = this.textBuffer.toString();
        byte[] bytes = str.getBytes("8859_1");
        return bytes;
    }

    private byte[] getHeaderBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeShort(1);
        dos.writeShort(0);
        dos.writeInt(this.textLen);
        dos.writeShort(this.textRecCount);
        dos.writeShort(4096);
        dos.writeInt(0);
        byte[] bytes = bos.toByteArray();
        return bytes;
    }
}

