/*************************************************************************
 *
 *  $RCSfile: keycodes.hxx,v $
 *
 *  $Revision: 1.2.250.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:13:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_KEYCODES_HXX
#define _SV_KEYCODES_HXX

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif

// -----------------
// - KeyCode-Types -
// -----------------

// By changes you must also change: tools/vclrsc.hxx

// Key-Gruppen
#define KEYGROUP_NUM	((USHORT)0x0100)
#define KEYGROUP_ALPHA	((USHORT)0x0200)
#define KEYGROUP_FKEYS	((USHORT)0x0300)
#define KEYGROUP_CURSOR ((USHORT)0x0400)
#define KEYGROUP_MISC	((USHORT)0x0500)
#define KEYGROUP_TYPE	((USHORT)0x0F00)

// Key-Codes
#define KEY_0			((USHORT)(KEYGROUP_NUM+0))
#define KEY_1			((USHORT)(KEYGROUP_NUM+1))
#define KEY_2			((USHORT)(KEYGROUP_NUM+2))
#define KEY_3			((USHORT)(KEYGROUP_NUM+3))
#define KEY_4			((USHORT)(KEYGROUP_NUM+4))
#define KEY_5			((USHORT)(KEYGROUP_NUM+5))
#define KEY_6			((USHORT)(KEYGROUP_NUM+6))
#define KEY_7			((USHORT)(KEYGROUP_NUM+7))
#define KEY_8			((USHORT)(KEYGROUP_NUM+8))
#define KEY_9			((USHORT)(KEYGROUP_NUM+9))

#define KEY_A			((USHORT)(KEYGROUP_ALPHA+0))
#define KEY_B			((USHORT)(KEYGROUP_ALPHA+1))
#define KEY_C			((USHORT)(KEYGROUP_ALPHA+2))
#define KEY_D			((USHORT)(KEYGROUP_ALPHA+3))
#define KEY_E			((USHORT)(KEYGROUP_ALPHA+4))
#define KEY_F			((USHORT)(KEYGROUP_ALPHA+5))
#define KEY_G			((USHORT)(KEYGROUP_ALPHA+6))
#define KEY_H			((USHORT)(KEYGROUP_ALPHA+7))
#define KEY_I			((USHORT)(KEYGROUP_ALPHA+8))
#define KEY_J			((USHORT)(KEYGROUP_ALPHA+9))
#define KEY_K			((USHORT)(KEYGROUP_ALPHA+10))
#define KEY_L			((USHORT)(KEYGROUP_ALPHA+11))
#define KEY_M			((USHORT)(KEYGROUP_ALPHA+12))
#define KEY_N			((USHORT)(KEYGROUP_ALPHA+13))
#define KEY_O			((USHORT)(KEYGROUP_ALPHA+14))
#define KEY_P			((USHORT)(KEYGROUP_ALPHA+15))
#define KEY_Q			((USHORT)(KEYGROUP_ALPHA+16))
#define KEY_R			((USHORT)(KEYGROUP_ALPHA+17))
#define KEY_S			((USHORT)(KEYGROUP_ALPHA+18))
#define KEY_T			((USHORT)(KEYGROUP_ALPHA+19))
#define KEY_U			((USHORT)(KEYGROUP_ALPHA+20))
#define KEY_V			((USHORT)(KEYGROUP_ALPHA+21))
#define KEY_W			((USHORT)(KEYGROUP_ALPHA+22))
#define KEY_X			((USHORT)(KEYGROUP_ALPHA+23))
#define KEY_Y			((USHORT)(KEYGROUP_ALPHA+24))
#define KEY_Z			((USHORT)(KEYGROUP_ALPHA+25))

#define KEY_F1			((USHORT)(KEYGROUP_FKEYS+0))
#define KEY_F2			((USHORT)(KEYGROUP_FKEYS+1))
#define KEY_F3			((USHORT)(KEYGROUP_FKEYS+2))
#define KEY_F4			((USHORT)(KEYGROUP_FKEYS+3))
#define KEY_F5			((USHORT)(KEYGROUP_FKEYS+4))
#define KEY_F6			((USHORT)(KEYGROUP_FKEYS+5))
#define KEY_F7			((USHORT)(KEYGROUP_FKEYS+6))
#define KEY_F8			((USHORT)(KEYGROUP_FKEYS+7))
#define KEY_F9			((USHORT)(KEYGROUP_FKEYS+8))
#define KEY_F10 		((USHORT)(KEYGROUP_FKEYS+9))
#define KEY_F11 		((USHORT)(KEYGROUP_FKEYS+10))
#define KEY_F12 		((USHORT)(KEYGROUP_FKEYS+11))
#define KEY_F13 		((USHORT)(KEYGROUP_FKEYS+12))
#define KEY_F14 		((USHORT)(KEYGROUP_FKEYS+13))
#define KEY_F15 		((USHORT)(KEYGROUP_FKEYS+14))
#define KEY_F16 		((USHORT)(KEYGROUP_FKEYS+15))
#define KEY_F17 		((USHORT)(KEYGROUP_FKEYS+16))
#define KEY_F18 		((USHORT)(KEYGROUP_FKEYS+17))
#define KEY_F19 		((USHORT)(KEYGROUP_FKEYS+18))
#define KEY_F20 		((USHORT)(KEYGROUP_FKEYS+19))
#define KEY_F21 		((USHORT)(KEYGROUP_FKEYS+20))
#define KEY_F22 		((USHORT)(KEYGROUP_FKEYS+21))
#define KEY_F23 		((USHORT)(KEYGROUP_FKEYS+22))
#define KEY_F24 		((USHORT)(KEYGROUP_FKEYS+23))
#define KEY_F25 		((USHORT)(KEYGROUP_FKEYS+24))
#define KEY_F26 		((USHORT)(KEYGROUP_FKEYS+25))

#define KEY_DOWN		((USHORT)(KEYGROUP_CURSOR+0))
#define KEY_UP			((USHORT)(KEYGROUP_CURSOR+1))
#define KEY_LEFT		((USHORT)(KEYGROUP_CURSOR+2))
#define KEY_RIGHT		((USHORT)(KEYGROUP_CURSOR+3))
#define KEY_HOME		((USHORT)(KEYGROUP_CURSOR+4))
#define KEY_END 		((USHORT)(KEYGROUP_CURSOR+5))
#define KEY_PAGEUP		((USHORT)(KEYGROUP_CURSOR+6))
#define KEY_PAGEDOWN	((USHORT)(KEYGROUP_CURSOR+7))

#define KEY_RETURN		((USHORT)(KEYGROUP_MISC+0))
#define KEY_ESCAPE		((USHORT)(KEYGROUP_MISC+1))
#define KEY_TAB 		((USHORT)(KEYGROUP_MISC+2))
#define KEY_BACKSPACE	((USHORT)(KEYGROUP_MISC+3))
#define KEY_SPACE		((USHORT)(KEYGROUP_MISC+4))
#define KEY_INSERT		((USHORT)(KEYGROUP_MISC+5))
#define KEY_DELETE		((USHORT)(KEYGROUP_MISC+6))

#define KEY_ADD 		((USHORT)(KEYGROUP_MISC+7))
#define KEY_SUBTRACT	((USHORT)(KEYGROUP_MISC+8))
#define KEY_MULTIPLY	((USHORT)(KEYGROUP_MISC+9))
#define KEY_DIVIDE		((USHORT)(KEYGROUP_MISC+10))
#define KEY_POINT		((USHORT)(KEYGROUP_MISC+11))
#define KEY_COMMA		((USHORT)(KEYGROUP_MISC+12))
#define KEY_LESS		((USHORT)(KEYGROUP_MISC+13))
#define KEY_GREATER 	((USHORT)(KEYGROUP_MISC+14))
#define KEY_EQUAL		((USHORT)(KEYGROUP_MISC+15))

#define KEY_OPEN		((USHORT)(KEYGROUP_MISC+16))
#define KEY_CUT 		((USHORT)(KEYGROUP_MISC+17))
#define KEY_COPY		((USHORT)(KEYGROUP_MISC+18))
#define KEY_PASTE		((USHORT)(KEYGROUP_MISC+19))
#define KEY_UNDO		((USHORT)(KEYGROUP_MISC+20))
#define KEY_REPEAT		((USHORT)(KEYGROUP_MISC+21))
#define KEY_FIND		((USHORT)(KEYGROUP_MISC+22))
#define KEY_PROPERTIES	((USHORT)(KEYGROUP_MISC+23))
#define KEY_FRONT		((USHORT)(KEYGROUP_MISC+24))
#define KEY_CONTEXTMENU ((USHORT)(KEYGROUP_MISC+25))
#define KEY_MENU		((USHORT)(KEYGROUP_MISC+26))
#define KEY_HELP		((USHORT)(KEYGROUP_MISC+27))
#define KEY_HANGUL_HANJA ((USHORT)(KEYGROUP_MISC+28))

#define KEY_CODE		((USHORT)0x0FFF)

// Modifier-Tasten
#define KEY_SHIFT		((USHORT)0x1000)
#define KEY_MOD1		((USHORT)0x2000)
#define KEY_MOD2		((USHORT)0x4000)
#define KEY_MODTYPE 	((USHORT)0x7000)
#define KEY_CONTROLMOD	((USHORT)0x8000)
#define KEY_ALLMODTYPE	((USHORT)0xF000)

// extended Modifier-Keys (only used for modkey events)
#define MODKEY_LSHIFT    0x0001
#define MODKEY_RSHIFT    0x0002
#define MODKEY_LMOD1     0x0004
#define MODKEY_RMOD1     0x0008
#define MODKEY_LMOD2     0x0010
#define MODKEY_RMOD2     0x0020
#define MODKEY_SHIFT     (MODKEY_LSHIFT|MODKEY_RSHIFT)
#define MODKEY_MOD1      (MODKEY_LMOD1|MODKEY_RMOD1)
#define MODKEY_MOD2      (MODKEY_LMOD2|MODKEY_RMOD2)

// ---------------
// - Mouse-Types -
// ---------------

#define MOUSE_LEFT		((USHORT)0x0001)
#define MOUSE_MIDDLE	((USHORT)0x0002)
#define MOUSE_RIGHT 	((USHORT)0x0004)

#endif // _SV_KEYCODES_HXX
