/*************************************************************************
 *
 *  $RCSfile: iterbase.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/05/14 08:29:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef UDM_ITERBASE_HXX
#define UDM_ITERBASE_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <udm/object.hxx>
	// PARAMETERS

namespace udm
{


class iterator_ibase
{
  public:
    virtual             ~iterator_ibase() {}

    bool                operator==(
                            const iterator_ibase &
                                                i_rIter ) const;
    void                advance();
    Object              ref() const;
    DYN iterator_ibase &
                        create_copy() const;
  private:
    virtual void        do_Advance() = 0;

    virtual Object      inq_Ref() const= 0;
    virtual DYN iterator_ibase &
                        inq_CreateCopy() const = 0;
    virtual void *      inq_RealIterTargetAdress() const = 0;
};


/** This template function has to be specialised and implemented for
    all used iterators.
*/
template <class REAL_ITER>
DYN Data &          data_from_iterator(
                        const REAL_ITER &   i_rIter );


template <class REAL_ITER>
class iterator_impl : public iterator_ibase
{
  public:
                        iterator_impl(
                            REAL_ITER           i_rSrc );
    virtual             ~iterator_impl();

  private:
    virtual void        do_Advance();
    virtual Object      inq_Ref() const;
    virtual DYN iterator_ibase &
                        inq_CreateCopy() const;
    virtual void *      inq_RealIterTargetAdress() const;

    // DATA
    REAL_ITER           itSrc;
};



// IMPLEMENTATION

template <class REAL_ITER>
iterator_impl<REAL_ITER>::iterator_impl(REAL_ITER i_rSrc)
    :   iterator_impl<REAL_ITER>(i_rSrc)
    { }

template <class REAL_ITER>
iterator_impl<REAL_ITER>::~iterator_impl()
    { }


template <class REAL_ITER>
void
iterator_impl<REAL_ITER>::do_Advance()
    { ++itSrc; }

template <class REAL_ITER>
Object
iterator_impl<REAL_ITER>::inq_Ref() const
    { return Object( data_from_iterator(itSrc) ); }  

template <class REAL_ITER>
DYN iterator_ibase &
iterator_impl<REAL_ITER>::inq_CreateCopy() const
{
    return * new iterator_impl<REAL_ITER>(itSrc);
}

template <class REAL_ITER>
void *
iterator_impl<REAL_ITER>::inq_RealIterTargetAdress() const
{
 	return static_cast< void* >(&(*itSrc));
}


inline bool
iterator_ibase::operator==(const iterator_ibase & i_rIter) const
    { return inq_RealIterTargetAdress() == i_rIter.inq_RealIterTargetAdress(); }

inline void
iterator_ibase::advance()
    { do_Advance(); }

inline Object
iterator_ibase::ref() const
    { return inq_Ref(); }

inline DYN iterator_ibase &
iterator_ibase::create_copy() const
    { return inq_CreateCopy(); }



}   // namespace udm




#endif

