/*************************************************************************
 *
 *  $RCSfile: lightdlg.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:00:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVX_LIGHT3D_HXX_
#define _SVX_LIGHT3D_HXX_

#include <svx/dlgctl3d.hxx>

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif

#ifndef _SFXTABDLG_HXX //autogen
#include <sfx2/tabdlg.hxx>
#endif

#ifndef _BASEDLGS_HXX //autogen
#include <sfx2/basedlgs.hxx>
#endif

#ifndef _FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif

#ifndef _SVX_DLG_CTRL_HXX //autogen
#include <svx/dlgctrl.hxx>
#endif

class Vector3D;

/*************************************************************************
|*
|* Dialog
|*
\************************************************************************/
/*
class SvxLight3DDlg : public ModalDialog
{
private:
	SvxRectCtl3D	aCtlLight;
	FixedText		aFtIntensity;
	MetricField		aMtrFldIntensity;
	OKButton		aBtnOK;
	CancelButton	aBtnCancel;
	HelpButton		aBtnHelp;

public:
	SvxLight3DDlg(Window* pWindow);
	virtual		~SvxLight3DDlg();

	Vector3D	GetVector();
	void		SetLight( Vector3D aVect );
	double  	GetIntensity();
	void		SetIntensity( double fIntens );
};
*/
/*************************************************************************
|*
|* 3D-Tab-Dialog
|*
\************************************************************************/

class Svx3DTabDialog : public SfxTabDialog
{
private:
	const SfxItemSet&	rOutAttrs;

public:
			Svx3DTabDialog( Window* pParent, const SfxItemSet* pAttr );
			~Svx3DTabDialog();
};

/*************************************************************************
|*
|* 3D-SingleTab-Dialog
|*
\************************************************************************/
class Svx3DSingleTabDialog : public SfxSingleTabDialog
{
private:
	const SfxItemSet&	rOutAttrs;

public:
		Svx3DSingleTabDialog( Window* pParent, const SfxItemSet* pAttr );
		~Svx3DSingleTabDialog();
};

/*************************************************************************
|*
|* Light-Tab-Page
|*
\************************************************************************/
class SvxLight3DTabPage : public SfxTabPage
{
private:
	SvxRectCtl3D		aCtlLight;
	FixedText			aFtLightIntensity;
	MetricField			aMtrFldLightIntensity;
	FixedText			aFtLightColor;
	ColorLB  			aLbLightColor;
	GroupBox			aGrpLight;
	FixedText			aFtIntensity;
	MetricField			aMtrFldIntensity;
	FixedText			aFtColor;
	ColorLB  			aLbColor;
	GroupBox			aGrpAmbient;
	const SfxItemSet&	rOutAttrs;

public:
		 SvxLight3DTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	static SfxTabPage* Create( Window*, const SfxItemSet& );
	static USHORT*	   GetRanges();

	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );
};

#endif // _SVX_LIGHT3D_HXX_

