/*************************************************************************
 *
 *  $RCSfile: intitem.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 14:36:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXINTITEM_HXX
#define _SFXINTITEM_HXX

#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif

class SfxArguments;

//============================================================================
class SfxByteItem: public CntByteItem
{
public:
	TYPEINFO();

	SfxByteItem(USHORT nWhich = 0, BYTE nValue = 0):
		CntByteItem(nWhich, nValue) {}

	SfxByteItem(USHORT nWhich, SvStream & rStream):
		CntByteItem(nWhich, rStream) {}

	virtual SfxPoolItem * Create(SvStream & rStream, USHORT) const;

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const
	{ return new SfxByteItem(*this); }
};

//============================================================================
DBG_NAMEEX(SfxInt16Item);

class SfxInt16Item: public SfxPoolItem
{
	INT16 m_nValue;

public:
	TYPEINFO();

	SfxInt16Item(USHORT nWhich = 0, INT16 nTheValue = 0):
		SfxPoolItem(nWhich), m_nValue(nTheValue)
	{ DBG_CTOR(SfxInt16Item, 0); }

	SfxInt16Item(USHORT nWhich, SvStream & rStream);

	SfxInt16Item(const SfxInt16Item & rItem):
		SfxPoolItem(rItem), m_nValue(rItem.m_nValue)
	{ DBG_CTOR(SfxInt16Item, 0); }

	virtual ~SfxInt16Item() { DBG_DTOR(SfxInt16Item, 0); }

	virtual int operator ==(const SfxPoolItem & rItem) const;

	virtual int Compare(const SfxPoolItem & rWith) const;

	virtual SfxItemPresentation GetPresentation(SfxItemPresentation,
												SfxMapUnit, SfxMapUnit,
												XubString & rText,
                                                const IntlWrapper * = 0)
		const;

	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;

	virtual	BOOL PutValue( const com::sun::star::uno::Any& rVal,
						   BYTE nMemberId = 0 );

	virtual SfxPoolItem * Create(SvStream & rStream, USHORT) const;

	virtual SvStream & Store(SvStream & rStream, USHORT) const;

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;

	virtual INT16 GetMin() const;

	virtual INT16 GetMax() const;

	virtual SfxFieldUnit GetUnit() const;

	INT16 GetValue() const { return m_nValue; }

	inline void SetValue(INT16 nTheValue);
};

inline void SfxInt16Item::SetValue(INT16 nTheValue)
{
	DBG_ASSERT(GetRefCount() == 0, "SfxInt16Item::SetValue(); Pooled item");
	m_nValue = nTheValue;
}

//============================================================================
class SfxUInt16Item: public CntUInt16Item
{
public:
	TYPEINFO();

	SfxUInt16Item(USHORT nWhich = 0, UINT16 nValue = 0):
		CntUInt16Item(nWhich, nValue) {}

	SfxUInt16Item(USHORT nWhich, SvStream & rStream):
		CntUInt16Item(nWhich, rStream) {}

	virtual SfxPoolItem * Create(SvStream & rStream, USHORT) const
	{ return new SfxUInt16Item(Which(), rStream); }

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const
	{ return new SfxUInt16Item(*this); }
};

//============================================================================
class SfxInt32Item: public CntInt32Item
{
public:
	TYPEINFO();

	SfxInt32Item(USHORT nWhich = 0, INT32 nValue = 0):
		CntInt32Item(nWhich, nValue) {}

	SfxInt32Item(USHORT nWhich, SvStream & rStream):
		CntInt32Item(nWhich, rStream) {}

	virtual SfxPoolItem * Create(SvStream & rStream, USHORT) const
	{ return new SfxInt32Item(Which(), rStream); }

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const
	{ return new SfxInt32Item(*this); }

};

//============================================================================
class SfxUInt32Item: public CntUInt32Item
{
public:
	TYPEINFO();

	SfxUInt32Item(USHORT nWhich = 0, UINT32 nValue = 0):
		CntUInt32Item(nWhich, nValue) {}

	SfxUInt32Item(USHORT nWhich, SvStream & rStream):
		CntUInt32Item(nWhich, rStream) {}

	virtual SfxPoolItem * Create(SvStream & rStream, USHORT) const
	{ return new SfxUInt32Item(Which(), rStream); }

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const
	{ return new SfxUInt32Item(*this); }
};

#endif // _SFXINTITEM_HXX

