/*************************************************************************
 *
 *  $RCSfile: basedlgs.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: mba $ $Date: 2001/12/20 11:20:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _BASEDLGS_HXX
#define _BASEDLGS_HXX

// include ---------------------------------------------------------------

#ifndef _FLOATWIN_HXX //autogen
#include <vcl/floatwin.hxx>
#endif
#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif

class SfxTabPage;
class SfxViewFrame;
class SfxBindings;
class SfxChildWindow;
struct SfxChildWinInfo;
class SfxItemSet;
class SfxItemPool;
class OKButton;
class CancelButton;
class HelpButton;
class Button;

// class SfxModalDefParentHelper -----------------------------------------

class SfxModalDefParentHelper
{
private:
	Window *pOld;

public:
	SfxModalDefParentHelper(Window* pWindow);
	~SfxModalDefParentHelper();
};

// class SfxModalDialog --------------------------------------------------

class SfxModalDialog: public ModalDialog
{
	SfxViewFrame*		pFrame;
	USHORT				nUniqId;
	String              aExtraData;
	Timer				aTimer;

#if 0 // _SOLAR__PRIVATE
	DECL_LINK(			TimerHdl_Impl, Timer* );
#endif

protected:
	SfxModalDialog(SfxViewFrame *pViewFrame, Window *pParent, const ResId &);
	SfxModalDialog(SfxViewFrame *pViewFrame, Window* pParent,
				   USHORT nUniqueId, WinBits nWinStyle = WB_STDMODAL);
	SfxModalDialog(Window *pParent, const ResId &);
	SfxModalDialog(Window* pParent, USHORT nUniqueId,
				   WinBits nWinStyle = WB_STDMODAL);
	~SfxModalDialog();

	String& 	GetExtraData()		{ return aExtraData; }
	USHORT		GetUniqId() const	{ return nUniqId; }
};

// class SfxModelessDialog --------------------------------------------------
class SfxModelessDialog_Impl;
class SfxModelessDialog: public ModelessDialog
{
	SfxBindings*			pBindings;
	Size					aSize;
    SfxModelessDialog_Impl* pImp;

protected:
							SfxModelessDialog( SfxBindings*, SfxChildWindow*,
								Window*, const ResId& );
							SfxModelessDialog( SfxBindings*, SfxChildWindow*,
								Window*, WinBits nWinStyle = WB_STDMODELESS );
							~SfxModelessDialog();
	virtual BOOL			Close();
	virtual void			Resize();
    virtual void            Move();
    virtual void            StateChanged( StateChangedType nStateChange );

public:
	virtual void        	FillInfo(SfxChildWinInfo&) const;
	void					Initialize (SfxChildWinInfo* pInfo);
	virtual long			Notify( NotifyEvent& rNEvt );
    SfxBindings&            GetBindings()
                            { return *pBindings; }
};

// class SfxFloatingWindow --------------------------------------------------
class SfxFloatingWindow_Impl;
class SfxFloatingWindow: public FloatingWindow
{
	SfxBindings*			pBindings;
	Size					aSize;
    SfxFloatingWindow_Impl* pImp;

protected:
							SfxFloatingWindow( SfxBindings *pBindings,
											  SfxChildWindow *pCW,
											  Window* pParent,
											  WinBits nWinBits=WB_STDMODELESS);
							SfxFloatingWindow( SfxBindings *pBindings,
											  SfxChildWindow *pCW,
											  Window* pParent,
											  const ResId& rResId);
							~SfxFloatingWindow();

    virtual void            StateChanged( StateChangedType nStateChange );
	virtual BOOL			Close();
	virtual void			Resize();
    virtual void            Move();
	virtual long			Notify( NotifyEvent& rNEvt );
    SfxBindings&            GetBindings()
                            { return *pBindings; }

public:
	virtual void        	FillInfo(SfxChildWinInfo&) const;
	void					Initialize (SfxChildWinInfo* pInfo);
};

// class SfxSingleTabDialog --------------------------------------------------

typedef USHORT*	(*GetTabPageRanges)(); // liefert internationale Which-Werte

class SfxSingleTabDialog : public SfxModalDialog
{
public:
#if SUPD < 637
	SfxSingleTabDialog( SfxViewFrame* pViewFrame, Window* pParent,
						const SfxItemSet& rOptionsSet, USHORT nUniqueId,
						BOOL bGroupBox = FALSE );
	SfxSingleTabDialog( Window* pParent, const SfxItemSet& rOptionsSet,
						USHORT nUniqueId, BOOL bGroupBox = FALSE );
	SfxSingleTabDialog( SfxViewFrame* pViewFrame, Window* pParent,
						USHORT nUniqueId,	const SfxItemSet* pInSet = 0,
						BOOL bGroupBox = FALSE );
	SfxSingleTabDialog( Window* pParent, USHORT nUniqueId,
						const SfxItemSet* pInSet = 0,
						BOOL bGroupBox = FALSE );
#else
	SfxSingleTabDialog( SfxViewFrame* pViewFrame, Window* pParent,
						const SfxItemSet& rOptionsSet, USHORT nUniqueId );
	SfxSingleTabDialog( Window* pParent, const SfxItemSet& rOptionsSet, USHORT nUniqueId );
	SfxSingleTabDialog( SfxViewFrame* pViewFrame, Window* pParent,
						USHORT nUniqueId,	const SfxItemSet* pInSet = 0 );
	SfxSingleTabDialog( Window* pParent, USHORT nUniqueId, const SfxItemSet* pInSet = 0 );
#endif
	virtual             ~SfxSingleTabDialog();

	void				SetTabPage( SfxTabPage* pTabPage,
									GetTabPageRanges pRangesFunc = 0 );
	SfxTabPage*			GetTabPage() const { return pPage; }

		// liefert ggf. per Map konvertierte lokale Slots
	const USHORT*		GetInputRanges( const SfxItemPool& rPool );
	void				SetInputSet( const SfxItemSet* pInSet )
							{ pOptions = pInSet; }
	const SfxItemSet*	GetOutputItemSet() const { return pOutSet; }
	OKButton*			GetOKButton() const { return pOKBtn; }
	CancelButton*		GetCancelButton() const { return pCancelBtn; }

private:
	SfxViewFrame*       pFrame;
	GetTabPageRanges	fnGetRanges;	// Pointer auf die Ranges-Funktion
	USHORT*				pRanges;

	OKButton*			pOKBtn;
	CancelButton*		pCancelBtn;
	HelpButton*			pHelpBtn;
#if SUPD < 637
	void*				pDummy;
#endif

	SfxTabPage*			pPage;
	const SfxItemSet*	pOptions;
	SfxItemSet*			pOutSet;
#if SUPD < 637
	BOOL				bGrpBox;
#endif

#if 0 // _SOLAR__PRIVATE
	DECL_LINK( OKHdl_Impl, Button * );
#endif
};

#endif

