/*************************************************************************
 *
 *  $RCSfile: TypeDescriptionManager.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.comp.typedescriptionmanager;

import com.sun.star.uno.*;
import com.sun.star.uno.RuntimeException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.reflection.XTypeDescription;
import com.sun.star.reflection.XInterfaceTypeDescription;
import com.sun.star.reflection.XInterfaceMemberTypeDescription;
import com.sun.star.reflection.XMethodParameter;

import java.util.Hashtable;


//==================================================================================================
class XInterfaceTD implements XInterfaceTypeDescription
{
	private static Uik s_uik = new Uik( 0xe227a391, (short)0x33d6, (short)0x11d1, 0xaabe00a0, 0x249d5590 );
	private XInterfaceMemberTypeDescription[] _members;

	//______________________________________________________________________________________________
	public XInterfaceTD( XHierarchicalNameAccess xAccess )
		throws NoSuchElementException
	{
		XTypeDescription xVoidTD = (XTypeDescription)xAccess.getByHierarchicalName( "void" );
		XTypeDescription[] rt = new XTypeDescription[] {
			(XTypeDescription)xAccess.getByHierarchicalName( "com.sun.star.uno.RuntimeException" ) };
		
		_members = new XInterfaceMemberTypeDescription[3];

		XMethodParameter[] params = new XMethodParameter[] {
			new MethodParameter(
				"uik", (XTypeDescription)xAccess.getByHierarchicalName( "com.sun.star.uno.Uik" ),
				0, true, false ),
			new MethodParameter(
				"ifc", (XTypeDescription)xAccess.getByHierarchicalName( "any" ),
				1, false, true ) };
		
		_members[0] = new MethodTypeDescription(
			"com.sun.star.uno.XInterface::queryInterface", "queryInterface",
			(XTypeDescription)xAccess.getByHierarchicalName( "boolean" ), 0, false, params, rt );
		_members[1] = new MethodTypeDescription(
			"com.sun.star.uno.XInterface::acquire", "acquire", xVoidTD, 1, true, null, rt );
		_members[2] = new MethodTypeDescription(
			"com.sun.star.uno.XInterface::release", "release", xVoidTD, 2, true, null, rt );
	}
	
	// XTypeDescription
	//______________________________________________________________________________________________
    public TypeClass getTypeClass()
		throws RuntimeException
	{
		return TypeClass.INTERFACE;
	}
	//______________________________________________________________________________________________
    public String getName()
		throws RuntimeException
	{
		return "com.sun.star.uno.XInterface";
	}
	// XInterfaceTypeDescription
	//______________________________________________________________________________________________
    public XTypeDescription getBaseType()
		throws RuntimeException
	{
		return null;
	}
	//______________________________________________________________________________________________
    public Uik getUik()
		throws RuntimeException
	{
		return s_uik;
	}
	//______________________________________________________________________________________________
    public XInterfaceMemberTypeDescription[] getMembers()
		throws RuntimeException
	{
		return _members;
	}
}

//==================================================================================================
public class TypeDescriptionManager implements XHierarchicalNameAccess
{
	private static XTypeDescription _xXInterfaceTD = null;
	private static XTypeDescription	_xLongTD = new TypeDescription( "long", TypeClass.LONG );
	private static XTypeDescription	_xULongTD = new TypeDescription( "unsigned long", TypeClass.UNSIGNED_LONG );
	private static XTypeDescription	_xHyperTD = new TypeDescription( "hyper", TypeClass.HYPER );
	private static XTypeDescription	_xUHyperTD = new TypeDescription( "unsigned hyper", TypeClass.UNSIGNED_HYPER );
	private static Hashtable		_standardTypes = new Hashtable( 17 );
	
	private Hashtable/*WeakTable*/	_map = new Hashtable/*WeakTable*/( 64 );
	
	//______________________________________________________________________________________________
	static
	{
		// uno standard types
		_standardTypes.put( "void", new TypeDescription( "void", TypeClass.VOID ) );
		_standardTypes.put( "char", new TypeDescription( "char", TypeClass.CHAR ) );
		_standardTypes.put( "boolean", new TypeDescription( "boolean", TypeClass.BOOLEAN ) );
		_standardTypes.put( "byte", new TypeDescription( "byte", TypeClass.BYTE ) );
		_standardTypes.put( "short", new TypeDescription( "short", TypeClass.SHORT ) );
		_standardTypes.put( "unsigned short", new TypeDescription( "unsigned short", TypeClass.UNSIGNED_SHORT ) );
		_standardTypes.put( "long", _xLongTD );
		_standardTypes.put( "unsigned long", _xULongTD );
		_standardTypes.put( "hyper", _xHyperTD );
		_standardTypes.put( "unsigned hyper", _xUHyperTD );
		_standardTypes.put( "float", new TypeDescription( "float", TypeClass.FLOAT ) );
		_standardTypes.put( "double", new TypeDescription( "double", TypeClass.DOUBLE ) );
		TypeDescription stringType = new TypeDescription( "string", TypeClass.STRING );
		_standardTypes.put( "string", stringType );
		_standardTypes.put( "java.lang.String", stringType );
		_standardTypes.put( "type", new TypeDescription( "type", TypeClass.TYPE ) );
		TypeDescription anyType = new TypeDescription( "any", TypeClass.ANY );
		_standardTypes.put( "java.lang.Object", anyType );
		_standardTypes.put( "any", anyType );
	}
	
	//______________________________________________________________________________________________
	private XTypeDescription getXInterface()
		throws NoSuchElementException
	{
		if (_xXInterfaceTD == null)
			_xXInterfaceTD = new XInterfaceTD( this );
		return _xXInterfaceTD;
	}
	
	//______________________________________________________________________________________________
	public TypeDescriptionManager()
	{
	}
	
	//______________________________________________________________________________________________
	Object getByClass( Class c, boolean bUnsigned, boolean bInterface )
		throws NoSuchElementException, RuntimeException
	{
		try
		{
			if (c != null)
			{
				Object ret;
				String name = c.getName();
				
				if (name.equals( "int" ))
					ret = (bUnsigned ? _xULongTD : _xLongTD);
				else if (name.equals( "long" ))
					ret = (bUnsigned ? _xUHyperTD : _xHyperTD);
				else
				{
					if (bUnsigned)
						name = "unsigned " + name;
					else if (c.isArray())
					{
						StringBuffer nameBuf = new StringBuffer( "[]" );
						Class elem = c.getComponentType();
						while (elem.isArray())
						{
							nameBuf.append( "[]" );
							elem = elem.getComponentType();
						}
						name = nameBuf.append( elem.getName() ).toString();
					}
					
					if ((ret = _map.get( name/*, XTypeDescription.class*/ )) == null)
					{
						if (bInterface && name.equals( "java.lang.Object" ))
						{
							ret = getXInterface();
						}
						else if ((ret = _standardTypes.get( name )) == null)
						{
							if (c.isInterface() && XInterface.class.isAssignableFrom( c ))
								ret = new InterfaceTypeDescription( this, c );
							else if (c.isArray())
								ret = new SequenceTypeDescription( (XTypeDescription)getByClass( c.getComponentType(), bUnsigned, bInterface ) );
							else if (Enum.class.isAssignableFrom( c ))
								ret = new EnumTypeDescription( c );
//  							else if (com.sun.star.uno.Union.class.isAssignableFrom( c ))
//  								ret = new UnionTypeDescription( c );
							else if (java.lang.Exception.class.isAssignableFrom( c ))
								ret = new CompoundTypeDescription( this, c, TypeClass.EXCEPTION );
							else
								ret = new CompoundTypeDescription( this, c, TypeClass.STRUCT );
						}
						_map.put( ((XTypeDescription)ret).getName(), ret/*, XTypeDescription.class*/ );
					}
				}
				return ret;
			}
		}
		catch (ClassCastException exc)
		{
		}
//  		catch (IllegalAccessException exc)
//  		{
//  		}
//  		catch (InstantiationException exc)
//  		{
//  		}
		throw new NoSuchElementException( (c == null ? "unknown class" : c.getName()), null );
	}
	// XHierarchicalNameAccess
	//______________________________________________________________________________________________
	public Object getByHierarchicalName( String name )
		throws NoSuchElementException, RuntimeException
	{
		try
		{
			if (name != null)
			{
				Object ret = (XTypeDescription)_map.get( name/*, XTypeDescription.class*/ );
				if (ret == null)
				{
					ret = _standardTypes.get( name );
					if (ret == null)
					{
						if (name.indexOf( "[]" ) == 0)
						{
							ret = new SequenceTypeDescription(
								(XTypeDescription)getByHierarchicalName( name.substring( 2 ) ) );
						}
						else
						{
							// entry will be written to map by getByClass()
							return getByClass( Class.forName( name ), false, false );
						}
					}
					_map.put( name, ret/*, XTypeDescription.class*/ );
				}
				return ret;
			}
		}
		catch (ClassNotFoundException exc)
		{
		}
		catch (ClassCastException exc)
		{
		}
//  		catch (IllegalAccessException exc)
//  		{
//  		}
//  		catch (InstantiationException exc)
//  		{
//  		}
		throw new NoSuchElementException( (name == null ? "unknown type name" : name), null );
	}
	//______________________________________________________________________________________________
    public boolean hasByHierarchicalName( String name )
		throws RuntimeException
	{
		try
		{
			return (getByHierarchicalName( name ) != null);
		}
		catch (NoSuchElementException exc)
		{
		}
		return false;
	}
}

