/*
 * Decompiled with CFR 0.152.
 */
package org.openide.debugger;

import java.beans.PropertyChangeListener;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.Watch;
import org.openide.src.ConstructorElement;
import org.openide.text.Line;

public abstract class Debugger {
    public static final int DEBUGGER_NOT_RUNNING = 1;
    public static final int DEBUGGER_STARTING = 2;
    public static final int DEBUGGER_RUNNING = 3;
    public static final int DEBUGGER_STOPPED = 4;
    public static final String PROP_STATE = "state";
    public static final String PROP_BREAKPOINTS = "breakpoints";
    public static final String PROP_WATCHES = "watches";
    public static final String PROP_CURRENT_LINE = "currentLine";
    public static final int ACTION_BREAKPOINT_HIT = 1;
    public static final int ACTION_TRACE_OVER = 2;
    public static final int ACTION_TRACE_INTO = 3;
    public static final int ACTION_STEP_OUT = 4;

    public abstract void startDebugger(DebuggerInfo var1) throws DebuggerException;

    public abstract void finishDebugger() throws DebuggerException;

    public abstract void traceInto() throws DebuggerException;

    public abstract void traceOver() throws DebuggerException;

    public abstract void go() throws DebuggerException;

    public abstract void stepOut() throws DebuggerException;

    public abstract Breakpoint createBreakpoint(Line var1);

    public abstract Breakpoint createBreakpoint(Line var1, boolean var2);

    public abstract Breakpoint findBreakpoint(Line var1);

    public abstract Breakpoint createBreakpoint(ConstructorElement var1);

    public abstract Breakpoint createBreakpoint(ConstructorElement var1, boolean var2);

    public abstract Breakpoint findBreakpoint(ConstructorElement var1);

    public abstract Breakpoint[] getBreakpoints();

    public abstract void removeAllBreakpoints();

    public abstract Watch createWatch();

    public abstract Watch createWatch(String var1, boolean var2);

    public abstract Watch[] getWatches();

    public abstract void removeAllWatches();

    public abstract int getState();

    public abstract Line getCurrentLine();

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);
}

