/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.java;

import com.sun.star.lib.sandbox.Disposable;
import com.sun.star.lib.uno.Proxy;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public final class java_environment
implements IEnvironment,
Disposable {
    private static final Registry localObjects = new Registry();
    private final Object context;
    private final Registry proxies = new Registry();

    public java_environment(Object object) {
        this.context = object;
    }

    public Object getContext() {
        return this.context;
    }

    public String getName() {
        return "java";
    }

    public Object registerInterface(Object object, String[] stringArray, Type type) {
        if (stringArray[0] == null) {
            stringArray[0] = UnoRuntime.generateOid(object);
        }
        return (this.isProxy(object) ? this.proxies : localObjects).register(object, this.createKey(stringArray[0], type));
    }

    public void revokeInterface(String string, Type type) {
        String string2 = this.createKey(string, type);
        if (!this.proxies.revoke(string2)) {
            localObjects.revoke(string2);
        }
    }

    public Object getRegisteredInterface(String string, Type type) {
        String string2 = this.createKey(string, type);
        Object object = this.proxies.get(string2);
        if (object == null) {
            object = localObjects.get(string2);
        }
        return object;
    }

    public String getRegisteredObjectIdentifier(Object object) {
        return UnoRuntime.generateOid(object);
    }

    public void list() {
    }

    public void dispose() {
    }

    public void revokeAllProxies() {
        this.proxies.clear();
    }

    public boolean equals(Object object) {
        return false;
    }

    private String createKey(String string, Type type) {
        return string.concat(type.getTypeName());
    }

    private boolean isProxy(Object object) {
        return object instanceof Proxy;
    }

    private static final class Registry {
        private final HashMap map = new HashMap();
        private final ReferenceQueue queue = new ReferenceQueue();

        private Registry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object register(Object object, String string) {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                Object t;
                this.cleanUp();
                Entry entry = (Entry)this.map.get(string);
                if (entry != null && (t = entry.get()) != null) {
                    entry.acquire();
                    return t;
                }
                this.map.put(string, new Entry(string, object, this.queue));
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean revoke(String string) {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                Entry entry = (Entry)this.map.get(string);
                if (entry != null && entry.release()) {
                    this.map.remove(string);
                }
                this.cleanUp();
                return entry != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(String string) {
            Entry entry;
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                entry = (Entry)this.map.get(string);
            }
            return entry == null ? null : entry.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.map.clear();
                this.cleanUp();
            }
        }

        private void cleanUp() {
            Entry entry;
            while ((entry = (Entry)this.queue.poll()) != null) {
                String string = entry.getKey();
                if (this.map.get(string) != entry) continue;
                this.map.remove(string);
            }
        }

        private static final class Entry
        extends WeakReference {
            private final String key;
            private int count = 1;

            public Entry(String string, Object object, ReferenceQueue referenceQueue) {
                super(object, referenceQueue);
                this.key = string;
            }

            public void acquire() {
                ++this.count;
            }

            public boolean release() {
                return --this.count == 0;
            }

            public String getKey() {
                return this.key;
            }
        }
    }
}

