<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: table.xsl,v $

   $Revision: 1.3 $

   last change: $Author: rt $ $Date: 2004/07/05 09:10:50 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
    For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:office="http://openoffice.org/2000/office"
                xmlns:style="http://openoffice.org/2000/style"
                xmlns:text="http://openoffice.org/2000/text"
                xmlns:table="http://openoffice.org/2000/table"
                xmlns:draw="http://openoffice.org/2000/drawing"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:number="http://openoffice.org/2000/datastyle"
                xmlns:svg="http://www.w3.org/2000/svg"
                xmlns:chart="http://openoffice.org/2000/chart"
                xmlns:dr3d="http://openoffice.org/2000/dr3d"
                xmlns:math="http://www.w3.org/1998/Math/MathML"
                xmlns:form="http://openoffice.org/2000/form"
                xmlns:script="http://openoffice.org/2000/script"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:meta="http://openoffice.org/2000/meta"
                xmlns:config="http://openoffice.org/2001/config"
                xmlns:help="http://openoffice.org/2000/help"
                exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help"
                xmlns="http://www.w3.org/1999/xhtml">



    <!-- current node is a table:table or table:sub-table -->
    <xsl:template name="create-table-children">
        <xsl:param name="globalData" />
        <xsl:param name="allVisibleTableRows" />
        <xsl:param name="allTableColumns" />

        <xsl:element name="colgroup">
            <xsl:for-each select="$allTableColumns/table:table-column">
                <xsl:if test="not(@table:visibility = 'collapse' or @table:visibility = 'filter')">
                    <xsl:element name="col">
                        <xsl:variable name="value" select="$globalData/all-ooo-styles/style[@style:name = current()/@table:style-name]/style:properties/@style:column-width" />
                        <xsl:if test="$value">
                            <xsl:attribute name="width">
                                <!-- using the absolute width, problems with the relative in browser (in OOo style:rel-column-width) -->
                                <xsl:call-template name="convert2px">
                                    <xsl:with-param name="value" select="$globalData/all-ooo-styles/style[@style:name = current()/@table:style-name]/style:properties/@style:column-width" />
                                </xsl:call-template>
                            </xsl:attribute>
                        </xsl:if>
                    </xsl:element>
                    <!-- *** the column-style ***
                    <xsl:attribute name="width">
                        <xsl:variable name="currentColumnStyleName" select="$allTableColumns/table:table-column[position() = $columnPosition]/@table:style-name" />
                        <xsl:value-of select="$globalData/all-ooo-styles/style[@style:name = $currentColumnStyleName]/style:properties/@style:column-width" />
                    </xsl:attribute>-->
                </xsl:if>
            </xsl:for-each>
        </xsl:element>

        <xsl:call-template name="create-table-rows">
            <xsl:with-param name="globalData"           select="$globalData" />
            <xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
            <xsl:with-param name="allTableColumns"      select="$allTableColumns" />
        </xsl:call-template>
    </xsl:template>



    <!-- Creating the content of a table content using CSS styles -->
    <xsl:template name="create-table-cell-content">
        <xsl:param name="tableDataType" />
        <xsl:param name="globalData" />
        <xsl:param name="allTableColumns" />
        <xsl:param name="columnPosition" />
        <xsl:param name="currentTableColumn" />

        <xsl:element name="{$tableDataType}">
            <xsl:if test="$debugEnabled">
                <xsl:message>A table cell '<xsl:value-of select="$tableDataType" />' element has been added!</xsl:message>
            </xsl:if>

            <!-- if parser reads DTD the default is set to '1' -->
            <xsl:if test="@table:number-columns-spanned and @table:number-columns-spanned > 1">
                <xsl:attribute name="colspan">
                    <xsl:value-of select="@table:number-columns-spanned" />
                </xsl:attribute>
            </xsl:if>
            <!-- if parser reads DTD the default is set to '1' -->
            <xsl:if test="@table:number-rows-spanned and @table:number-rows-spanned > 1">
                <xsl:attribute name="rowspan">
                    <xsl:value-of select="@table:number-rows-spanned" />
                </xsl:attribute>
            </xsl:if>


            <!-- *** the cell-style *** -->
            <!-- The cell style has no conclusion with the column style, so we switch the order/priorities due to browser issues

                The cell-style depends on two attributes:

                1) table:style-name - the style properties of cell. When they exist, a default alignement (cp. below) will be added for the
                                      case of no alignment in the style exist.

                2) table:value-type - the value type of the table-cell giving the default alignments.
                                      By default a string value is left aligned, all other are aligned:right.
            -->
            <xsl:choose>
                <xsl:when test="@table:style-name">
                    <xsl:call-template name="set-styles">
                        <xsl:with-param name="globalData" select="$globalData" />
                        <xsl:with-param name="styleName" select="@table:style-name" />
                        <xsl:with-param name="currentTableColumn" select="$currentTableColumn" />
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <!-- Cells without a style use the 'table:default-cell-style-name'
                         when there is no default cell style specified for the current column. -->
                    <xsl:variable name="defaultCellStyleName" select="$currentTableColumn/@table:default-cell-style-name" />
                    <xsl:choose>
                        <xsl:when test="$defaultCellStyleName">
                            <xsl:call-template name="set-styles">
                                <xsl:with-param name="globalData" select="$globalData" />
                                <xsl:with-param name="styleName" select="$defaultCellStyleName" />
                                <xsl:with-param name="currentTableColumn" select="$currentTableColumn" />
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- No cell style exists, nor a default table cell style for the column -->
                            <xsl:attribute name="style">
                                <!-- sets cell alignment dependent of cell value type -->
                                <xsl:call-template name="set-cell-alignment" />
                            </xsl:attribute>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>

            <xsl:apply-templates>
                <xsl:with-param name="globalData" select="$globalData" />
            </xsl:apply-templates>

        </xsl:element>
    </xsl:template>


    <!-- Sets the cell alignment by the 'table:value-type' of the 'table:table-cell'.
         Strings have a left alignment, other values right -->
    <xsl:template name="set-cell-alignment">
        <xsl:choose>
            <xsl:when test="@table:value-type and not(@table:value-type = 'string')">text-align:right; </xsl:when>
            <xsl:otherwise>text-align:left;</xsl:otherwise>
        </xsl:choose>
    </xsl:template>



    <!-- Sets styles of a cell -->
    <xsl:template name="set-styles">
        <xsl:param name="globalData" />
        <xsl:param name="styleName" />
        <xsl:param name="currentTableColumn" />

        <xsl:attribute name="style">
            <!-- sets cell alignment dependent of cell value type -->
            <xsl:call-template name="set-cell-alignment" />

            <!-- set column style (disjunct of cell style) -->
            <xsl:value-of select="$globalData/all-styles/style[@style:name = $currentTableColumn/@table:style-name]/final-properties" />

           <xsl:if test="$outputType = 'CSS_INLINED'">
               <!-- cell style inlined -->
               <xsl:value-of select="$globalData/all-styles/style[@style:name = $styleName]/final-properties" />
           </xsl:if>
       </xsl:attribute>

       <xsl:if test="$outputType = 'CSS_HEADER'">
           <!-- cell style header -->
           <xsl:attribute name="class">
               <xsl:value-of select="translate($styleName, '. %()/\+', '')" />
           </xsl:attribute>
       </xsl:if>
    </xsl:template>
</xsl:stylesheet>

