/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web;

import com.sun.star.awt.Size;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.common.ConfigSet;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.ui.ImageList;
import com.sun.star.wizards.web.ImageListDialog;
import com.sun.star.wizards.web.WebWizardDialogResources;
import com.sun.star.wizards.web.data.CGImage;
import com.sun.star.wizards.web.data.CGSettings;
import javax.swing.DefaultListModel;

public class BackgroundsDialog
extends ImageListDialog {
    private FileAccess fileAccess;
    private SystemDialog sd;
    private CGSettings settings;

    public BackgroundsDialog(XMultiServiceFactory xMultiServiceFactory, ConfigSet configSet, WebWizardDialogResources webWizardDialogResources) throws Exception {
        super(xMultiServiceFactory, 34290, new String[]{webWizardDialogResources.resBackgroundsDialog, webWizardDialogResources.resBackgroundsDialogCaption, webWizardDialogResources.resOK, webWizardDialogResources.resCancel, webWizardDialogResources.resHelp, webWizardDialogResources.resDeselect, webWizardDialogResources.resOther, webWizardDialogResources.resCounter});
        this.sd = SystemDialog.createOpenDialog(xMultiServiceFactory);
        this.sd.addFilter(webWizardDialogResources.resImages, "*.jpg;*.jpeg;*.jpe;*.gif", true);
        this.sd.addFilter(webWizardDialogResources.resAllFiles, "*.*", false);
        this.settings = (CGSettings)configSet.root;
        this.fileAccess = new FileAccess(xMultiServiceFactory);
        this.il.setListModel(new Model(configSet));
        this.il.setImageSize(new Size(40, 40));
        this.il.setRenderer(new BGRenderer(0));
        this.build();
    }

    public void other() {
        String[] stringArray = this.sd.callOpenDialog(false, this.settings.cp_DefaultSession.cp_InDirectory);
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            this.settings.cp_DefaultSession.cp_InDirectory = FileAccess.getParentDir(stringArray[0]);
            int n = this.add(stringArray[0]);
            this.il.setSelected(n);
            this.il.display(n);
        }
    }

    private int add(String string) {
        for (int i = 0; i < this.il.getListModel().getSize(); ++i) {
            if (!this.il.getListModel().getElementAt(i).equals(string)) continue;
            return i;
        }
        ((DefaultListModel)this.il.getListModel()).addElement(string);
        try {
            Object object = Configuration.getConfigurationRoot(this.xMSF, FileAccess.connectURLs("/org.openoffice.Office.WebWizard/WebWizard", "BackgroundImages"), true);
            int n = Configuration.getChildrenNames(object).length + 1;
            Object object2 = Configuration.addConfigNode(object, "" + n);
            Configuration.set(string, "Href", object2);
            Configuration.commit(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.il.getListModel().getSize() - 1;
    }

    private class Model
    extends DefaultListModel {
        public Model(ConfigSet configSet) {
            try {
                for (int i = 0; i < configSet.getSize(); ++i) {
                    CGImage cGImage = (CGImage)configSet.getElementAt(i);
                    String string = ((BackgroundsDialog)BackgroundsDialog.this).sd.xStringSubstitution.substituteVariables(cGImage.cp_Href, false);
                    if (BackgroundsDialog.this.fileAccess.exists(string, false)) {
                        this.addDir(string);
                        continue;
                    }
                    this.remove((String)configSet.getKey(cGImage));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void remove(String string) {
            try {
                Object object = Configuration.getConfigurationRoot(BackgroundsDialog.this.xMSF, "/org.openoffice.Office.WebWizard/WebWizard/BackgroundImages", true);
                Configuration.removeNode(object, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void addDir(String string) {
            if (BackgroundsDialog.this.fileAccess.isDirectory(string)) {
                this.add(BackgroundsDialog.this.fileAccess.listFiles(string, false));
            } else {
                this.add(string);
            }
        }

        private void add(String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(stringArray[i]);
            }
        }

        private void add(String string) {
            String string2 = string.toLowerCase();
            if (string2.endsWith("jpg") || string2.endsWith("jpeg") || string2.endsWith("gif")) {
                this.addElement(string);
            }
        }
    }

    private class BGRenderer
    implements ImageList.ImageRenderer {
        private int cut;

        public BGRenderer(int n) {
            this.cut = n;
        }

        public String getImageUrl(Object object) {
            return object == null ? "" : (String)object;
        }

        public String render(Object object) {
            return object == null ? "" : FileAccess.getPathFilename(BackgroundsDialog.this.fileAccess.getPath((String)object, null));
        }
    }
}

