/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.executer.util;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import java.io.PrintWriter;

public class Debug {
    static /* synthetic */ Class class$com$sun$star$lang$XTypeProvider;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;

    public static void printXWindows(XWindow[] xWindowArray) {
        XWindow[] xWindowArray2 = xWindowArray;
        Helper.log("***********  XWindows *****************");
        for (int i = 0; i < xWindowArray2.length; ++i) {
            XAccessibleContext xAccessibleContext;
            XWindow xWindow = xWindowArray2[i];
            XAccessible xAccessible = AccessibilityTools.getAccessibleObject((XInterface)xWindow);
            if (xAccessible == null || (xAccessibleContext = xAccessible.getAccessibleContext()) == null) continue;
            while (xAccessibleContext.getAccessibleIndexInParent() > -1) {
                xAccessibleContext = xAccessibleContext.getAccessibleParent().getAccessibleContext();
            }
            Helper.log("i = " + i + " ### role : " + xAccessibleContext.getAccessibleRole() + " ###  Name : " + xAccessibleContext.getAccessibleName() + " ###  index : " + xAccessibleContext.getAccessibleIndexInParent());
        }
        Helper.log("*******************************");
    }

    public static void printInterfaces(XInterface xInterface) {
        Type[] typeArray;
        XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XTypeProvider == null ? (class$com$sun$star$lang$XTypeProvider = Debug.class$("com.sun.star.lang.XTypeProvider")) : class$com$sun$star$lang$XTypeProvider), (Object)xInterface);
        if (xTypeProvider != null && null != (typeArray = xTypeProvider.getTypes())) {
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                System.out.println(typeArray[i].getTypeName());
                Debug.printInterfaceInfo(typeArray[i]);
            }
        }
    }

    static void printInterfaceInfo(Type type) {
    }

    public static void printArray(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    public static void printPropertyInfo(XPropertySet xPropertySet, String string) {
        Debug.printPropertyInfo(xPropertySet, string, new PrintWriter(System.out));
    }

    public static void printPropertyInfo(XPropertySet xPropertySet, String string, PrintWriter printWriter) {
        try {
            XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
            Property[] propertyArray = xPropertySetInfo.getProperties();
            Property property = xPropertySetInfo.getPropertyByName(string);
            printWriter.println("Property name is " + property.Name);
            printWriter.println("Property handle is " + property.Handle);
            printWriter.println("Property type is " + property.Type.getTypeName());
            printWriter.println("Property current value is " + xPropertySet.getPropertyValue(string));
            printWriter.println("Attributes :");
            short s = property.Attributes;
            if ((s & 2) != 0) {
                printWriter.println("\t-BOUND");
            }
            if ((s & 4) != 0) {
                printWriter.println("\t-CONSTRAINED");
            }
            if ((s & 0x20) != 0) {
                printWriter.println("\t-MAYBEAMBIGUOUS");
            }
            if ((s & 0x40) != 0) {
                printWriter.println("\t-MAYBEDEFAULT");
            }
            if ((s & 1) != 0) {
                printWriter.println("\t-MAYBEVOID");
            }
            if ((s & 0x10) != 0) {
                printWriter.println("\t-READONLY");
            }
            if ((s & 0x80) != 0) {
                printWriter.println("\t-REMOVEABLE");
            }
            if ((s & 8) != 0) {
                printWriter.println("\t-TRANSIENT");
            }
        }
        catch (Exception exception) {
            printWriter.println("Exception!!!!");
            exception.printStackTrace(printWriter);
        }
    }

    public static void printPropertiesNames(XPropertySet xPropertySet) {
        XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
        Property[] propertyArray = xPropertySetInfo.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            System.out.println(i + ".  " + propertyArray[i].Name);
        }
    }

    public static void getSuppServices(Object object) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = Debug.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo), (Object)object);
        Debug.printArray(xServiceInfo.getSupportedServiceNames());
        System.out.println("Therein not Supported Service");
        String string = "none";
        for (int i = 0; i < xServiceInfo.getSupportedServiceNames().length; ++i) {
            if (xServiceInfo.supportsService(xServiceInfo.getSupportedServiceNames()[i])) continue;
            System.out.println(xServiceInfo.getSupportedServiceNames()[i]);
            string = "";
        }
        System.out.println(string);
    }

    public static String getImplID(XInterface xInterface) {
        String string = "";
        XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XTypeProvider == null ? (class$com$sun$star$lang$XTypeProvider = Debug.class$("com.sun.star.lang.XTypeProvider")) : class$com$sun$star$lang$XTypeProvider), (Object)xInterface);
        if (xTypeProvider != null) {
            byte[] byArray = xTypeProvider.getImplementationId();
            string = "ImplementationID: ";
            for (int i = 0; i < byArray.length; ++i) {
                Byte by = new Byte(byArray[i]);
                string = string + by.intValue();
            }
        } else {
            string = "No Implementation ID available";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

