/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.executer.util;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.util.Properties;

public class Control
extends Robot {
    private static Control m_con;
    private static Rectangle m_rectangle;
    private static int m_mousePoint_X;
    private static int m_mousePoint_Y;
    private static int m_autoMoveMouseDelay;
    private static int m_moveMouseStep;
    private static int m_autoMouseScrollDelay;
    private static int m_autoKeyDelay;
    private static boolean m_animate;
    private static boolean m_break;
    private static String m_mouseAnimateStyle;
    public static final String MOUSE_SCROLL_UP = "UP";
    public static final String MOUSE_SCROLL_DOWN = "DOWN";
    public static final String MOUSE_CLICK_LEFT = "LEFT";
    public static final String MOUSE_CLICK_RIGHT = "RIGHT";
    public static final String MOUSE_CLICK_CENTER = "CENTER";
    public static final String MOUSE_ANIMATE_STYLE_BASIC = "BASIC";
    public static final String MOUSE_ANIMATE_STYLE_MENU = "MENU";
    public static final String MOUSE_ANIMATE_STYLE_LINE = "LINE";
    public static final int MOUSE_OS_WINDOWS_SPEED = 0;
    public static final int MOUSE_OS_LINUX_SPEED = 1;
    public static final int MOUSE_OS_SUNOS_SPEED = 2;

    public Control() throws AWTException {
        m_rectangle = new Rectangle();
        Control.resetMousePosition();
        m_con = this;
    }

    public static synchronized void sleep(int n) {
        if (n < 0 || n > 60000) {
            throw new IllegalArgumentException("Delay must be to 0 to 60,000ms");
        }
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setDelay(int n, int n2, int n3, int n4) {
        m_autoKeyDelay = n;
        m_autoMoveMouseDelay = n2;
        m_autoMouseScrollDelay = n3;
        m_con.setMoveMouseStep(n4);
    }

    private void setMoveMouseStep(int n) {
        String string;
        m_moveMouseStep = n > -1 ? n : ((string = this.getOS_Name()).indexOf("Windows") > -1 ? 0 : (string.indexOf("Linux") > -1 ? 1 : (string.indexOf("SunOS") > -1 ? 2 : n)));
    }

    private String getOS_Name() {
        Properties properties = System.getProperties();
        return properties.getProperty("os.name");
    }

    public static int getKeyDelay() {
        return m_autoKeyDelay;
    }

    public static int getMoveMouseDelay() {
        return m_autoMoveMouseDelay;
    }

    public static int getMouseScrollDelay() {
        return m_autoMouseScrollDelay;
    }

    public static void reset_Key_Mouse_Scroll_Delay() {
        m_autoKeyDelay = 0;
        m_autoMoveMouseDelay = 0;
        m_autoMouseScrollDelay = 0;
    }

    public static synchronized void resetMousePosition() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        m_mousePoint_X = new Double(dimension.getWidth()).intValue() / 2;
        m_mousePoint_Y = new Double(dimension.getHeight()).intValue() / 2;
        m_rectangle.setLocation(m_mousePoint_X, m_mousePoint_Y);
    }

    public static synchronized void setMousePosition(int n, int n2) {
        m_mousePoint_X = n;
        m_mousePoint_Y = n2;
        m_rectangle.setLocation(m_mousePoint_X, m_mousePoint_Y);
    }

    public static synchronized void mouseScroll(String string, int n) {
        int n2 = 0;
        if (!m_break) {
            if (string.equalsIgnoreCase(MOUSE_SCROLL_UP)) {
                n2 = -507;
            } else if (string.equalsIgnoreCase(MOUSE_SCROLL_DOWN)) {
                n2 = 507;
            }
            if (n2 != 0) {
                for (int i = 0; i < n && !m_break; ++i) {
                    Control.sleep(m_autoMouseScrollDelay);
                    m_con.mouseWheel(n2);
                }
            }
        }
    }

    public static synchronized void setMouseAnimate(boolean bl) {
        m_animate = bl;
    }

    public static synchronized boolean getMouseAnimate() {
        return m_animate;
    }

    public static synchronized String mouseAnimate(int[] nArray) {
        String string = "done";
        if (m_animate) {
            string = m_con.mouseAnimate(nArray[0], nArray[1]);
        } else if (m_break) {
            string = "break";
        } else {
            m_con.mouseMove(nArray[0], nArray[1]);
            m_rectangle.setLocation(nArray[0], nArray[1]);
        }
        return string;
    }

    public static synchronized void mouseClick(int n) {
        for (int i = 0; i < n && !m_break; ++i) {
            m_con.mousePress(16);
            m_con.mouseRelease(16);
        }
    }

    public static synchronized void mouseClick() {
        if (!m_break) {
            m_con.mousePress(16);
            m_con.mouseRelease(16);
        }
    }

    public static synchronized void mouseClick(String string) {
        Control.mouseClick(string, 0);
    }

    public static synchronized void mouseClick(String string, int n) {
        if (!m_break) {
            if (string.equalsIgnoreCase(MOUSE_CLICK_LEFT)) {
                m_con.mousePress(16);
                Control.sleep(n);
                m_con.mouseRelease(16);
            } else if (string.equalsIgnoreCase(MOUSE_CLICK_CENTER)) {
                m_con.mousePress(8);
                Control.sleep(n);
                m_con.mouseRelease(8);
            } else if (string.equalsIgnoreCase(MOUSE_CLICK_RIGHT)) {
                m_con.mousePress(4);
                Control.sleep(n);
                m_con.mouseRelease(4);
            }
        }
    }

    public static synchronized String mouseClick(int[] nArray) {
        return Control.mouseClick(nArray, MOUSE_CLICK_LEFT);
    }

    public static synchronized String mouseClick(int[] nArray, String string) {
        return Control.mouseClick(nArray, string, 0);
    }

    public static synchronized String mouseClick(int[] nArray, String string, int n) {
        String string2 = "done";
        if (nArray != null) {
            string2 = Control.mouseAnimate(nArray);
            if (string2.equals("done")) {
                Control.mouseClick(string, n);
            }
        }
        return string2;
    }

    public static synchronized void key_Press_Release(char c) {
        Control.key_Press_Release((int)c);
    }

    public static synchronized void key_Press_Release(int n) {
        if (!m_break) {
            m_con.mousePress(16);
            m_con.mouseRelease(16);
            m_con.keyPress(n);
            m_con.keyRelease(n);
            Control.sleep(m_autoKeyDelay);
        }
    }

    private synchronized void mouseClick(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        if (Control.mouseAnimate(nArray).equals("done")) {
            Control.mouseClick();
        }
    }

    private synchronized String mouseAnimate(int n, int n2) {
        String string = "done";
        int n3 = new Double(m_rectangle.getX()).intValue();
        int n4 = new Double(m_rectangle.getY()).intValue();
        if (n3 == m_mousePoint_X && n4 == m_mousePoint_Y) {
            this.mouseMove(m_mousePoint_X, m_mousePoint_Y);
        }
        string = m_mouseAnimateStyle.equalsIgnoreCase(MOUSE_ANIMATE_STYLE_BASIC) ? this.mouseAnimateStyle_Basic(n3, n4, n, n2) : (m_mouseAnimateStyle.equalsIgnoreCase(MOUSE_ANIMATE_STYLE_MENU) ? this.mouseAnimateStyle_Menu(n3, n4, n, n2) : (m_mouseAnimateStyle.equalsIgnoreCase(MOUSE_ANIMATE_STYLE_LINE) ? this.mouseAnimateStyle_Line(n3, n4, n, n2) : this.mouseAnimateStyle_Basic(n3, n4, n, n2)));
        m_rectangle.setLocation(n, n2);
        return string;
    }

    private String mouseAnimateStyle_Basic(int n, int n2, int n3, int n4) {
        String string = "done";
        while (n != n3 || n2 != n4) {
            if (n < n3) {
                if ((n += 1 + m_moveMouseStep) > n3) {
                    n = n3;
                }
            } else if (n > n3 && (n -= 1 + m_moveMouseStep) < n3) {
                n = n3;
            }
            if (n2 < n4) {
                if ((n2 += 1 + m_moveMouseStep) > n4) {
                    n2 = n4;
                }
            } else if (n2 > n4 && (n2 -= 1 + m_moveMouseStep) < n4) {
                n2 = n4;
            }
            if (m_break) {
                string = "break";
                break;
            }
            this.mouseMove(n, n2);
            Control.sleep(m_autoMoveMouseDelay);
        }
        return string;
    }

    private String mouseAnimateStyle_Menu(int n, int n2, int n3, int n4) {
        String string = "done";
        while (n != n3 || n2 != n4) {
            if (n < n3) {
                if ((n += 1 + m_moveMouseStep) > n3) {
                    n = n3;
                }
            } else if (n > n3) {
                if ((n -= 1 + m_moveMouseStep) < n3) {
                    n = n3;
                }
            } else if (n2 < n4) {
                if ((n2 += 1 + m_moveMouseStep) > n4) {
                    n2 = n4;
                }
            } else if (n2 > n4 && (n2 -= 1 + m_moveMouseStep) < n4) {
                n2 = n4;
            }
            if (m_break) {
                string = "break";
                break;
            }
            this.mouseMove(n, n2);
            Control.sleep(m_autoMoveMouseDelay);
        }
        return string;
    }

    private String mouseAnimateStyle_Line(int n, int n2, int n3, int n4) {
        int[][] nArray;
        String string = "done";
        if ((n != n3 || n2 != n4) && (nArray = this.getLineCoordinates(n, n2, n3, n4)).length > 0) {
            int n5 = nArray.length;
            for (int i = 0; i < n5; i += 1 + m_moveMouseStep) {
                if (m_break) {
                    string = "break";
                    return string;
                }
                this.mouseMove(nArray[i][0], nArray[i][1]);
                Control.sleep(m_autoMoveMouseDelay);
            }
            this.mouseMove(nArray[n5 - 1][0], nArray[n5 - 1][1]);
        }
        return string;
    }

    public synchronized int[][] getLineCoordinates(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = 0;
        int[][] nArray = null;
        int n8 = Math.abs(n - n3);
        int n9 = Math.abs(n2 - n4);
        int n10 = n3 > n ? 1 : -1;
        int n11 = n5 = n4 > n2 ? 1 : -1;
        if (n8 > n9) {
            nArray = new int[n8 + 1][n8 + 1];
            for (int i = 0; i <= n8; ++i) {
                n7 = (int)Math.floor((double)n2 * (((double)n8 - (double)i) / (double)n8) + (double)n4 * ((double)i / (double)n8));
                nArray[i][0] = n6 = n + n10 * i;
                nArray[i][1] = n7;
            }
        } else {
            nArray = new int[n9 + 1][n9 + 1];
            for (int i = 0; i <= n9; ++i) {
                n6 = (int)Math.floor((double)n * (((double)n9 - (double)i) / (double)n9) + (double)n3 * ((double)i / (double)n9));
                n7 = n2 + n5 * i;
                nArray[i][0] = n6;
                nArray[i][1] = n7;
            }
        }
        return nArray;
    }

    public static boolean setAnimateStyle(String string) {
        if (string.equals(MOUSE_ANIMATE_STYLE_BASIC) || string.equals(MOUSE_ANIMATE_STYLE_LINE) || string.equals(MOUSE_ANIMATE_STYLE_MENU)) {
            m_mouseAnimateStyle = string;
            return true;
        }
        return false;
    }

    public static void setBreakControl(boolean bl) {
        m_break = bl;
    }

    public static boolean getBreakControl() {
        return m_break;
    }

    public static void mouseMove(int[] nArray) {
        m_con.mouseMove(nArray[0], nArray[1]);
    }

    static {
        m_mousePoint_X = 0;
        m_mousePoint_Y = 0;
        m_autoMoveMouseDelay = 4;
        m_moveMouseStep = 1;
        m_autoMouseScrollDelay = 10;
        m_autoKeyDelay = 0;
        m_animate = true;
        m_break = false;
        m_mouseAnimateStyle = MOUSE_ANIMATE_STYLE_LINE;
        try {
            new Control();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }
}

