/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.executer.util;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.sheet.XCellAddressable;
import com.sun.star.table.XCell;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.tutorial.executer.util.Child;
import com.sun.star.wizards.tutorial.executer.util.Debug;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import com.sun.star.wizards.tutorial.executer.util.NameProvider;
import com.sun.star.wizards.tutorial.executer.util.PathProperties;
import com.sun.star.wizards.tutorial.executer.util.PropertiesFileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AccessibilityTools {
    private static AccessibilityTools m_acces;
    private static int m_LIMIT;
    private static int m_MAX_COUNT;
    private static int m_LEVEL;
    private static int m_SHEET_LIMIT;
    public static final String SERCH_FORM_NAME = "NAME";
    public static final String SERCH_FORM_INDEX = "INDEX";
    private static String m_current_search_form;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessible;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleEditableText;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleText;
    static /* synthetic */ Class class$com$sun$star$table$XCell;
    static /* synthetic */ Class class$com$sun$star$sheet$XCellAddressable;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleSelection;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleContext;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;

    private AccessibilityTools() {
        m_acces = this;
    }

    public static void setSearchForm(String string) throws Exception {
        if (!string.equals(SERCH_FORM_NAME) && !string.equals(SERCH_FORM_INDEX)) {
            throw new Exception("Search form invalid!");
        }
        m_current_search_form = string;
    }

    public static String getSearchForm() {
        return m_current_search_form;
    }

    public static XAccessible getAccessibleObject(XInterface xInterface) {
        XAccessible xAccessible = null;
        try {
            xAccessible = (XAccessible)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessible == null ? (class$com$sun$star$accessibility$XAccessible = AccessibilityTools.class$("com.sun.star.accessibility.XAccessible")) : class$com$sun$star$accessibility$XAccessible), (Object)xInterface);
        }
        catch (Exception exception) {
            Helper.log("caught exception while getting accessible object" + exception);
            exception.printStackTrace();
        }
        return xAccessible;
    }

    public static XAccessibleEditableText getAccessibleEditableTextObject(XInterface xInterface) {
        XAccessibleEditableText xAccessibleEditableText = null;
        try {
            xAccessibleEditableText = (XAccessibleEditableText)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleEditableText == null ? (class$com$sun$star$accessibility$XAccessibleEditableText = AccessibilityTools.class$("com.sun.star.accessibility.XAccessibleEditableText")) : class$com$sun$star$accessibility$XAccessibleEditableText), (Object)xInterface);
        }
        catch (Exception exception) {
            Helper.log("caught exception while getting accessible object" + exception);
            exception.printStackTrace();
        }
        return xAccessibleEditableText;
    }

    public static XAccessibleText getAccessibleTextObject(XInterface xInterface) {
        XAccessibleText xAccessibleText = null;
        try {
            xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleText == null ? (class$com$sun$star$accessibility$XAccessibleText = AccessibilityTools.class$("com.sun.star.accessibility.XAccessibleText")) : class$com$sun$star$accessibility$XAccessibleText), (Object)xInterface);
        }
        catch (Exception exception) {
            Helper.log("caught exception while getting accessible object" + exception);
            exception.printStackTrace();
        }
        return xAccessibleText;
    }

    public static XCell getAccessibleCell(XInterface xInterface) {
        XCell xCell = null;
        try {
            xCell = (XCell)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCell == null ? (class$com$sun$star$table$XCell = AccessibilityTools.class$("com.sun.star.table.XCell")) : class$com$sun$star$table$XCell), (Object)xInterface);
        }
        catch (Exception exception) {
            Helper.log("caught exception while getting accessible object" + exception);
            exception.printStackTrace();
        }
        return xCell;
    }

    public static XCellAddressable getCellAddressable(XInterface xInterface) {
        XCellAddressable xCellAddressable = null;
        try {
            xCellAddressable = (XCellAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellAddressable == null ? (class$com$sun$star$sheet$XCellAddressable = AccessibilityTools.class$("com.sun.star.sheet.XCellAddressable")) : class$com$sun$star$sheet$XCellAddressable), (Object)xInterface);
        }
        catch (Exception exception) {
            Helper.log("caught exception while getting accessible object" + exception);
            exception.printStackTrace();
        }
        return xCellAddressable;
    }

    public static XAccessibleSelection getXAccessibleSelection(XInterface xInterface) {
        XAccessibleSelection xAccessibleSelection = null;
        try {
            xAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleSelection == null ? (class$com$sun$star$accessibility$XAccessibleSelection = AccessibilityTools.class$("com.sun.star.accessibility.XAccessibleSelection")) : class$com$sun$star$accessibility$XAccessibleSelection), (Object)xInterface);
        }
        catch (Exception exception) {
            Helper.log("caught exception while getting accessible object" + exception);
            exception.printStackTrace();
        }
        return xAccessibleSelection;
    }

    public static XAccessibleContext getXAccessibleContext(XInterface xInterface) {
        XAccessibleContext xAccessibleContext = null;
        try {
            xAccessibleContext = (XAccessibleContext)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleContext == null ? (class$com$sun$star$accessibility$XAccessibleContext = AccessibilityTools.class$("com.sun.star.accessibility.XAccessibleContext")) : class$com$sun$star$accessibility$XAccessibleContext), (Object)xInterface);
        }
        catch (Exception exception) {
            Helper.log("caught exception while getting accessible object" + exception);
            exception.printStackTrace();
        }
        return xAccessibleContext;
    }

    private void getAllXAccessibleContexts(XAccessibleContext xAccessibleContext, short s, String string, Vector vector) {
        try {
            short s2 = xAccessibleContext.getAccessibleRole();
            String string2 = xAccessibleContext.getAccessibleName().trim();
            if (s2 == s && string2.equals(string)) {
                vector.add(xAccessibleContext);
            } else {
                XAccessibleContext xAccessibleContext2 = null;
                int n = xAccessibleContext.getAccessibleChildCount();
                if (n > m_SHEET_LIMIT) {
                    if (s == 59) {
                        xAccessibleContext2 = m_acces.getXAccessibleCellContext(xAccessibleContext, string, 0, xAccessibleContext.getAccessibleChildCount());
                        vector.add(xAccessibleContext2);
                    }
                } else if (s == 41) {
                    String string3;
                    int n2;
                    XAccessible xAccessible;
                    int n3 = string.indexOf("Paragraph:");
                    if (n3 > -1 && (xAccessible = xAccessibleContext.getAccessibleChild(n2 = Integer.parseInt(string3 = string.substring(n3 + "Paragraph:".length()).trim()))) != null) {
                        xAccessibleContext2 = xAccessible.getAccessibleContext();
                        vector.add(xAccessibleContext2);
                    }
                } else if (n < m_SHEET_LIMIT) {
                    if (n > m_LIMIT) {
                        n = m_LIMIT;
                    }
                    for (int i = 0; i < n; ++i) {
                        xAccessibleContext2 = xAccessibleContext.getAccessibleChild(i).getAccessibleContext();
                        s2 = xAccessibleContext2.getAccessibleRole();
                        string2 = xAccessibleContext2.getAccessibleName().trim();
                        if (s2 != s || !string2.equals(string)) continue;
                        Helper.log("ROLE4 = " + xAccessibleContext2.getAccessibleRole());
                        Helper.log("NAME4 = " + xAccessibleContext2.getAccessibleName());
                        Helper.log("***************************");
                        vector.add(xAccessibleContext2);
                        i = n;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Helper.log("Couldn't get Child");
        }
    }

    private XAccessibleContext getAllXAccessibleContexts(XAccessibleContext xAccessibleContext, String[] stringArray) {
        int n = stringArray.length;
        XAccessibleContext xAccessibleContext2 = xAccessibleContext;
        try {
            for (int i = 1; i < n; ++i) {
                PathProperties.putPath(stringArray, i);
                int n2 = PathProperties.getIndex();
                short s = PathProperties.getRole();
                Helper.log("**************************************");
                Helper.log("Search child : " + n2);
                Helper.log("childer : " + xAccessibleContext2.getAccessibleChildCount());
                if (xAccessibleContext2 != null && xAccessibleContext2.getAccessibleChildCount() > n2) {
                    for (int j = 0; j < xAccessibleContext2.getAccessibleChildCount(); ++j) {
                        Helper.log("child : " + xAccessibleContext2.getAccessibleChild(j).getAccessibleContext().getAccessibleRole() + " **** " + xAccessibleContext2.getAccessibleChild(j).getAccessibleContext().getAccessibleName());
                    }
                    xAccessibleContext2 = xAccessibleContext2.getAccessibleChild(n2).getAccessibleContext();
                    Helper.log("Find child for index :" + xAccessibleContext2.getAccessibleRole() + " ** " + xAccessibleContext2.getAccessibleName());
                    Helper.log("**************************************");
                    if (xAccessibleContext2.getAccessibleRole() == s) continue;
                    xAccessibleContext2 = null;
                } else {
                    xAccessibleContext2 = null;
                }
                break;
            }
        }
        catch (Exception exception) {
            xAccessibleContext2 = null;
            exception.printStackTrace();
        }
        return xAccessibleContext2;
    }

    private Vector getAllXAccessibleContextsHelp(short s, String string, Vector vector) {
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            XAccessibleContext xAccessibleContext = (XAccessibleContext)enumeration.nextElement();
            Helper.log("ROLE3 = " + xAccessibleContext.getAccessibleRole());
            Helper.log("NAME3 = " + xAccessibleContext.getAccessibleName());
            Helper.log("***************************");
            this.getAllXAccessibleContexts(xAccessibleContext, s, string, vector2);
        }
        return vector2;
    }

    private XAccessibleContext getAllXAccessibleIndexContextsHelp(String[] stringArray, Vector vector) {
        XAccessibleContext xAccessibleContext = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            xAccessibleContext = (XAccessibleContext)enumeration.nextElement();
            Helper.log("ROLE4 = " + xAccessibleContext.getAccessibleRole());
            Helper.log("NAME4 = " + xAccessibleContext.getAccessibleName());
            Helper.log("***************************");
            if ((xAccessibleContext = this.getAllXAccessibleContexts(xAccessibleContext, stringArray)) == null) continue;
            break;
        }
        return xAccessibleContext;
    }

    public static boolean isTopWindowActive(XWindow[] xWindowArray, short s, String string) {
        if (xWindowArray != null) {
            Debug.printXWindows(xWindowArray);
            for (int i = 0; i < xWindowArray.length; ++i) {
                XWindow xWindow = xWindowArray[i];
                XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObject((XInterface)xWindow).getAccessibleContext();
                while (xAccessibleContext.getAccessibleIndexInParent() > -1) {
                    xAccessibleContext = xAccessibleContext.getAccessibleParent().getAccessibleContext();
                }
                if (xAccessibleContext.getAccessibleRole() != s || !xAccessibleContext.getAccessibleName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTopWindowActive(XWindow[] xWindowArray, short s) {
        if (xWindowArray != null) {
            Debug.printXWindows(xWindowArray);
            for (int i = 0; i < xWindowArray.length; ++i) {
                XAccessibleContext xAccessibleContext;
                XWindow xWindow = xWindowArray[i];
                if (xWindow == null || (xAccessibleContext = AccessibilityTools.getAccessibleObject((XInterface)xWindow).getAccessibleContext()) == null) continue;
                while (xAccessibleContext.getAccessibleIndexInParent() > -1) {
                    xAccessibleContext = xAccessibleContext.getAccessibleParent().getAccessibleContext();
                }
                if (xAccessibleContext.getAccessibleRole() != s) continue;
                return true;
            }
        }
        return false;
    }

    public static XAccessibleContext getXAccessibleContext(XAccessibleContext xAccessibleContext, short s, String string) {
        return m_acces.findXAccessibleContextHelp(xAccessibleContext, s, string);
    }

    public static String getRoleName(int n) {
        return NameProvider.getRoleName(n);
    }

    public static boolean checkState(XAccessibleContext xAccessibleContext, short s) {
        XAccessibleStateSet xAccessibleStateSet = xAccessibleContext.getAccessibleStateSet();
        return xAccessibleStateSet.contains(s);
    }

    public static Vector getXAllAccessibleProperties(XAccessible xAccessible) {
        Vector vector = new Vector();
        m_acces.setAllAccessibleProperties(xAccessible, vector, "");
        return vector;
    }

    public static String getImplName(Object object) {
        String string = "Error getting Implementation name";
        try {
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = AccessibilityTools.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo), (Object)object);
            string = xServiceInfo.getImplementationName();
        }
        catch (Exception exception) {
            string = "Error getting Implementation name ( " + exception + " )";
        }
        return string;
    }

    public static String[] getSupportedServiceNames(Object object) {
        String[] stringArray = null;
        try {
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = AccessibilityTools.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo), (Object)object);
            if (xServiceInfo != null) {
                stringArray = xServiceInfo.getSupportedServiceNames();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public static int[] getPoints(XInterface xInterface) {
        Point point = AccessibilityTools.getObjPoint(xInterface);
        Rectangle rectangle = AccessibilityTools.getObjRectangle(xInterface);
        int n = new Long(rectangle.Width).intValue();
        if (n > 25) {
            n = 25;
        }
        int n2 = new Long(rectangle.Height).intValue();
        int[] nArray = new int[]{point.X + n / 2, point.Y + n2 / 2};
        return nArray;
    }

    public static Rectangle getObjRectangle(XInterface xInterface) {
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = AccessibilityTools.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent), (Object)xInterface);
        Rectangle rectangle = xAccessibleComponent.getBounds();
        return rectangle;
    }

    public static Point getObjPoint(XInterface xInterface) {
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = AccessibilityTools.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent), (Object)xInterface);
        Point point = xAccessibleComponent.getLocationOnScreen();
        return point;
    }

    public static void printAccessibleTree(XAccessible xAccessible, String string) {
        AccessibilityTools.printAccessibleTree(xAccessible, null, string);
    }

    public static void printAccessibleTree(XAccessible xAccessible, String string, String string2) {
        try {
            if (xAccessible != null && (string2.equals("Line") || string2.equals("Tree"))) {
                PropertiesFileWriter propertiesFileWriter = null;
                String string3 = "";
                if (string != null) {
                    propertiesFileWriter = new PropertiesFileWriter(string);
                }
                if (string2.equals("Line")) {
                    AccessibilityTools.printAccessibleTree_LineForm(xAccessible, new StringBuffer(string3), propertiesFileWriter, "RootRole", "RootName");
                } else if (string2.equals("Tree")) {
                    AccessibilityTools.printAccessibleTree_TreeForm(xAccessible, string3, propertiesFileWriter);
                }
                if (propertiesFileWriter != null) {
                    propertiesFileWriter.close();
                }
            }
        }
        catch (IOException iOException) {
            Helper.log("Can't create/write to file Error");
        }
    }

    public static void printAccessibleTree_LineForm(XAccessible xAccessible, StringBuffer stringBuffer, PropertiesFileWriter propertiesFileWriter, String string, String string2) {
        int n;
        String string3;
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        String string4 = "<" + string + ": " + NameProvider.getRoleName(xAccessibleContext.getAccessibleRole());
        if (AccessibilityTools.getImplName(xAccessibleContext).equals("ScAccessibleCell")) {
            string3 = ", CellContent: \t" + ((XAccessibleText)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleText == null ? (class$com$sun$star$accessibility$XAccessibleText = AccessibilityTools.class$("com.sun.star.accessibility.XAccessibleText")) : class$com$sun$star$accessibility$XAccessibleText), (Object)xAccessibleContext)).getText();
            string4 = string4 + ", " + string2 + ": " + xAccessibleContext.getAccessibleName() + string3 + " />";
        } else if (xAccessibleContext.getAccessibleRole() == 41 && xAccessibleContext.getAccessibleDescription().indexOf("Paragraph") > -1) {
            string3 = xAccessibleContext.getAccessibleDescription();
            n = string3.indexOf("Paragraph:");
            String string5 = string3.substring(n + "Paragraph:".length()).trim();
            string4 = string4 + ", " + string2 + ": Paragraph:" + xAccessibleContext.getAccessibleIndexInParent() + ", Content: " + string5 + " " + " />";
        } else {
            string4 = string4 + ", " + string2 + ": " + xAccessibleContext.getAccessibleName() + " />";
        }
        if (propertiesFileWriter != null) {
            propertiesFileWriter.println(stringBuffer.toString() + string4);
        } else {
            Helper.log(stringBuffer.toString() + string4);
        }
        int n2 = xAccessibleContext.getAccessibleChildCount();
        if (n2 > m_LIMIT) {
            n2 = m_LIMIT;
        }
        for (n = 0; n < n2; ++n) {
            try {
                AccessibilityTools.printAccessibleTree_LineForm(xAccessibleContext.getAccessibleChild(n), stringBuffer.append(string4), propertiesFileWriter, "Role", "Name");
                stringBuffer = stringBuffer.delete(stringBuffer.length() - string4.length(), stringBuffer.length());
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Helper.log("Couldn't get Child");
            }
        }
        if (xAccessibleContext.getAccessibleChildCount() > m_LIMIT) {
            n2 = xAccessibleContext.getAccessibleChildCount();
            n = xAccessibleContext.getAccessibleChildCount() - 50;
            if (propertiesFileWriter != null) {
                propertiesFileWriter.println(" ...... [skipped] ......");
            } else {
                Helper.log(" ...... [skipped] ......");
            }
            for (int i = n; i < n2; ++i) {
                try {
                    AccessibilityTools.printAccessibleTree_LineForm(xAccessibleContext.getAccessibleChild(i), stringBuffer.append(string4), propertiesFileWriter, "Role", "Name");
                    stringBuffer = stringBuffer.delete(stringBuffer.length() - string4.length(), stringBuffer.length());
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Helper.log("Couldn't get Child");
                }
            }
        }
    }

    public static void printAccessibleTree_TreeForm(XAccessible xAccessible, String string, PropertiesFileWriter propertiesFileWriter) {
        int n;
        Object object;
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        String string2 = string + xAccessibleContext.getAccessibleRole() + ",";
        if (AccessibilityTools.getImplName(xAccessibleContext).equals("ScAccessibleCell")) {
            object = ", ( CellContent: \t" + ((XAccessibleText)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleText == null ? (class$com$sun$star$accessibility$XAccessibleText = AccessibilityTools.class$("com.sun.star.accessibility.XAccessibleText")) : class$com$sun$star$accessibility$XAccessibleText), (Object)xAccessibleContext)).getText() + ")";
            string2 = string2 + xAccessibleContext.getAccessibleName() + (String)object;
        } else if (xAccessibleContext.getAccessibleRole() == 41 && xAccessibleContext.getAccessibleDescription().indexOf("Paragraph") > -1) {
            object = xAccessibleContext.getAccessibleDescription();
            n = ((String)object).indexOf("Paragraph:");
            String string3 = ((String)object).substring(n + "Paragraph:".length()).trim();
            string2 = string2 + " Paragraph:" + xAccessibleContext.getAccessibleIndexInParent() + ", ( Content: " + string3 + " )";
        } else {
            object = AccessibilityTools.getObjPoint((XInterface)xAccessibleContext);
            string2 = string2 + xAccessibleContext.getAccessibleName() + AccessibilityTools.getImplName(xAccessibleContext) + " show :" + AccessibilityTools.checkState(xAccessibleContext, (short)25) + " visible :" + AccessibilityTools.checkState(xAccessibleContext, (short)30) + " points : " + ((Point)object).X + "  " + ((Point)object).Y;
        }
        if (propertiesFileWriter != null) {
            propertiesFileWriter.println(string2);
        } else {
            Helper.log(string2);
        }
        int n2 = xAccessibleContext.getAccessibleChildCount();
        if (n2 > m_LIMIT) {
            n2 = m_LIMIT;
        }
        for (n = 0; n < n2; ++n) {
            try {
                AccessibilityTools.printAccessibleTree_TreeForm(xAccessibleContext.getAccessibleChild(n), string + "  ", propertiesFileWriter);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Helper.log("Couldn't get Child");
            }
        }
        if (xAccessibleContext.getAccessibleChildCount() > m_LIMIT) {
            n2 = xAccessibleContext.getAccessibleChildCount();
            n = xAccessibleContext.getAccessibleChildCount() - 50;
            if (propertiesFileWriter != null) {
                propertiesFileWriter.println(" ...... [skipped] ......");
            } else {
                Helper.log(" ...... [skipped] ......");
            }
            for (int i = n; i < n2; ++i) {
                try {
                    AccessibilityTools.printAccessibleTree_TreeForm(xAccessibleContext.getAccessibleChild(i), string + "  ", propertiesFileWriter);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Helper.log("Couldn't get Child");
                }
            }
        }
    }

    public static synchronized XAccessibleContext getXAccessibleContext(XWindow xWindow, XWindow[] xWindowArray, String[] stringArray) {
        XAccessibleContext xAccessibleContext = null;
        if (m_current_search_form.equals(SERCH_FORM_NAME)) {
            XAccessible xAccessible = AccessibilityTools.getXAccessible(xWindowArray, stringArray);
            if (xAccessible != null) {
                xAccessibleContext = AccessibilityTools.getXAccessibleContext(xAccessible.getAccessibleContext(), stringArray);
            }
        } else if (m_current_search_form.equals(SERCH_FORM_INDEX)) {
            xAccessibleContext = AccessibilityTools.getXAccessibleContext_Index(xWindow, xWindowArray, stringArray);
        }
        if (xAccessibleContext != null) {
            Helper.log("END Gefundene ROLE = " + xAccessibleContext.getAccessibleRole());
            Helper.log("END Gefundene NAME = " + xAccessibleContext.getAccessibleName());
            Helper.log("***************************");
        } else {
            Helper.log("END Gefundene ROLE = NULL");
            Helper.log("END Gefundene NAME = NULL");
        }
        return xAccessibleContext;
    }

    public static XAccessibleContext getXAccessibleContext(XAccessibleContext xAccessibleContext, String[] stringArray) {
        int n = stringArray.length;
        Vector vector = new Vector();
        XAccessibleContext xAccessibleContext2 = xAccessibleContext;
        if (xAccessibleContext2 != null) {
            vector.add(xAccessibleContext2);
            try {
                short s = -1;
                String string = "";
                for (int i = 0; i < n && !vector.isEmpty(); ++i) {
                    String string2 = stringArray[i].trim();
                    String[] stringArray2 = string2.split("#", 3);
                    if (stringArray2.length == 3) {
                        String string3 = stringArray2[0].trim();
                        if (string3.indexOf("{D}") > -1) {
                            string3 = string3.substring("{D}".length());
                        }
                        if (NameProvider.getRoleId(string3) > -1) {
                            s = (short)NameProvider.getRoleId(string3);
                            string = stringArray2[1].trim();
                            vector = m_acces.getAllXAccessibleContextsHelp(s, string, vector);
                        } else {
                            i = n;
                        }
                    } else {
                        i = n;
                    }
                    if (vector.isEmpty()) continue;
                    xAccessibleContext2 = (XAccessibleContext)vector.get(0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Helper.log("Is not in the correct number format ");
            }
        }
        return xAccessibleContext2;
    }

    public static XAccessibleContext getXAccessibleContext_Index(XWindow xWindow, XWindow[] xWindowArray, String[] stringArray) {
        int n = stringArray.length;
        Vector<XAccessibleContext> vector = new Vector<XAccessibleContext>();
        int n2 = -1;
        XAccessibleContext xAccessibleContext = null;
        if (xWindowArray.length > 0) {
            PathProperties.putPath(stringArray, 0);
            if (xWindow != null) {
                xAccessibleContext = AccessibilityTools.getAccessibleObject((XInterface)xWindow).getAccessibleContext();
                if (xAccessibleContext != null && xAccessibleContext.getAccessibleRole() == PathProperties.getRole()) {
                    Helper.log("activeName : " + xAccessibleContext.getAccessibleName());
                    Helper.log("activeRole : " + xAccessibleContext.getAccessibleRole());
                    vector.add(xAccessibleContext);
                    xAccessibleContext = m_acces.getAllXAccessibleIndexContextsHelp(stringArray, vector);
                } else {
                    xAccessibleContext = null;
                }
            }
            if (xAccessibleContext == null) {
                for (int i = 0; i < xWindowArray.length; ++i) {
                    XWindow xWindow2 = xWindowArray[i];
                    XAccessible xAccessible = AccessibilityTools.getAccessibleObject((XInterface)xWindow2);
                    if (xAccessible == null || xAccessible.getAccessibleContext() == null) continue;
                    xAccessibleContext = xAccessible.getAccessibleContext();
                    while (xAccessibleContext.getAccessibleIndexInParent() > -1) {
                        xAccessibleContext = xAccessibleContext.getAccessibleParent().getAccessibleContext();
                    }
                    Helper.log("*****************************************");
                    Helper.log("search index : " + PathProperties.getIndex());
                    Helper.log("search name : " + PathProperties.getName());
                    Helper.log("search role : " + PathProperties.getRole());
                    Helper.log("ac role : " + xAccessibleContext.getAccessibleRole());
                    Helper.log("ac name : " + xAccessibleContext.getAccessibleName());
                    Helper.log("ac index : " + xAccessibleContext.getAccessibleIndexInParent());
                    Helper.log("*****************************************");
                    if (xAccessibleContext == null || xAccessibleContext.getAccessibleRole() != PathProperties.getRole()) continue;
                    vector.add(xAccessibleContext);
                }
                if (!vector.isEmpty()) {
                    xAccessibleContext = m_acces.getAllXAccessibleIndexContextsHelp(stringArray, vector);
                }
            }
        }
        return xAccessibleContext;
    }

    private static XAccessible getXAccessible(XWindow[] xWindowArray, String[] stringArray) {
        String[] stringArray2;
        String string = "";
        short s = -1;
        if (stringArray.length > 0 && (stringArray2 = stringArray[0].trim().split("#", 3)).length == 3) {
            String string2 = stringArray2[0].trim();
            if (string2.indexOf("{D}") > -1) {
                string2 = string2.substring("{D}".length());
            }
            s = (short)NameProvider.getRoleId(string2);
            string = stringArray2[1].trim();
        }
        return AccessibilityTools.getXAccessible(xWindowArray, string, s);
    }

    public static XAccessible getXAccessible(XWindow[] xWindowArray, String string, short s) {
        XAccessible xAccessible = null;
        XAccessible[] xAccessibleArray = AccessibilityTools.getXAccessibles(xWindowArray);
        int n = xAccessibleArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            XAccessibleContext xAccessibleContext;
            String string3;
            if (xAccessibleArray[i] == null || !(string3 = (xAccessibleContext = xAccessibleArray[i].getAccessibleContext()).getAccessibleName().trim()).equals(string2 = string.trim()) || xAccessibleContext.getAccessibleRole() != s) continue;
            xAccessible = xAccessibleArray[i];
            i = n;
        }
        return xAccessible;
    }

    public static XAccessible[] getXAccessibles(XWindow[] xWindowArray) {
        XAccessible[] xAccessibleArray = null;
        if (xWindowArray != null && xWindowArray.length > 0) {
            xAccessibleArray = new XAccessible[xWindowArray.length];
            for (int i = 0; i < xWindowArray.length; ++i) {
                XAccessibleContext xAccessibleContext;
                XWindow xWindow = xWindowArray[i];
                XAccessible xAccessible = AccessibilityTools.getAccessibleObject((XInterface)xWindow);
                if (xAccessible == null || (xAccessibleContext = xAccessible.getAccessibleContext()) == null) continue;
                while (xAccessibleContext.getAccessibleIndexInParent() > -1) {
                    xAccessible = xAccessibleContext.getAccessibleParent();
                    xAccessibleContext = xAccessible.getAccessibleContext();
                }
                xAccessibleArray[i] = xAccessible;
            }
        }
        return xAccessibleArray;
    }

    public static int getXWindowIndex(XWindow[] xWindowArray, String string, short s) {
        int n = -1;
        Debug.printXWindows(xWindowArray);
        if (xWindowArray != null) {
            for (int i = 0; i < xWindowArray.length; ++i) {
                XAccessibleContext xAccessibleContext;
                XWindow xWindow = xWindowArray[i];
                XAccessible xAccessible = AccessibilityTools.getAccessibleObject((XInterface)xWindow);
                if (xAccessible == null || (xAccessibleContext = xAccessible.getAccessibleContext()) == null) continue;
                while (xAccessibleContext.getAccessibleIndexInParent() > -1) {
                    xAccessible = xAccessibleContext.getAccessibleParent();
                    xAccessibleContext = xAccessible.getAccessibleContext();
                }
                if (xAccessibleContext.getAccessibleRole() != s || !xAccessibleContext.getAccessibleName().equals(string)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private XAccessibleContext getXAccessibleCellContext(XAccessibleContext xAccessibleContext, String string, int n, int n2) throws IndexOutOfBoundsException {
        XAccessibleContext xAccessibleContext2 = null;
        int n3 = -1;
        n3 = n == 0 ? n2 / 2 : n + (n2 - n) / 2;
        XAccessibleContext xAccessibleContext3 = xAccessibleContext.getAccessibleChild(n3).getAccessibleContext();
        int n4 = this.compare(string, xAccessibleContext3.getAccessibleName());
        if (n4 == 0) {
            xAccessibleContext2 = xAccessibleContext3;
        } else if (n4 < 0 && n3 != n2) {
            xAccessibleContext2 = this.getXAccessibleCellContext(xAccessibleContext, string, n, n3);
        } else if (n4 > 0 && n3 != n) {
            xAccessibleContext2 = this.getXAccessibleCellContext(xAccessibleContext, string, n3, n2);
        }
        return xAccessibleContext2;
    }

    private int compare(String string, String string2) {
        int n = this.compareNumber(this.getNumber(string), this.getNumber(string2));
        if (n == 0) {
            int n2;
            int n3 = string.length();
            n = n3 == (n2 = string2.length()) ? string.compareTo(string2) : (n3 < n2 ? -1 : 1);
        }
        return n;
    }

    private int compareNumber(String string, String string2) {
        Integer n = Integer.decode(string);
        Integer n2 = Integer.decode(string2);
        return n.compareTo(n2);
    }

    private String getNumber(String string) {
        String string2 = "";
        for (int i = string.length() - 1; i > -1; --i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                string2 = c + string2;
                continue;
            }
            i = -1;
        }
        return string2;
    }

    private XAccessibleContext findXAccessibleContextHelp(XAccessible xAccessible, short s, String string) {
        return this.findXAccessibleContextHelp(xAccessible.getAccessibleContext(), s, string);
    }

    private XAccessibleContext findXAccessibleContextHelp(XAccessibleContext xAccessibleContext, short s, String string) {
        Vector vector = new Vector();
        XAccessibleContext xAccessibleContext2 = this.findXAccessibleContext(xAccessibleContext, s, string, 0, vector);
        if (xAccessibleContext2 == null) {
            Child child;
            while (!vector.isEmpty() && (xAccessibleContext2 = this.findXAccessibleContext((child = (Child)vector.elementAt(0)).getXAccessibleContext(), s, string, child.getIndex(), vector)) == null) {
                vector.removeElementAt(0);
            }
        }
        return xAccessibleContext2;
    }

    private XAccessibleContext findXAccessibleContext(XAccessibleContext xAccessibleContext, short s, String string, int n, Vector vector) {
        if (xAccessibleContext.getAccessibleRole() == s && xAccessibleContext.getAccessibleName().equals(string)) {
            return xAccessibleContext;
        }
        try {
            XAccessibleContext xAccessibleContext2 = null;
            int n2 = xAccessibleContext.getAccessibleChildCount();
            if (n2 > m_SHEET_LIMIT && s == 59) {
                xAccessibleContext2 = m_acces.getXAccessibleCellContext(xAccessibleContext, string, 0, xAccessibleContext.getAccessibleChildCount());
                return xAccessibleContext2;
            }
            if (n2 > m_SHEET_LIMIT && s != 59) {
                return null;
            }
            if (n2 > m_LIMIT) {
                n2 = m_LIMIT;
            }
            for (int i = n; i < n2; ++i) {
                xAccessibleContext2 = this.findXAccessibleContext(xAccessibleContext.getAccessibleChild(i).getAccessibleContext(), s, string, 0, vector);
                if (xAccessibleContext2 != null) {
                    Helper.log("Find Role : " + xAccessibleContext2.getAccessibleRole());
                    Helper.log("Find Name : " + xAccessibleContext2.getAccessibleName());
                    Helper.log("Parent Child Count : " + xAccessibleContext2.getAccessibleParent().getAccessibleContext().getAccessibleChildCount());
                    Helper.log("Find IndexinParent : " + xAccessibleContext2.getAccessibleIndexInParent());
                    return xAccessibleContext2;
                }
                if (n2 <= n + m_MAX_COUNT || i != n + m_MAX_COUNT) continue;
                Child child = Child.createNewChild(xAccessibleContext, i);
                vector.add(child);
                return null;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Helper.log("Couldn't get Child");
        }
        return null;
    }

    private void setAllAccessibleProperties(XAccessible xAccessible, Vector vector, String string) {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        vector.add(string + this.accessibleToString(xAccessibleContext));
        int n = xAccessibleContext.getAccessibleChildCount();
        for (int i = 0; i < n; ++i) {
            try {
                this.setAllAccessibleProperties(xAccessibleContext.getAccessibleChild(i), vector, string + "  ");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Helper.log("Couldn't get Child");
            }
        }
    }

    private String accessibleToString(XAccessibleContext xAccessibleContext) {
        String string = "";
        XAccessibleContext xAccessibleContext2 = xAccessibleContext;
        if (xAccessibleContext2 != null) {
            string = "Role : " + xAccessibleContext2.getAccessibleRole() + ", Name : " + xAccessibleContext2.getAccessibleName() + "(" + xAccessibleContext2.getAccessibleDescription() + "), Implementation name : " + AccessibilityTools.getImplName(xAccessibleContext2);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_LIMIT = 300;
        m_MAX_COUNT = 5;
        m_LEVEL = 1;
        m_SHEET_LIMIT = 8000000;
        m_current_search_form = SERCH_FORM_NAME;
        new AccessibilityTools();
    }
}

