/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.table.XCell;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.tutorial.executer.officeHelper.Components;
import com.sun.star.wizards.tutorial.executer.officeHelper.XCellTextCompact;
import com.sun.star.wizards.tutorial.executer.officeHelper.XTabList;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.FindInterfaces;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import java.util.Hashtable;

public class Spreadsheet
extends Components
implements XCellTextCompact,
XTabList {
    private Helper m_helper;
    private static Spreadsheet m_spreadsheet;

    public Spreadsheet() {
        m_spreadsheet = this;
    }

    public Spreadsheet(Helper helper) throws Exception {
        if (helper == null) {
            throw new Exception("ERROR : Helper is not initialized.");
        }
        this.m_helper = helper;
    }

    public Helper getHelper() {
        return this.m_helper;
    }

    public void setHelper(Helper helper) {
        this.m_helper = helper;
    }

    public static Hashtable getInterfaces() {
        return FindInterfaces.getInterfaces(m_spreadsheet.getClass());
    }

    public void insertTexttoCell(String[] stringArray, int n, String string) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.insertCellTextHelper(xAccessibleContext, n, string);
    }

    public void moveMousetoCell_insertText(String[] stringArray, int n, String string) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.moveMouse_Click(xAccessibleContext);
        this.insertCellTextHelper(xAccessibleContext, n, string);
    }

    public void deleteCellText(String[] stringArray, int n, int n2) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.deleteCellTextHelper(xAccessibleContext, n, n2);
    }

    public void moveMousetoCell_deleteText(String[] stringArray, int n, int n2) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.moveMouse_Click(xAccessibleContext);
        this.deleteCellTextHelper(xAccessibleContext, n, n2);
    }

    public void replaceCellText(String[] stringArray, String string, String string2) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.replaceCellTextHelper(xAccessibleContext, string, string2);
    }

    public void replaceCellText(String[] stringArray, String string, int n, int n2) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.replaceCellTextHelper(xAccessibleContext, n, n2, string);
    }

    public void moveMousetoCell_replaceText(String[] stringArray, String string, String string2) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.moveMouse_Click(xAccessibleContext);
        this.replaceCellTextHelper(xAccessibleContext, string, string2);
    }

    public void moveMousetoCell_replaceText(String[] stringArray, String string, int n, int n2) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.moveMouse_Click(xAccessibleContext);
        this.replaceCellTextHelper(xAccessibleContext, n, n2, string);
    }

    public void setCellText(String[] stringArray, String string) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.replaceCellTextHelper(xAccessibleContext, 0, -1, string);
    }

    public void moveMousetoCell_setText(String[] stringArray, String string) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.moveMouse_Click(xAccessibleContext);
        this.replaceCellTextHelper(xAccessibleContext, 0, -1, string);
    }

    private void insertCellTextHelper(XAccessibleContext xAccessibleContext, int n, String string) {
        try {
            XCell xCell = this.getSelectedCell(xAccessibleContext);
            if (xCell != null) {
                this.insertTexttoCell(xCell, string, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteCellTextHelper(XAccessibleContext xAccessibleContext, int n, int n2) {
        try {
            XCell xCell = this.getSelectedCell(xAccessibleContext);
            if (xCell != null) {
                this.deleteTextfromCell(xCell, n, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void replaceCellTextHelper(XAccessibleContext xAccessibleContext, int n, int n2, String string) {
        try {
            XCell xCell = this.getSelectedCell(xAccessibleContext);
            if (xCell != null) {
                this.deleteTextfromCell(xCell, n, n2);
                this.insertTexttoCell(xCell, string, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void replaceCellTextHelper(XAccessibleContext xAccessibleContext, String string, String string2) {
        try {
            String string3;
            XCell xCell = this.getSelectedCell(xAccessibleContext);
            if (xCell != null && (string3 = xCell.getFormula()) != null && string != null && !string.equals("")) {
                int n = string3.length();
                int n2 = string3.indexOf(string);
                n = n2 + string.length();
                this.deleteTextfromCell(xCell, n2, n);
                this.insertTexttoCell(xCell, string2, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private XCell getSelectedCell(XAccessibleContext xAccessibleContext) throws Exception {
        XCell xCell = null;
        if (xAccessibleContext != null) {
            XInterface xInterface;
            int n = xAccessibleContext.getAccessibleIndexInParent();
            XAccessibleSelection xAccessibleSelection = AccessibilityTools.getXAccessibleSelection((XInterface)xAccessibleContext.getAccessibleParent());
            if (!xAccessibleSelection.isAccessibleChildSelected(n)) {
                xAccessibleSelection.selectAccessibleChild(n);
            }
            if ((xInterface = (XInterface)this.m_helper.getXModel().getCurrentSelection()) != null) {
                xCell = AccessibilityTools.getAccessibleCell(xInterface);
            }
        }
        return xCell;
    }

    private void deleteTextfromCell(XCell xCell, int n, int n2) throws Exception {
        block3: {
            String string;
            block2: {
                string = xCell.getFormula();
                if (n != 0 || n2 != -1) break block2;
                int n3 = 0;
                for (int i = string.length(); n3 <= i; --i) {
                    string = string.substring(n3, i);
                    xCell.setFormula(string);
                    this.sleep(this.getKeyDelay());
                }
                break block3;
            }
            if (string == null || string.length() <= 0 || n <= -1 || n2 <= n || n2 > string.length()) break block3;
            String string2 = string.substring(n, n2);
            String string3 = string.substring(0, n);
            String string4 = string.substring(n2, string.length());
            while (string2.length() > 0) {
                string2 = string2.substring(0, string2.length() - 1);
                xCell.setFormula(string3 + string2 + string4);
                this.sleep(this.getKeyDelay());
            }
        }
    }

    private void insertTexttoCell(XCell xCell, String string, int n) throws Exception {
        String string2 = xCell.getFormula();
        if (string2 != null) {
            if (n == -1) {
                n = string2.length();
            }
            if (n <= string2.length()) {
                String string3 = string2.substring(n, string2.length());
                String string4 = string2.substring(0, n);
                for (int i = 0; i < string.length(); ++i) {
                    string4 = string4 + string.charAt(i);
                    xCell.setFormula(string4 + string3);
                    this.sleep(this.getKeyDelay());
                }
            }
        }
    }

    static {
        new Spreadsheet();
    }
}

