/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XTopWindow;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.tutorial.executer.officeHelper.XAccessibility;
import com.sun.star.wizards.tutorial.executer.officeHelper.XControl;
import com.sun.star.wizards.tutorial.executer.officeHelper.XMoveMouseCompact;
import com.sun.star.wizards.tutorial.executer.officeHelper.XProperties;
import com.sun.star.wizards.tutorial.executer.officeHelper.XWindow;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.Control;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import com.sun.star.wizards.tutorial.executer.util.NameProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;

public abstract class Desktop
implements XControl,
XMoveMouseCompact,
XWindow,
XProperties,
XAccessibility {
    private static int MOUSE_SLEEP = 1500;
    private static String m_packageName = "com.sun.star.wizards.tutorial.executer.officeHelper";
    private static String m_docMethodName = "setHelper";

    public abstract Helper getHelper();

    public abstract void setHelper(Helper var1);

    public static Object createDocumentInstance(String string, Helper helper) {
        Object object = null;
        String string2 = string;
        try {
            Class<?> clazz;
            if (string2.indexOf(m_packageName) != 0) {
                string2 = m_packageName + "." + string2;
            }
            if ((object = (Object)(clazz = Class.forName(string2)).newInstance()) != null) {
                Class[] classArray = new Class[]{helper.getClass()};
                Class<?> clazz2 = object.getClass();
                Method method = clazz2.getMethod(m_docMethodName, classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{helper};
                    method.invoke(object, objectArray);
                } else {
                    object = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public void sleep(int n) {
        Control.sleep(n);
    }

    public void setDelay(int n, int n2, int n3, int n4, int n5) {
        MOUSE_SLEEP = n3;
        Control.setDelay(n, n2, n4, n5);
    }

    public void printSetDelayValues() {
        Helper.log("KeyMillis :" + this.getKeyDelay());
        Helper.log("MouseMillis :" + this.getMoveMouseDelay());
        Helper.log("MousesleepMillis :" + MOUSE_SLEEP);
        Helper.log("MouseScrollMillis :" + this.getMouseScrollDelay());
    }

    public int getMouseSleepDelay() {
        return MOUSE_SLEEP;
    }

    public int getKeyDelay() {
        return Control.getKeyDelay();
    }

    public int getMoveMouseDelay() {
        return Control.getMoveMouseDelay();
    }

    public int getMouseScrollDelay() {
        return Control.getMouseScrollDelay();
    }

    public void reset_Key_Mouse_Scroll_Delay() {
        Control.reset_Key_Mouse_Scroll_Delay();
    }

    public void resetMousePosition() {
        Control.resetMousePosition();
    }

    public void setMousePosition(int n, int n2) {
        Control.setMousePosition(n, n2);
    }

    public void mouseAnimate(int n, int n2) {
        Control.mouseAnimate(new int[]{n, n2});
    }

    public void mouseAnimate(int[] nArray) {
        Control.mouseAnimate(nArray);
    }

    public void moveMouse_Click(int n, int n2) {
        Control.mouseClick(new int[]{n, n2});
    }

    public void moveMouse_Click(int[] nArray) {
        Control.mouseClick(nArray);
    }

    public void moveMouse_Click(int[] nArray, String string) {
        Control.mouseClick(nArray, string);
    }

    public void moveMouse_Click(int[] nArray, String string, int n) {
        Control.mouseClick(nArray, string, n);
    }

    public void mouseScroll(String string, int n) {
        Control.mouseScroll(string, n);
    }

    public void mouseClick(int n) {
        Control.mouseClick(n);
    }

    public void mouseClick() {
        Control.mouseClick();
    }

    public void mouseClick(String string) {
        Control.mouseClick(string);
    }

    public void mouseClick(String string, int n) {
        Control.mouseClick(string, n);
    }

    public void key_Press_Release(char c) {
        Control.key_Press_Release(c);
    }

    public void key_Press_Release(int n) {
        Control.key_Press_Release(n);
    }

    public void setMouseAnimate(boolean bl) {
        Control.setMouseAnimate(bl);
    }

    public void printMouseAnimateStatus() {
        Helper.log("Mouse animate status :" + Control.getMouseAnimate());
    }

    public boolean getMouseAnimate() {
        return Control.getMouseAnimate();
    }

    public void printAllProperties(int n, String string, String string2) {
        try {
            AccessibilityTools.printAccessibleTree(AccessibilityTools.getXAccessible(this.getHelper().getTopWindows(), string, (short)n), string2);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    public void writeAllProperties(int n, String string, String string2, String string3) {
        try {
            AccessibilityTools.printAccessibleTree(AccessibilityTools.getXAccessible(this.getHelper().getTopWindows(), string, (short)n), string2, string3);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    public void windowToFront(String string) {
        try {
            int n = this.getWindowsNamesList().indexOf(string);
            if (n > -1) {
                this.windowToFront(n);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    public void printWindowsNames() {
        String[] stringArray = this.getWindowsNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Helper.log("Window name :" + stringArray[i]);
        }
    }

    public String[] getWindowsNames() {
        ArrayList arrayList = this.getWindowsNamesList();
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public ArrayList getWindowsNamesList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            XAccessible[] xAccessibleArray = AccessibilityTools.getXAccessibles(this.getHelper().getTopWindows());
            if (xAccessibleArray != null) {
                int n = xAccessibleArray.length;
                for (int i = 0; i < n; ++i) {
                    XAccessibleContext xAccessibleContext;
                    String string;
                    if (xAccessibleArray[i] == null || (string = (xAccessibleContext = xAccessibleArray[i].getAccessibleContext()).getAccessibleName().trim()) == null || string.equals("")) continue;
                    arrayList.add(string);
                }
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public XAccessibleContext checkShowing(XAccessibleContext xAccessibleContext) {
        if (xAccessibleContext != null && !AccessibilityTools.checkState(xAccessibleContext, (short)25)) {
            xAccessibleContext = this.checkShowing(xAccessibleContext.getAccessibleParent().getAccessibleContext());
        }
        return xAccessibleContext;
    }

    public void moveMousetoObject(String[] stringArray) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.moveMouse(xAccessibleContext, MOUSE_SLEEP);
    }

    public void moveMousetoObject_Time(String[] stringArray, int n) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.moveMouse(xAccessibleContext, n);
    }

    public void moveMousetoObject_Click(String[] stringArray) {
        this.moveMousetoObject_Click(stringArray, "LEFT", 0);
    }

    public void moveMousetoObject_Click(String[] stringArray, String string, int n) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.moveMouse_Click(xAccessibleContext, string, n, MOUSE_SLEEP);
    }

    public void moveMousetoObject_Click_Time(String[] stringArray, int n) {
        this.moveMousetoObject_Click_Time(stringArray, "LEFT", 0, n);
    }

    public void moveMousetoObject_Click_Time(String[] stringArray, String string, int n, int n2) {
        XAccessibleContext xAccessibleContext = this.getXAccessibleContext(stringArray);
        this.moveMouse_Click(xAccessibleContext, string, n, n2);
    }

    protected void moveMouse_Click(XAccessibleContext xAccessibleContext) {
        this.moveMouse_Click(xAccessibleContext, "LEFT", 0, 0);
    }

    protected void moveMouse_Click(XAccessibleContext xAccessibleContext, int n) {
        this.moveMouse_Click(xAccessibleContext, "LEFT", 0, n);
    }

    protected void moveMouse(XAccessibleContext xAccessibleContext, int n) {
        if (xAccessibleContext != null && (xAccessibleContext = this.checkShowing(xAccessibleContext)) != null) {
            int[] nArray = AccessibilityTools.getPoints((XInterface)xAccessibleContext);
            if (xAccessibleContext.getAccessibleRole() == 36) {
                Control.setAnimateStyle("MENU");
            }
            String string = Control.mouseAnimate(nArray);
            Control.setAnimateStyle("LINE");
            if (string.equals("done")) {
                this.sleep(n);
            }
        }
    }

    protected void moveMouse_Click(XAccessibleContext xAccessibleContext, String string, int n, int n2) {
        if (xAccessibleContext != null && (xAccessibleContext = this.checkShowing(xAccessibleContext)) != null) {
            int[] nArray = AccessibilityTools.getPoints((XInterface)xAccessibleContext);
            if (xAccessibleContext.getAccessibleRole() == 36) {
                Control.setAnimateStyle("MENU");
            }
            String string2 = Control.mouseClick(nArray, string, n);
            Control.setAnimateStyle("LINE");
            if (string2.equals("done")) {
                this.sleep(n2);
            }
        }
    }

    public XAccessibleContext getXAccessibleContext(String[] stringArray) {
        XAccessibleContext xAccessibleContext = null;
        try {
            xAccessibleContext = AccessibilityTools.getXAccessibleContext(this.getHelper().getActiveTopWindow(), this.getHelper().getTopWindows(), stringArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return xAccessibleContext;
    }

    public String[] getLocalisationPath(XAccessibleContext xAccessibleContext) {
        String[] stringArray = null;
        try {
            Vector vector;
            if (xAccessibleContext != null && (vector = this.findPath(xAccessibleContext)) != null) {
                stringArray = vector.toArray(new String[vector.size()]);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    private void windowToFront(int n) throws com.sun.star.uno.Exception {
        XTopWindow xTopWindow = this.getHelper().getTopWindow(n);
        xTopWindow.toFront();
    }

    private Vector findPath(XAccessibleContext xAccessibleContext) throws com.sun.star.uno.Exception {
        if (xAccessibleContext == null) {
            return null;
        }
        String string = "";
        string = xAccessibleContext.getAccessibleRole() == 41 ? NameProvider.getRoleName(xAccessibleContext.getAccessibleRole()) + "#" + "Paragraph:" + xAccessibleContext.getAccessibleIndexInParent() + "#" : NameProvider.getRoleName(xAccessibleContext.getAccessibleRole()) + "#" + xAccessibleContext.getAccessibleName() + "#";
        if (xAccessibleContext.getAccessibleIndexInParent() > -1) {
            Vector vector = this.findPath(xAccessibleContext.getAccessibleParent().getAccessibleContext());
            if (vector != null) {
                string = string + xAccessibleContext.getAccessibleIndexInParent();
                vector.add(string);
            }
            return vector;
        }
        Vector<String> vector = new Vector<String>();
        int n = AccessibilityTools.getXWindowIndex(this.getHelper().getTopWindows(), xAccessibleContext.getAccessibleName(), xAccessibleContext.getAccessibleRole());
        string = xAccessibleContext.getAccessibleRole() == 21 && xAccessibleContext.getAccessibleName().equals(this.getHelper().getCurrentDocumentTitle()) ? "{D}" + string + n : string + n;
        vector.add(string);
        return vector;
    }
}

