/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.executer;

import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XKeyHandler;
import com.sun.star.beans.NamedValue;
import com.sun.star.wizards.tutorial.executer.CallKeyHandler;
import com.sun.star.wizards.tutorial.executer.ExecuteMethod;
import com.sun.star.wizards.tutorial.executer.LocalisationCache;
import com.sun.star.wizards.tutorial.executer.officeHelper.Desktop;
import com.sun.star.wizards.tutorial.executer.officeHelper.XAccessibility;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.Control;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import com.sun.star.wizards.tutorial.executer.util.URLDispatcher;
import java.util.Vector;

public class ExecuteCache
extends Thread {
    public Vector commandsPool = new Vector();
    public static boolean m_localisation = false;
    public static Vector m_localisationPaths = new Vector();
    private XExtendedToolkit m_exToolkit = null;
    private Helper m_helper = null;
    private CallKeyHandler m_keyHandler = new CallKeyHandler();

    public ExecuteCache(Helper helper) {
        try {
            this.m_exToolkit = helper.getXExtendedToolkit();
            this.m_helper = helper;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run() {
        try {
            while (true) {
                if (this.commandsPool.size() > 0 && !this.isInterrupted()) {
                    this.commands();
                    continue;
                }
                this.gotoSleep();
                if (this.isInterrupted()) break;
            }
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeThread() {
        if (this.isAlive()) {
            ExecuteCache executeCache = this;
            synchronized (executeCache) {
                this.interrupt();
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waken() {
        ExecuteCache executeCache = this;
        synchronized (executeCache) {
            try {
                this.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotoSleep() {
        ExecuteCache executeCache = this;
        synchronized (executeCache) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        boolean bl = false;
        ExecuteCache executeCache = this;
        synchronized (executeCache) {
            try {
                bl = this.isActive();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public synchronized void put(NamedValue[] namedValueArray) {
        boolean bl = this.commandsPool.isEmpty();
        this.commandsPool.add(namedValueArray);
        if (bl) {
            this.waken();
        }
    }

    private synchronized void commands() {
        while (!this.commandsPool.isEmpty()) {
            NamedValue[] namedValueArray = (NamedValue[])this.commandsPool.get(0);
            this.commandsPool.remove(0);
            this.execute(namedValueArray);
        }
    }

    public static synchronized Vector getLocalisationPaths() {
        return m_localisationPaths;
    }

    private synchronized void execute(NamedValue[] namedValueArray) {
        Vector<Object> vector;
        block22: {
            Control.setBreakControl(false);
            vector = new Vector<Object>();
            this.addKeyHandler(this.m_keyHandler);
            if (!m_localisation) {
                this.dispatchTutorialDialog("macro:///Tutorials.Functions.SetVisibleFalse()");
                this.dispatchTutorialDialog("macro:///Tutorials.ShowInfoDialog.ShowON()");
            }
            try {
                for (int i = 1; i < namedValueArray.length; ++i) {
                    NamedValue namedValue;
                    Helper.log(" ***************************************************************");
                    NamedValue[] namedValueArray2 = (NamedValue[])namedValueArray[i].Value;
                    Object object = null;
                    String string = "";
                    String[] stringArray = null;
                    Vector<Object> vector2 = new Vector<Object>();
                    int n = namedValueArray2.length;
                    for (int j = 0; j < n; ++j) {
                        namedValue = namedValueArray2[j];
                        if (namedValue.Name.equals("DocumentTYP")) {
                            String string2 = (String)namedValue.Value;
                            object = Desktop.createDocumentInstance(string2, this.m_helper);
                            continue;
                        }
                        if (namedValue.Name.equals("MethodName")) {
                            string = (String)namedValue.Value;
                            continue;
                        }
                        if (namedValue.Name.equals("Path")) {
                            stringArray = (String[])namedValue.Value;
                            continue;
                        }
                        if (!namedValue.Name.equals("Param")) continue;
                        vector2.add(namedValue.Value);
                    }
                    if (object != null && !string.equals("")) {
                        if (AccessibilityTools.getSearchForm().equals("INDEX")) {
                            this.waitTopWindow((short)64);
                        }
                        if (m_localisation) {
                            try {
                                ExecuteCache.sleep(1000L);
                                AccessibilityTools.setSearchForm("INDEX");
                                XAccessibility xAccessibility = (XAccessibility)object;
                                this.checkExecutePath(stringArray);
                                namedValue = xAccessibility.getXAccessibleContext(stringArray);
                                if (namedValue == null) break;
                                stringArray = xAccessibility.getLocalisationPath((XAccessibleContext)namedValue);
                                if (stringArray != null) {
                                    int n2 = vector.size();
                                    vector.add(n2, stringArray.clone());
                                    ExecuteMethod.instanceMethodExecute(object, string, stringArray, vector2);
                                }
                            }
                            catch (Exception exception) {}
                        } else {
                            ExecuteMethod.instanceMethodExecute(object, string, stringArray, vector2);
                        }
                    }
                    if (!Control.getBreakControl()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (!Helper.getLogState()) break block22;
                exception.printStackTrace();
            }
        }
        if (m_localisation && !Control.getBreakControl()) {
            if (!vector.isEmpty()) {
                m_localisationPaths.add(vector);
            }
        } else if (!m_localisation) {
            this.dispatchTutorialDialog("macro:///Tutorials.ShowInfoDialog.ShowOFF()");
            this.dispatchTutorialDialog("macro:///Tutorials.Functions.SetVisibleTrue()");
            if (!Control.getBreakControl()) {
                this.dispatchTutorialDialog("macro:///Tutorials.Functions.SetDisableShowMeButton()");
            }
        }
        Control.setBreakControl(false);
        this.removeKeyHandler(this.m_keyHandler);
        if (m_localisation) {
            LocalisationCache.waken();
        }
    }

    private void checkExecutePath(String[] stringArray) {
        String string;
        String string2 = stringArray[0].trim();
        String[] stringArray2 = string2.split("#", 3);
        if (stringArray2.length == 3 && (string = stringArray2[0].trim()).indexOf("{D}") > -1) {
            string = string.substring("{D}".length());
            stringArray[0] = string + "#" + stringArray2[1].trim() + "#" + stringArray2[2].trim();
        }
    }

    private void waitTopWindow(short s) {
        try {
            while (AccessibilityTools.isTopWindowActive(this.m_helper.getTopWindows(), s)) {
                ExecuteCache.sleep(1000L);
                Helper.log(" is active : true");
            }
        }
        catch (com.sun.star.uno.Exception exception) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Helper.log(" is active : false");
    }

    private synchronized void addKeyHandler(CallKeyHandler callKeyHandler) {
        this.m_exToolkit.addKeyHandler((XKeyHandler)callKeyHandler);
    }

    private synchronized void removeKeyHandler(CallKeyHandler callKeyHandler) {
        this.m_exToolkit.removeKeyHandler((XKeyHandler)callKeyHandler);
    }

    public void dispatchTutorialDialog(String string) {
        try {
            URLDispatcher.dispatch_Thread(this.m_helper.getXFrame(), string, "_self", 0, null);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }
}

