/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.IAccessibleObjectDisplay;
import com.sun.star.wizards.tutorial.executer.util.NameProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class TextualDisplay
extends JPanel
implements IAccessibleObjectDisplay {
    private JTextArea maText = new JTextArea();
    private final String msIndentation = "  ";
    private String msTextContent = "";
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;

    public TextualDisplay() {
        this.maText.setBackground(new Color(250, 240, 230));
        this.maText.setFont(new Font("Courier", 0, 11));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this.maText, null);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    public synchronized void setAccessibleObject(XAccessibleContext xAccessibleContext) {
        this.msTextContent = "";
        if (xAccessibleContext != null) {
            String string = this.showParents(xAccessibleContext);
            this.showContextInfo(xAccessibleContext, string);
            this.showComponentInfo(xAccessibleContext, string);
        }
        this.maText.setText(this.msTextContent);
    }

    public synchronized void updateAccessibleObject(XAccessibleContext xAccessibleContext) {
        this.setAccessibleObject(xAccessibleContext);
    }

    private void showContextInfo(XAccessibleContext xAccessibleContext, String string) {
        this.msTextContent = this.msTextContent + string + "Description: " + xAccessibleContext.getAccessibleDescription() + "\n";
        this.showStates(xAccessibleContext, string);
    }

    private void showStates(XAccessibleContext xAccessibleContext, String string) {
        XAccessibleStateSet xAccessibleStateSet = xAccessibleContext.getAccessibleStateSet();
        short[] sArray = xAccessibleStateSet.getStates();
        this.msTextContent = this.msTextContent + string + "States     : ";
        for (int i = 0; i < sArray.length; ++i) {
            if (i > 0) {
                this.msTextContent = this.msTextContent + ", ";
            }
            this.msTextContent = this.msTextContent + NameProvider.getStateName(sArray[i]);
        }
        this.msTextContent = this.msTextContent + "\n";
    }

    private void showComponentInfo(XAccessibleContext xAccessibleContext, String string) {
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = TextualDisplay.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent), (Object)xAccessibleContext);
        if (xAccessibleComponent != null) {
            Point point = xAccessibleComponent.getLocationOnScreen();
            this.msTextContent = this.msTextContent + string + "Position   : " + point.X + ", " + point.Y + "\n";
            Size size = xAccessibleComponent.getSize();
            this.msTextContent = this.msTextContent + string + "Size       : " + size.Width + ", " + size.Height + "\n";
        }
    }

    private String showParents(XAccessibleContext xAccessibleContext) {
        String string;
        Vector<XAccessibleContext> vector = new Vector<XAccessibleContext>();
        while (xAccessibleContext != null) {
            vector.add(xAccessibleContext);
            try {
                string = xAccessibleContext.getAccessibleParent();
                if (string != null) {
                    xAccessibleContext = string.getAccessibleContext();
                    continue;
                }
                xAccessibleContext = null;
            }
            catch (Exception exception) {
                System.err.println("caught exception " + exception + " while getting path to root");
            }
        }
        string = "";
        for (int i = vector.size() - 1; i >= 0; --i) {
            XAccessibleContext xAccessibleContext2 = (XAccessibleContext)vector.get(i);
            String string2 = xAccessibleContext2.getAccessibleName();
            short s = xAccessibleContext2.getAccessibleRole();
            String string3 = "";
            if (s == 41) {
                string3 = "Role : " + NameProvider.getRoleName(s) + " / Name : Paragraph:" + xAccessibleContext2.getAccessibleIndexInParent();
            } else {
                string3 = "Role : " + NameProvider.getRoleName(s) + " / Name : " + string2;
                if (string2.length() == 0) {
                    string3 = string3 + "<unnamed>";
                }
            }
            this.msTextContent = this.msTextContent + string + string3 + "\n";
            string = string + "  ";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

