/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import com.sun.star.wizards.tutorial.creator.frame.objectFinder.ActionFrame;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.TableColumModel;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.TableModel;
import com.sun.star.wizards.tutorial.executer.officeHelper.DesktopDialog;
import com.sun.star.wizards.tutorial.executer.officeHelper.DesktopMenu;
import com.sun.star.wizards.tutorial.executer.officeHelper.Presentation_Drawing;
import com.sun.star.wizards.tutorial.executer.officeHelper.Spreadsheet;
import com.sun.star.wizards.tutorial.executer.officeHelper.TextDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class MethodDialog
extends JDialog {
    private JTable m_table;
    private JList m_list;
    private String m_classTyp;
    private String m_path;
    private Hashtable m_methods;
    private static final Hashtable m_docsMethods;
    private static final Object[] m_columnIdentifiers;
    private ActionFrame m_actionFrame;

    public MethodDialog(ActionFrame actionFrame) {
        super(actionFrame);
        this.m_actionFrame = actionFrame;
        this.init();
    }

    private void init() {
        this.setBounds(200, 70, 470, 500);
        this.setTitle("Methods");
        this.setModal(true);
        this.m_list = new JList();
        this.m_list.setModel(new DefaultComboBoxModel());
        this.m_list.setSelectionMode(0);
        this.m_list.setBackground(new Color(255, 250, 240));
        JScrollPane jScrollPane = new JScrollPane(this.m_list);
        jScrollPane.setPreferredSize(new Dimension(200, 40));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Methods");
        jScrollPane.setBorder(titledBorder);
        this.m_table = new JTable(new TableModel());
        this.m_table.setBackground(new Color(255, 250, 240));
        this.m_table.setColumnModel(new TableColumModel(1));
        this.m_table.setAutoResizeMode(0);
        JScrollPane jScrollPane2 = new JScrollPane();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Method and Params");
        jScrollPane2.setBorder(titledBorder2);
        jScrollPane2.getViewport().add((Component)this.m_table, null);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 6, 5));
        JButton jButton = new JButton("Ok");
        jPanel.add((Component)jButton, "East");
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerSize(15);
        jSplitPane.setDividerLocation(150);
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add((Component)jSplitPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (MethodDialog.this.m_list.getSelectedIndex() > -1 && !listSelectionEvent.getValueIsAdjusting()) {
                    MethodDialog.this.updateTable();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Vector vector = MethodDialog.this.getDataVector();
                if (vector != null && !vector.isEmpty()) {
                    for (int i = 0; i < vector.size(); ++i) {
                        Vector vector2 = (Vector)vector.get(i);
                        if (!((String)vector2.get(1)).equals("")) continue;
                        JOptionPane.showMessageDialog(MethodDialog.this.m_actionFrame, "Please insert all values!", "Insert Error", 0);
                        return;
                    }
                    MethodDialog.this.m_actionFrame.addAction();
                    MethodDialog.this.dispose();
                }
            }
        });
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
    }

    public void initMethodDialog(String string, String string2) {
        this.m_path = string;
        if (this.m_path.length() > 0 && this.m_path.lastIndexOf(";") == this.m_path.length() - 1) {
            this.m_path = this.m_path.substring(0, this.m_path.length() - 1);
        }
        this.m_classTyp = string2;
        this.initListData();
        this.removeAllTableData();
    }

    private void initListData() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.m_list.getModel();
        if (defaultComboBoxModel.getSize() > 0) {
            defaultComboBoxModel.removeAllElements();
        }
        String string = this.m_classTyp;
        if (this.m_classTyp.equals("PresentationDocument") || this.m_classTyp.equals("DrawingDocument")) {
            string = "Pres_Draw";
        }
        this.m_methods = (Hashtable)m_docsMethods.get(string);
        if (this.m_methods != null) {
            Enumeration enumeration = this.m_methods.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)enumeration.nextElement();
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    String string2 = (String)enumeration2.nextElement();
                    defaultComboBoxModel.addElement(string2);
                }
            }
        }
    }

    private void removeAllTableData() {
        TableModel tableModel = (TableModel)this.m_table.getModel();
        for (int i = tableModel.getRowCount() - 1; i > -1; --i) {
            tableModel.removeRow(i);
        }
    }

    private void updateTable() {
        this.m_list.getSelectedIndex();
        String string = (String)this.m_list.getSelectedValue();
        Object[][] objectArray = null;
        if (this.m_methods != null) {
            Object object = this.m_methods.elements();
            while (object.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)object.nextElement();
                if (!hashtable.containsKey(string)) continue;
                objectArray = (Object[][])hashtable.get(string);
            }
            object = (TableModel)this.m_table.getModel();
            for (int i = ((DefaultTableModel)object).getRowCount() - 1; i > -1; --i) {
                ((DefaultTableModel)object).removeRow(i);
            }
            if (objectArray != null) {
                objectArray[0][1] = this.m_classTyp;
                if (objectArray.length > 2 && objectArray[2][0].equals("path")) {
                    objectArray[2][1] = "Path=" + this.m_path;
                }
                ((DefaultTableModel)object).setDataVector(objectArray, m_columnIdentifiers);
            }
        }
    }

    public Vector getDataVector() {
        TableModel tableModel = (TableModel)this.m_table.getModel();
        return (Vector)tableModel.getDataVector().clone();
    }

    static {
        m_columnIdentifiers = new Object[]{"Name", "Value"};
        Hashtable hashtable = DesktopMenu.getInterfaces();
        Hashtable hashtable2 = TextDocument.getInterfaces();
        Hashtable hashtable3 = Presentation_Drawing.getInterfaces();
        Hashtable hashtable4 = DesktopDialog.getInterfaces();
        Hashtable hashtable5 = Spreadsheet.getInterfaces();
        m_docsMethods = new Hashtable();
        m_docsMethods.put("DesktopMenu", hashtable);
        m_docsMethods.put("TextDocument", hashtable2);
        m_docsMethods.put("Pres_Draw", hashtable3);
        m_docsMethods.put("DesktopDialog", hashtable4);
        m_docsMethods.put("SpreadsheetDocument", hashtable5);
    }
}

