/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.IAccessibleObjectDisplay;
import com.sun.star.wizards.tutorial.executer.util.NameProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

class MenuFactory {
    private IAccessibleObjectDisplay mDisplay;
    private static final int mnMenuBarRole = 35;
    private static final int mnMenuRole = 34;
    private static final int mnMenuItemRole = 36;
    private static final int mnSeparator = 53;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessible;

    public MenuFactory(IAccessibleObjectDisplay iAccessibleObjectDisplay) {
        this.mDisplay = iAccessibleObjectDisplay;
    }

    public JMenuBar GetJMenuBar(XExtendedToolkit xExtendedToolkit) {
        JMenuBar jMenuBar = null;
        if (xExtendedToolkit != null) {
            int n = xExtendedToolkit.getTopWindowCount();
            try {
                for (int i = 0; i < n; ++i) {
                    XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessible == null ? MenuFactory.class$("com.sun.star.accessibility.XAccessible") : class$com$sun$star$accessibility$XAccessible), (Object)xExtendedToolkit.getTopWindow(i));
                    XAccessible xAccessible2 = this.GetMenu(xAccessible);
                    if (xAccessible2 == null) continue;
                    jMenuBar = this.CreateJMenuBar(xAccessible2);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return jMenuBar;
    }

    private XAccessible GetMenu(XAccessible xAccessible) {
        XAccessibleContext xAccessibleContext;
        XAccessible xAccessible2 = null;
        short s = 35;
        if (xAccessible != null && (xAccessibleContext = xAccessible.getAccessibleContext()) != null) {
            if (xAccessibleContext.getAccessibleRole() == s) {
                xAccessible2 = xAccessible;
            } else {
                try {
                    for (int i = 0; i < xAccessibleContext.getAccessibleChildCount() && (xAccessible2 = this.GetMenu(xAccessibleContext.getAccessibleChild(i))) == null; ++i) {
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return xAccessible2;
    }

    private JMenuBar CreateJMenuBar(XAccessible xAccessible) {
        XAccessibleContext xAccessibleContext;
        JMenuBar jMenuBar = new JMenuBar();
        if (xAccessible != null && (xAccessibleContext = xAccessible.getAccessibleContext()) != null) {
            try {
                for (int i = 0; i < xAccessibleContext.getAccessibleChildCount(); ++i) {
                    JMenu jMenu = this.CreateJMenu(xAccessibleContext.getAccessibleChild(i));
                    if (jMenu == null) continue;
                    jMenuBar.add(jMenu);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return jMenuBar;
    }

    private JMenu CreateJMenu(XAccessible xAccessible) {
        XAccessibleContext xAccessibleContext;
        JMenu jMenu = null;
        if (xAccessible != null && (xAccessibleContext = xAccessible.getAccessibleContext()) != null) {
            jMenu = new JMenu(xAccessibleContext.getAccessibleName());
            jMenu.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    MenuFactory.this.mDisplay.setAccessibleObject(xAccessibleContext);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            try {
                for (int i = 0; i < xAccessibleContext.getAccessibleChildCount(); ++i) {
                    XAccessibleContext xAccessibleContext2;
                    XAccessible xAccessible2 = xAccessibleContext.getAccessibleChild(i);
                    if (xAccessible2 == null || (xAccessibleContext2 = xAccessible2.getAccessibleContext()) == null) continue;
                    JMenuItem jMenuItem = null;
                    switch (xAccessibleContext2.getAccessibleRole()) {
                        case 34: {
                            jMenuItem = this.CreateJMenu(xAccessible2);
                            break;
                        }
                        case 36: {
                            jMenuItem = this.CreateJMenuItem(xAccessible2);
                            break;
                        }
                        case 53: {
                            jMenuItem = null;
                            jMenu.addSeparator();
                            break;
                        }
                        default: {
                            jMenuItem = new JMenuItem(xAccessibleContext2.getAccessibleName() + " / " + NameProvider.getRoleName(xAccessibleContext2.getAccessibleRole()));
                        }
                    }
                    if (jMenuItem == null) continue;
                    jMenu.add((Component)jMenuItem);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return jMenu;
    }

    private JMenuItem CreateJMenuItem(XAccessible xAccessible) {
        JMenuItem jMenuItem = null;
        if (xAccessible != null) {
            final XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
            jMenuItem = new JMenuItem(new AbstractAction(xAccessibleContext.getAccessibleName()){

                public void actionPerformed(ActionEvent actionEvent) {
                    MenuFactory.this.mDisplay.setAccessibleObject(xAccessibleContext);
                }
            });
        }
        return jMenuItem;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

