/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.lang.DisposedException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.IAccessibleObjectDisplay;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JPanel;

public class GraphicalDisplay
extends JPanel
implements IAccessibleObjectDisplay {
    private XAccessibleContext mxContext;
    private double mnScale;
    private double mnHOffset;
    private double mnVOffset;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;

    public synchronized void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.setupTransformation();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        graphics.setColor(new Color(250, 240, 230));
        graphics.fillRect((int)(this.mnHOffset + 0.5), (int)(this.mnVOffset + 0.5), (int)(this.mnScale * dimension.getWidth()), (int)(this.mnScale * dimension.getHeight()));
        graphics.setColor(Color.BLACK);
        graphics.drawRect((int)(this.mnHOffset + 0.5), (int)(this.mnVOffset + 0.5), (int)(this.mnScale * dimension.getWidth()), (int)(this.mnScale * dimension.getHeight()));
        this.drawAccessibleObject(graphics, this.mxContext, Color.GREEN);
    }

    public synchronized void paintChildren(Graphics graphics) {
    }

    public synchronized void paintBorder(Graphics graphics) {
    }

    public void drawAccessibleObject(Graphics graphics, XAccessibleContext xAccessibleContext, Color color) {
        try {
            if (xAccessibleContext != null) {
                XAccessibleComponent xAccessibleComponent;
                XAccessible xAccessible = xAccessibleContext.getAccessibleParent();
                if (xAccessible != null) {
                    this.drawAccessibleObject(graphics, xAccessible.getAccessibleContext(), Color.GRAY);
                }
                if ((xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = GraphicalDisplay.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent), (Object)xAccessibleContext)) != null) {
                    Point point = xAccessibleComponent.getLocationOnScreen();
                    Size size = xAccessibleComponent.getSize();
                    graphics.setColor(color);
                    graphics.drawRect((int)(this.mnHOffset + this.mnScale * (double)point.X + 0.5), (int)(this.mnVOffset + this.mnScale * (double)point.Y + 0.5), (int)(this.mnScale * (double)size.Width), (int)(this.mnScale * (double)size.Height));
                }
            }
        }
        catch (DisposedException disposedException) {
            // empty catch block
        }
    }

    public synchronized void setAccessibleObject(XAccessibleContext xAccessibleContext) {
        this.mxContext = xAccessibleContext;
        this.repaint();
    }

    public synchronized void updateAccessibleObject(XAccessibleContext xAccessibleContext) {
        this.mxContext = xAccessibleContext;
        this.repaint();
    }

    private void setupTransformation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension.getWidth() > 0.0 && dimension.getHeight() > 0.0) {
            double d;
            double d2 = (dimension2.getWidth() - 10.0) / dimension.getWidth();
            this.mnScale = d2 < (d = (dimension2.getHeight() - 10.0) / dimension.getHeight()) ? d2 : d;
            this.mnHOffset = (dimension2.getWidth() - this.mnScale * dimension.getWidth()) / 2.0;
            this.mnVOffset = (dimension2.getHeight() - this.mnScale * dimension.getHeight()) / 2.0;
        } else {
            this.mnScale = 1.0;
            this.mnHOffset = 0.0;
            this.mnVOffset = 0.0;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

