/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.lang.DisposedException;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.AccessibleObjectFind;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.ActionPanel;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.GraphicalDisplay;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.IAccessibleObjectDisplay;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.MenuFactory;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.MethodDialog;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.TextualDisplay;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.XFramework;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import com.sun.star.wizards.tutorial.executer.util.NameProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;

public class ActionFrame
extends JFrame
implements IAccessibleObjectDisplay {
    private XExtendedToolkit m_XToolkit;
    private static ActionFrame m_actionFrame;
    private XAccessibleContext m_xaccessContext;
    private String m_classTyp;
    private AccessibleObjectFind m_xaccessOF;
    private MethodDialog m_methodDialog;
    private ActionPanel m_actinPanel;
    private XFramework m_frame;
    private TextualDisplay maTextualDisplay;
    private GraphicalDisplay maGraphicalDisplay;

    public ActionFrame(XFramework xFramework) {
        this.m_frame = xFramework;
        m_actionFrame = this;
        this.m_classTyp = xFramework.getConnectedDocumentTyp();
        this.m_XToolkit = xFramework.getXExtendedToolkit();
        this.m_xaccessOF = new AccessibleObjectFind(this.m_XToolkit);
        this.m_methodDialog = new MethodDialog(m_actionFrame);
        this.init();
    }

    private void init() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setBounds(200, 70, 600, 600);
        this.setTitle("StarOffice object finder");
        this.maTextualDisplay = new TextualDisplay();
        this.maGraphicalDisplay = new GraphicalDisplay();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Focused Object:");
        jPanel2.setPreferredSize(new Dimension(300, 100));
        jPanel2.setBorder(titledBorder);
        jPanel2.add(this.maTextualDisplay);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Graphical:");
        jPanel3.setPreferredSize(new Dimension(300, 200));
        jPanel3.setBorder(titledBorder2);
        jPanel3.add(this.maGraphicalDisplay);
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setDividerLocation(270);
        jSplitPane.setLeftComponent(jPanel2);
        jSplitPane.setRightComponent(jPanel3);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerSize(15);
        JButton jButton = new JButton("Cancel");
        JButton jButton2 = new JButton("Ok");
        JButton jButton3 = new JButton("Get MenuBar");
        final JButton jButton4 = new JButton("Press and release over office application");
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 6));
        jPanel4.add(jButton2);
        jPanel4.add(jButton);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel5.add((Component)jButton4, "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        jPanel6.add((Component)jButton3, "Center");
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add((Component)jPanel4, "East");
        jPanel7.add((Component)jPanel5, "Center");
        jPanel7.add((Component)jPanel6, "West");
        this.m_actinPanel = new ActionPanel(m_actionFrame);
        jPanel.add((Component)jSplitPane, "North");
        jPanel.add((Component)this.m_actinPanel, "Center");
        jPanel.add((Component)jPanel7, "South");
        this.setDefaultMenuBar();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionFrame.this.m_frame.addActionstoStep(ActionFrame.this.m_actinPanel.getDataVector());
                ActionFrame.this.setDefaultMenuBar();
                ActionFrame.this.m_frame.showStepFrame(ActionFrame.this.getBounds());
                ActionFrame.this.dispose();
                ActionFrame.this.initActionFrame();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuFactory menuFactory = new MenuFactory(m_actionFrame);
                JMenuBar jMenuBar = menuFactory.GetJMenuBar(ActionFrame.this.m_XToolkit);
                ActionFrame.this.setJMenuBar(jMenuBar);
                jMenuBar = ActionFrame.this.getJMenuBar();
                jMenuBar.updateUI();
            }
        });
        jButton4.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Component component = mouseEvent.getComponent();
                n += component.getX();
                n2 += component.getY();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                XAccessible xAccessible;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                boolean bl = false;
                for (Component component = mouseEvent.getComponent(); component != null; component = component.getParent()) {
                    if (component == jButton4) {
                        bl = true;
                    }
                    n += component.getX();
                    n2 += component.getY();
                }
                if (bl && (xAccessible = ActionFrame.this.m_xaccessOF.findAccessibleObject(n, n2)) != null) {
                    ActionFrame.this.setAccessibleObject(xAccessible.getAccessibleContext());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionFrame.this.setDefaultMenuBar();
                ActionFrame.this.dispose();
                ActionFrame.this.initActionFrame();
                ActionFrame.this.m_frame.showStepFrame(ActionFrame.this.getBounds());
            }
        });
    }

    private XAccessible getVisibleAccessible(XAccessible xAccessible) {
        if (xAccessible != null) {
            if (AccessibilityTools.checkState(xAccessible.getAccessibleContext(), (short)25)) {
                return xAccessible;
            }
            this.getVisibleAccessible(xAccessible.getAccessibleContext().getAccessibleParent());
        }
        return null;
    }

    public void setDefaultMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenuItem jMenuItem = new JMenuItem("Office MenuBar");
        jMenuItem.setEnabled(false);
        jMenuBar.add(jMenuItem);
        this.setJMenuBar(jMenuBar);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.dispose();
            this.m_frame.showStepFrame(this.getBounds());
        }
    }

    public void setAccessibleObject(XAccessibleContext xAccessibleContext) {
        if (xAccessibleContext != null) {
            this.m_xaccessContext = xAccessibleContext;
            this.maTextualDisplay.setAccessibleObject(xAccessibleContext);
            this.maGraphicalDisplay.setAccessibleObject(xAccessibleContext);
            this.m_actinPanel.action.setEnabled(true);
        } else {
            this.m_actinPanel.setButtonsProperties();
        }
    }

    public void updateAccessibleObject(XAccessibleContext xAccessibleContext) {
        if (xAccessibleContext != null) {
            this.m_xaccessContext = xAccessibleContext;
        }
        this.maTextualDisplay.updateAccessibleObject(xAccessibleContext);
        this.maGraphicalDisplay.updateAccessibleObject(xAccessibleContext);
    }

    public void initActionFrame() {
        this.m_xaccessContext = null;
        this.updateAccessibleObject(null);
        this.m_actinPanel.initTable();
        this.m_actinPanel.action.setEnabled(false);
        this.m_actinPanel.setButtonsProperties();
    }

    public boolean isAccessibleObjectFound() {
        return this.m_xaccessContext != null;
    }

    private String[] getAccessibleObjProperties() {
        String[] stringArray = new String[2];
        String string = "";
        stringArray[1] = this.m_classTyp;
        try {
            XAccessibleContext xAccessibleContext = this.m_xaccessContext;
            while (xAccessibleContext != null) {
                if (xAccessibleContext.getAccessibleRole() == 41) {
                    string = NameProvider.getRoleName(xAccessibleContext.getAccessibleRole()) + "#Paragraph:" + xAccessibleContext.getAccessibleIndexInParent() + "#" + xAccessibleContext.getAccessibleIndexInParent() + ";" + string;
                } else if (xAccessibleContext.getAccessibleIndexInParent() == -1) {
                    int n = -1;
                    short s = xAccessibleContext.getAccessibleRole();
                    String string2 = xAccessibleContext.getAccessibleName();
                    try {
                        n = AccessibilityTools.getXWindowIndex(Helper.getTopWindows(this.m_XToolkit), string2, s);
                    }
                    catch (com.sun.star.uno.Exception exception) {
                        // empty catch block
                    }
                    if (stringArray[1] == "DesktopMenu" && string.split("MENU").length > 3) {
                        n += string.split("MENU").length - 3;
                    }
                    string = s == 21 && string2.equals(this.m_frame.getConnectedDocumentTitle()) ? "{D}" + NameProvider.getRoleName(s) + "#" + string2 + "#" + n + ";" + string : NameProvider.getRoleName(s) + "#" + string2 + "#" + n + ";" + string;
                } else {
                    try {
                        Helper.log("GET child ROLE & NAME : " + xAccessibleContext.getAccessibleRole() + " & " + xAccessibleContext.getAccessibleName());
                        Helper.log("GET child INDEX : " + xAccessibleContext.getAccessibleIndexInParent());
                        Helper.log("**************************************");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string = NameProvider.getRoleName(xAccessibleContext.getAccessibleRole()) + "#" + xAccessibleContext.getAccessibleName() + "#" + xAccessibleContext.getAccessibleIndexInParent() + ";" + string;
                }
                if (xAccessibleContext.getAccessibleRole() == 35) {
                    stringArray[1] = "DesktopMenu";
                } else if (xAccessibleContext.getAccessibleRole() == 12) {
                    stringArray[1] = "DesktopDialog";
                }
                if (xAccessibleContext.getAccessibleParent() == null || xAccessibleContext.getAccessibleIndexInParent() == -1) {
                    xAccessibleContext = null;
                    continue;
                }
                xAccessibleContext = xAccessibleContext.getAccessibleParent().getAccessibleContext();
            }
        }
        catch (DisposedException disposedException) {
            // empty catch block
        }
        stringArray[0] = string;
        return stringArray;
    }

    public void openMethodsDialog() {
        String[] stringArray = this.getAccessibleObjProperties();
        this.m_methodDialog.initMethodDialog(stringArray[0], stringArray[1]);
        this.m_methodDialog.setVisible(true);
    }

    public void addAction() {
        Vector vector = this.m_methodDialog.getDataVector();
        this.m_actinPanel.addAction(vector);
    }
}

